/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.geotools.data.ResourceInfo;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultResourceInfo
implements ResourceInfo {
    private String title;
    private URI schema;
    private String name;
    private Set<String> keywords;
    private String description;
    private CoordinateReferenceSystem crs;
    private ReferencedEnvelope bounds;

    public DefaultResourceInfo() {
    }

    public DefaultResourceInfo(ResourceInfo copy) {
        this.title = copy.getTitle();
        this.schema = copy.getSchema();
        this.name = copy.getName();
        this.keywords = new HashSet<String>();
        if (copy.getKeywords() != null) {
            this.keywords.addAll(copy.getKeywords());
        }
        this.description = copy.getDescription();
        this.crs = copy.getCRS();
        this.bounds = copy.getBounds();
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public URI getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<String> getKeywords() {
        return this.keywords;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return this.bounds;
    }

    @Override
    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    public void setCRS(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSchema(URI schema) {
        this.schema = schema;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setKeywords(Set<String> keywords) {
        this.keywords = keywords;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBounds(ReferencedEnvelope bounds) {
        this.bounds = bounds;
    }
}

