/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.crosswalk;

import ORG.oclc.oai.server.crosswalk.Crosswalk;
import ORG.oclc.oai.server.crosswalk.CrosswalkItem;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class Crosswalks {
    private static final boolean debug = false;
    private Map crosswalksMap = new HashMap();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Properties;

    public Crosswalks(Properties properties) {
        String propertyPrefix = "Crosswalks.";
        Enumeration<?> propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            String propertyName = (String)propNames.nextElement();
            if (!propertyName.startsWith(propertyPrefix)) continue;
            String schemaLabel = propertyName.substring(propertyPrefix.length());
            String formatClassName = (String)properties.get(propertyName);
            try {
                Class<?> crosswalkClass = Class.forName(formatClassName);
                Crosswalk crosswalk = null;
                try {
                    Constructor<?> crosswalkConstructor = crosswalkClass.getConstructor(class$java$lang$String == null ? Crosswalks.class$("java.lang.String") : class$java$lang$String, class$java$util$Properties == null ? Crosswalks.class$("java.util.Properties") : class$java$util$Properties);
                    crosswalk = (Crosswalk)crosswalkConstructor.newInstance(schemaLabel, properties);
                }
                catch (NoSuchMethodException e) {
                    Constructor<?> crosswalkConstructor = crosswalkClass.getConstructor(class$java$util$Properties == null ? Crosswalks.class$("java.util.Properties") : class$java$util$Properties);
                    crosswalk = (Crosswalk)crosswalkConstructor.newInstance(properties);
                }
                CrosswalkItem crosswalkItem = new CrosswalkItem(schemaLabel, crosswalk.getSchemaURL(), crosswalk.getNamespaceURL(), crosswalk);
                this.crosswalksMap.put(schemaLabel, crosswalkItem);
            }
            catch (Exception e) {
                System.err.println("Crosswalks: couldn't construct: " + formatClassName);
                e.printStackTrace();
            }
        }
        if (this.crosswalksMap.size() == 0) {
            System.err.println("Crosswalks entries are missing from properties file");
        }
    }

    public Crosswalks(Map crosswalkItemMap) {
        Iterator iter = crosswalkItemMap.values().iterator();
        while (iter.hasNext()) {
            CrosswalkItem crosswalkItem = (CrosswalkItem)iter.next();
            String schemaLabel = crosswalkItem.getMetadataPrefix();
            this.crosswalksMap.put(schemaLabel, crosswalkItem);
        }
        if (this.crosswalksMap.size() == 0) {
            System.err.println("Crosswalks entries are missing from properties file");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            sb.append(entry.getKey());
            sb.append("=");
            CrosswalkItem crosswalkItem = (CrosswalkItem)entry.getValue();
            sb.append(crosswalkItem.getCrosswalk().toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getMetadataPrefix(String namespaceURI, String schemaURL) {
        String lookupValue = namespaceURI + " " + schemaURL;
        Iterator iterator = this.crosswalksMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((CrosswalkItem)entry.getValue()).getCrosswalk().getSchemaLocation().equals(lookupValue)) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    public String getSchemaURL(String metadataPrefix) {
        String schemaLocation = this.getSchemaLocation(metadataPrefix);
        StringTokenizer tokenizer = new StringTokenizer(schemaLocation);
        String temp = tokenizer.nextToken();
        try {
            return tokenizer.nextToken();
        }
        catch (NoSuchElementException e) {
            return temp;
        }
    }

    public String getNamespaceURI(String metadataPrefix) {
        String schemaLocation = this.getSchemaLocation(metadataPrefix);
        StringTokenizer tokenizer = new StringTokenizer(schemaLocation);
        return tokenizer.nextToken();
    }

    public String getNativeRecordSchema(String metadataPrefix) {
        CrosswalkItem crosswalkItem = (CrosswalkItem)this.crosswalksMap.get(metadataPrefix);
        if (crosswalkItem == null) {
            return null;
        }
        return crosswalkItem.getNativeRecordSchema();
    }

    public String getSchemaLocation(String metadataPrefix) {
        CrosswalkItem crosswalkItem = (CrosswalkItem)this.crosswalksMap.get(metadataPrefix);
        if (crosswalkItem != null) {
            return crosswalkItem.getCrosswalk().getSchemaLocation();
        }
        return null;
    }

    public String getContentType(String metadataPrefix) {
        CrosswalkItem crosswalkItem = (CrosswalkItem)this.crosswalksMap.get(metadataPrefix);
        if (crosswalkItem != null) {
            return crosswalkItem.getCrosswalk().getContentType();
        }
        return null;
    }

    public String getDocType(String metadataPrefix) {
        CrosswalkItem crosswalkItem = (CrosswalkItem)this.crosswalksMap.get(metadataPrefix);
        if (crosswalkItem != null) {
            return crosswalkItem.getCrosswalk().getDocType();
        }
        return null;
    }

    public String getEncoding(String metadataPrefix) {
        CrosswalkItem crosswalkItem = (CrosswalkItem)this.crosswalksMap.get(metadataPrefix);
        if (crosswalkItem != null) {
            return crosswalkItem.getCrosswalk().getEncoding();
        }
        return null;
    }

    public boolean containsValue(String metadataPrefix) {
        return this.crosswalksMap.get(metadataPrefix) != null;
    }

    public Iterator iterator() {
        return this.crosswalksMap.entrySet().iterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

