/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.type;

import java.nio.charset.Charset;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeFamily;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlCollation;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.type.ArraySqlType;
import org.apache.calcite.sql.type.BasicSqlType;
import org.apache.calcite.sql.type.IntervalSqlType;
import org.apache.calcite.sql.type.MapSqlType;
import org.apache.calcite.sql.type.MultisetSqlType;
import org.apache.calcite.sql.type.ObjectSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Util;

public class SqlTypeFactoryImpl
extends RelDataTypeFactoryImpl {
    public SqlTypeFactoryImpl(RelDataTypeSystem typeSystem) {
        super(typeSystem);
    }

    @Override
    public RelDataType createSqlType(SqlTypeName typeName) {
        if (typeName.allowsPrec()) {
            return this.createSqlType(typeName, this.typeSystem.getDefaultPrecision(typeName));
        }
        this.assertBasic(typeName);
        BasicSqlType newType = new BasicSqlType(this.typeSystem, typeName);
        return this.canonize(newType);
    }

    @Override
    public RelDataType createSqlType(SqlTypeName typeName, int precision) {
        int maxPrecision = this.typeSystem.getMaxPrecision(typeName);
        if (maxPrecision >= 0 && precision > maxPrecision) {
            precision = maxPrecision;
        }
        if (typeName.allowsScale()) {
            return this.createSqlType(typeName, precision, typeName.getDefaultScale());
        }
        this.assertBasic(typeName);
        assert (precision >= 0 || precision == -1);
        RelDataType newType = new BasicSqlType(this.typeSystem, typeName, precision);
        newType = SqlTypeUtil.addCharsetAndCollation(newType, this);
        return this.canonize(newType);
    }

    @Override
    public RelDataType createSqlType(SqlTypeName typeName, int precision, int scale) {
        this.assertBasic(typeName);
        assert (precision >= 0 || precision == -1);
        int maxPrecision = this.typeSystem.getMaxPrecision(typeName);
        if (maxPrecision >= 0 && precision > maxPrecision) {
            precision = maxPrecision;
        }
        RelDataType newType = new BasicSqlType(this.typeSystem, typeName, precision, scale);
        newType = SqlTypeUtil.addCharsetAndCollation(newType, this);
        return this.canonize(newType);
    }

    @Override
    public RelDataType createUnknownType() {
        return this.canonize(new UnknownSqlType(this));
    }

    @Override
    public RelDataType createMultisetType(RelDataType type, long maxCardinality) {
        assert (maxCardinality == -1L);
        MultisetSqlType newType = new MultisetSqlType(type, false);
        return this.canonize(newType);
    }

    @Override
    public RelDataType createArrayType(RelDataType elementType, long maxCardinality) {
        assert (maxCardinality == -1L);
        ArraySqlType newType = new ArraySqlType(elementType, false);
        return this.canonize(newType);
    }

    @Override
    public RelDataType createMapType(RelDataType keyType, RelDataType valueType) {
        MapSqlType newType = new MapSqlType(keyType, valueType, false);
        return this.canonize(newType);
    }

    @Override
    public RelDataType createSqlIntervalType(SqlIntervalQualifier intervalQualifier) {
        IntervalSqlType newType = new IntervalSqlType(this.typeSystem, intervalQualifier, false);
        return this.canonize(newType);
    }

    @Override
    public RelDataType createTypeWithCharsetAndCollation(RelDataType type, Charset charset, SqlCollation collation) {
        RelDataTypeImpl newType;
        assert (SqlTypeUtil.inCharFamily(type)) : type;
        assert (charset != null);
        assert (collation != null);
        if (type instanceof BasicSqlType) {
            BasicSqlType sqlType = (BasicSqlType)type;
            newType = sqlType.createWithCharsetAndCollation(charset, collation);
        } else if (type instanceof RelDataTypeFactoryImpl.JavaType) {
            RelDataTypeFactoryImpl.JavaType javaType = (RelDataTypeFactoryImpl.JavaType)type;
            newType = new RelDataTypeFactoryImpl.JavaType(this, javaType.getJavaClass(), javaType.isNullable(), charset, collation);
        } else {
            throw Util.needToImplement("need to implement " + type);
        }
        return this.canonize(newType);
    }

    @Override
    public RelDataType leastRestrictive(List<RelDataType> types) {
        assert (types != null);
        assert (types.size() >= 1);
        RelDataType type0 = types.get(0);
        if (type0.getSqlTypeName() != null) {
            RelDataType resultType = this.leastRestrictiveSqlType(types);
            if (resultType != null) {
                return resultType;
            }
            return this.leastRestrictiveByCast(types);
        }
        return super.leastRestrictive(types);
    }

    private RelDataType leastRestrictiveByCast(List<RelDataType> types) {
        RelDataType resultType = types.get(0);
        boolean anyNullable = resultType.isNullable();
        for (int i = 1; i < types.size(); ++i) {
            RelDataType type = types.get(i);
            if (type.getSqlTypeName() == SqlTypeName.NULL) {
                anyNullable = true;
                continue;
            }
            if (type.isNullable()) {
                anyNullable = true;
            }
            if (SqlTypeUtil.canCastFrom(type, resultType, false)) {
                resultType = type;
                continue;
            }
            if (SqlTypeUtil.canCastFrom(resultType, type, false)) continue;
            return null;
        }
        if (anyNullable) {
            return this.createTypeWithNullability(resultType, true);
        }
        return resultType;
    }

    @Override
    public RelDataType createTypeWithNullability(RelDataType type, boolean nullable) {
        RelDataType newType;
        if (type instanceof BasicSqlType) {
            newType = ((BasicSqlType)type).createWithNullability(nullable);
        } else if (type instanceof MapSqlType) {
            newType = this.copyMapType(type, nullable);
        } else if (type instanceof ArraySqlType) {
            newType = this.copyArrayType(type, nullable);
        } else if (type instanceof MultisetSqlType) {
            newType = this.copyMultisetType(type, nullable);
        } else if (type instanceof IntervalSqlType) {
            newType = this.copyIntervalType(type, nullable);
        } else if (type instanceof ObjectSqlType) {
            newType = this.copyObjectType(type, nullable);
        } else {
            return super.createTypeWithNullability(type, nullable);
        }
        return this.canonize(newType);
    }

    private void assertBasic(SqlTypeName typeName) {
        assert (typeName != null);
        assert (typeName != SqlTypeName.MULTISET) : "use createMultisetType() instead";
        assert (!SqlTypeName.INTERVAL_TYPES.contains((Object)typeName)) : "use createSqlIntervalType() instead";
    }

    private RelDataType leastRestrictiveSqlType(List<RelDataType> types) {
        RelDataType resultType = null;
        int nullCount = 0;
        int nullableCount = 0;
        int javaCount = 0;
        int anyCount = 0;
        for (RelDataType type : types) {
            SqlTypeName typeName = type.getSqlTypeName();
            if (typeName == null) {
                return null;
            }
            if (typeName == SqlTypeName.ANY) {
                ++anyCount;
            }
            if (type.isNullable()) {
                ++nullableCount;
            }
            if (typeName == SqlTypeName.NULL) {
                ++nullCount;
            }
            if (!SqlTypeFactoryImpl.isJavaType(type)) continue;
            ++javaCount;
        }
        if (anyCount > 0) {
            return this.createTypeWithNullability(this.createSqlType(SqlTypeName.ANY), nullCount > 0 || nullableCount > 0);
        }
        for (int i = 0; i < types.size(); ++i) {
            RelDataType type;
            type = types.get(i);
            RelDataTypeFamily family = type.getFamily();
            SqlTypeName typeName = type.getSqlTypeName();
            if (typeName == SqlTypeName.NULL) continue;
            if (SqlTypeFactoryImpl.isJavaType(type) && javaCount + nullCount < types.size()) {
                RelDataType originalType = type;
                type = typeName.allowsPrecScale(true, true) ? this.createSqlType(typeName, type.getPrecision(), type.getScale()) : (typeName.allowsPrecScale(true, false) ? this.createSqlType(typeName, type.getPrecision()) : this.createSqlType(typeName));
                type = this.createTypeWithNullability(type, originalType.isNullable());
            }
            if (resultType == null && (resultType = type).getSqlTypeName() == SqlTypeName.ROW) {
                return this.leastRestrictiveStructuredType(types);
            }
            RelDataTypeFamily resultFamily = resultType.getFamily();
            SqlTypeName resultTypeName = resultType.getSqlTypeName();
            if (resultFamily != family) {
                return null;
            }
            if (SqlTypeUtil.inCharOrBinaryFamilies(type)) {
                Charset charset1 = type.getCharset();
                Charset charset2 = resultType.getCharset();
                SqlCollation collation1 = type.getCollation();
                SqlCollation collation2 = resultType.getCollation();
                int precision = SqlTypeUtil.maxPrecision(resultType.getPrecision(), type.getPrecision());
                if (SqlTypeUtil.isLob(resultType)) {
                    resultType = this.createSqlType(resultType.getSqlTypeName());
                } else if (SqlTypeUtil.isLob(type)) {
                    resultType = this.createSqlType(type.getSqlTypeName());
                } else if (SqlTypeUtil.isBoundedVariableWidth(resultType)) {
                    resultType = this.createSqlType(resultType.getSqlTypeName(), precision);
                } else {
                    SqlTypeName newTypeName = type.getSqlTypeName();
                    if (this.typeSystem.shouldConvertRaggedUnionTypesToVarying() && resultType.getPrecision() != type.getPrecision()) {
                        if (newTypeName == SqlTypeName.CHAR) {
                            newTypeName = SqlTypeName.VARCHAR;
                        } else if (newTypeName == SqlTypeName.BINARY) {
                            newTypeName = SqlTypeName.VARBINARY;
                        }
                    }
                    resultType = this.createSqlType(newTypeName, precision);
                }
                Charset charset = null;
                SqlCollation collation = null;
                if (charset1 != null || charset2 != null) {
                    if (charset1 == null) {
                        charset = charset2;
                        collation = collation2;
                    } else if (charset2 == null) {
                        charset = charset1;
                        collation = collation1;
                    } else if (charset1.equals(charset2)) {
                        charset = charset1;
                        collation = collation1;
                    } else if (charset1.contains(charset2)) {
                        charset = charset1;
                        collation = collation1;
                    } else {
                        charset = charset2;
                        collation = collation2;
                    }
                }
                if (charset == null) continue;
                resultType = this.createTypeWithCharsetAndCollation(resultType, charset, collation);
                continue;
            }
            if (SqlTypeUtil.isExactNumeric(type)) {
                if (SqlTypeUtil.isExactNumeric(resultType)) {
                    RelDataType type1;
                    if (types.size() > i + 1 && SqlTypeUtil.isDatetime(type1 = types.get(i + 1))) {
                        resultType = type1;
                        return this.createTypeWithNullability(resultType, nullCount > 0 || nullableCount > 0);
                    }
                    if (type.equals(resultType)) continue;
                    if (!typeName.allowsPrec() && !resultTypeName.allowsPrec()) {
                        if (type.getPrecision() <= resultType.getPrecision()) continue;
                        resultType = type;
                        continue;
                    }
                    int p1 = resultType.getPrecision();
                    int p2 = type.getPrecision();
                    int s1 = resultType.getScale();
                    int s2 = type.getScale();
                    int maxPrecision = this.typeSystem.getMaxNumericPrecision();
                    int maxScale = this.typeSystem.getMaxNumericScale();
                    int dout = Math.max(p1 - s1, p2 - s2);
                    dout = Math.min(dout, maxPrecision);
                    int scale = Math.max(s1, s2);
                    scale = Math.min(scale, maxPrecision - dout);
                    scale = Math.min(scale, maxScale);
                    int precision = dout + scale;
                    assert (precision <= maxPrecision);
                    assert (precision > 0 || resultType.getSqlTypeName() == SqlTypeName.DECIMAL && precision == 0 && scale == 0);
                    resultType = this.createSqlType(SqlTypeName.DECIMAL, precision, scale);
                    continue;
                }
                if (SqlTypeUtil.isApproximateNumeric(resultType)) {
                    if (!SqlTypeUtil.isDecimal(type)) continue;
                    resultType = this.createDoublePrecisionType();
                    continue;
                }
                return null;
            }
            if (SqlTypeUtil.isApproximateNumeric(type)) {
                if (SqlTypeUtil.isApproximateNumeric(resultType)) {
                    if (type.getPrecision() <= resultType.getPrecision()) continue;
                    resultType = type;
                    continue;
                }
                if (SqlTypeUtil.isExactNumeric(resultType)) {
                    if (SqlTypeUtil.isDecimal(resultType)) {
                        resultType = this.createDoublePrecisionType();
                        continue;
                    }
                    resultType = type;
                    continue;
                }
                return null;
            }
            if (SqlTypeUtil.isInterval(type)) {
                RelDataType type1;
                if (types.size() > i + 1 && SqlTypeUtil.isDatetime(type1 = types.get(i + 1))) {
                    resultType = type1;
                    return this.createTypeWithNullability(resultType, nullCount > 0 || nullableCount > 0);
                }
                if (type.equals(resultType)) continue;
                type1 = resultType;
                resultType = ((IntervalSqlType)resultType).combine(this, (IntervalSqlType)type);
                resultType = ((IntervalSqlType)resultType).combine(this, (IntervalSqlType)type1);
                continue;
            }
            if (SqlTypeUtil.isDatetime(type)) {
                RelDataType type1;
                if (types.size() <= i + 1 || !SqlTypeUtil.isInterval(type1 = types.get(i + 1)) && !SqlTypeUtil.isIntType(type1)) continue;
                resultType = type;
                return this.createTypeWithNullability(resultType, nullCount > 0 || nullableCount > 0);
            }
            return null;
        }
        if (resultType != null && nullableCount > 0) {
            resultType = this.createTypeWithNullability(resultType, true);
        }
        return resultType;
    }

    private RelDataType createDoublePrecisionType() {
        return this.createSqlType(SqlTypeName.DOUBLE);
    }

    private RelDataType copyMultisetType(RelDataType type, boolean nullable) {
        MultisetSqlType mt = (MultisetSqlType)type;
        RelDataType elementType = this.copyType(mt.getComponentType());
        return new MultisetSqlType(elementType, nullable);
    }

    private RelDataType copyIntervalType(RelDataType type, boolean nullable) {
        return new IntervalSqlType(this.typeSystem, type.getIntervalQualifier(), nullable);
    }

    private RelDataType copyObjectType(RelDataType type, boolean nullable) {
        return new ObjectSqlType(type.getSqlTypeName(), type.getSqlIdentifier(), nullable, type.getFieldList(), type.getComparability());
    }

    private RelDataType copyArrayType(RelDataType type, boolean nullable) {
        ArraySqlType at = (ArraySqlType)type;
        RelDataType elementType = this.copyType(at.getComponentType());
        return new ArraySqlType(elementType, nullable);
    }

    private RelDataType copyMapType(RelDataType type, boolean nullable) {
        MapSqlType mt = (MapSqlType)type;
        RelDataType keyType = this.copyType(mt.getKeyType());
        RelDataType valueType = this.copyType(mt.getValueType());
        return new MapSqlType(keyType, valueType, nullable);
    }

    @Override
    protected RelDataType canonize(RelDataType type) {
        if (!((type = super.canonize(type)) instanceof ObjectSqlType)) {
            return type;
        }
        ObjectSqlType objectType = (ObjectSqlType)type;
        if (!objectType.isNullable()) {
            objectType.setFamily(objectType);
        } else {
            objectType.setFamily((RelDataTypeFamily)((Object)this.createTypeWithNullability(objectType, false)));
        }
        return type;
    }

    private static class UnknownSqlType
    extends BasicSqlType {
        UnknownSqlType(RelDataTypeFactory typeFactory) {
            super(typeFactory.getTypeSystem(), SqlTypeName.NULL);
        }

        @Override
        protected void generateTypeString(StringBuilder sb, boolean withDetail) {
            sb.append("UNKNOWN");
        }
    }
}

