/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotools.factory.Hints;
import org.geotools.factory.OptionalFactory;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.BufferedAuthorityFactory;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.opengis.referencing.FactoryException;

public abstract class DeferredAuthorityFactory
extends BufferedAuthorityFactory
implements OptionalFactory {
    private static final Timer TIMER = new Timer(true);
    private TimerTask disposer;
    private boolean used;

    protected DeferredAuthorityFactory(Hints userHints, int priority) {
        super(priority, 20);
    }

    protected DeferredAuthorityFactory(Hints userHints, int priority, int maxStrongReferences) {
        super(priority, maxStrongReferences);
    }

    public boolean isAvailable() {
        return super.isAvailable();
    }

    final AbstractAuthorityFactory getBackingStore() throws FactoryException {
        assert (Thread.holdsLock((Object)this));
        if (this.backingStore == null) {
            this.backingStore = this.createBackingStore();
            if (this.backingStore == null) {
                throw new FactoryNotFoundException(Errors.format((int)131));
            }
            this.completeHints();
        }
        this.used = true;
        return this.backingStore;
    }

    protected abstract AbstractAuthorityFactory createBackingStore() throws FactoryException;

    public synchronized boolean isConnected() {
        return this.backingStore != null;
    }

    public synchronized void setTimeout(long delay) {
        if (this.disposer != null) {
            this.disposer.cancel();
        }
        this.disposer = new Disposer();
        TIMER.schedule(this.disposer, delay, delay);
    }

    protected boolean canDisposeBackingStore(AbstractAuthorityFactory backingStore) {
        return true;
    }

    public synchronized void dispose() throws FactoryException {
        if (this.disposer != null) {
            this.disposer.cancel();
            this.disposer = null;
        }
        super.dispose();
    }

    private final class Disposer
    extends TimerTask {
        private Disposer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            DeferredAuthorityFactory deferredAuthorityFactory = DeferredAuthorityFactory.this;
            synchronized (deferredAuthorityFactory) {
                if (DeferredAuthorityFactory.this.used || !DeferredAuthorityFactory.this.canDisposeBackingStore(DeferredAuthorityFactory.this.backingStore)) {
                    DeferredAuthorityFactory.this.used = false;
                    return;
                }
                if (this.cancel()) {
                    DeferredAuthorityFactory.this.disposer = null;
                    if (DeferredAuthorityFactory.this.backingStore != null) {
                        try {
                            DeferredAuthorityFactory.this.backingStore.dispose();
                            DeferredAuthorityFactory.this.backingStore = null;
                        }
                        catch (FactoryException exception) {
                            DeferredAuthorityFactory.this.backingStore = null;
                            LogRecord record = Loggings.format((Level)Level.WARNING, (int)7);
                            record.setSourceMethodName("run");
                            record.setSourceClassName(Disposer.class.getName());
                            record.setThrown(exception);
                            record.setLoggerName(ReferencingFactory.LOGGER.getName());
                            ReferencingFactory.LOGGER.log(record);
                        }
                    }
                    DeferredAuthorityFactory.this.hints.remove(Hints.DATUM_AUTHORITY_FACTORY);
                    DeferredAuthorityFactory.this.hints.remove(Hints.CS_AUTHORITY_FACTORY);
                    DeferredAuthorityFactory.this.hints.remove(Hints.CRS_AUTHORITY_FACTORY);
                    DeferredAuthorityFactory.this.hints.remove(Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY);
                }
            }
        }
    }
}

