/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.util.Date;
import org.xbill.DNS.Compression;
import org.xbill.DNS.Name;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.SIGRecord;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.utils.DataByteInputStream;
import org.xbill.DNS.utils.DataByteOutputStream;
import org.xbill.DNS.utils.MyStringTokenizer;
import org.xbill.DNS.utils.base64;

public class TKEYRecord
extends Record {
    private static TKEYRecord member = new TKEYRecord();
    private Name alg;
    private Date timeInception;
    private Date timeExpire;
    private short mode;
    private short error;
    private byte[] key;
    private byte[] other;
    public static final short SERVERASSIGNED = 1;
    public static final short DIFFIEHELLMAN = 2;
    public static final short GSSAPI = 3;
    public static final short RESOLVERASSIGNED = 4;
    public static final short DELETE = 5;

    private TKEYRecord() {
    }

    private TKEYRecord(Name name, short dclass, int ttl) {
        super(name, (short)249, dclass, ttl);
    }

    static TKEYRecord getMember() {
        return member;
    }

    public TKEYRecord(Name name, short dclass, int ttl, Name alg, Date timeInception, Date timeExpire, short mode, short error, byte[] key, byte[] other) {
        this(name, dclass, ttl);
        this.alg = alg;
        this.timeInception = timeInception;
        this.timeExpire = timeExpire;
        this.mode = mode;
        this.error = error;
        this.key = key;
        this.other = other;
    }

    Record rrFromWire(Name name, short type, short dclass, int ttl, int length, DataByteInputStream in) throws IOException {
        TKEYRecord rec = new TKEYRecord(name, dclass, ttl);
        if (in == null) {
            return rec;
        }
        rec.alg = new Name(in);
        rec.timeInception = new Date(1000L * (long)in.readInt());
        rec.timeExpire = new Date(1000L * (long)in.readInt());
        rec.mode = in.readShort();
        rec.error = in.readShort();
        int keylen = in.readUnsignedShort();
        if (keylen > 0) {
            rec.key = new byte[keylen];
            in.read(rec.key);
        } else {
            rec.key = null;
        }
        int otherlen = in.readUnsignedShort();
        if (otherlen > 0) {
            rec.other = new byte[otherlen];
            in.read(rec.other);
        } else {
            rec.other = null;
        }
        return rec;
    }

    Record rdataFromString(Name name, short dclass, int ttl, MyStringTokenizer st, Name origin) throws TextParseException {
        throw new TextParseException("no text format defined for TKEY");
    }

    protected String modeString() {
        switch (this.mode) {
            case 1: {
                return "SERVERASSIGNED";
            }
            case 2: {
                return "DIFFIEHELLMAN";
            }
            case 3: {
                return "GSSAPRESOLVERASSIGNED";
            }
            case 4: {
                return "RESOLVERASSIGNED";
            }
            case 5: {
                return "DELETE";
            }
        }
        return new Short(this.mode).toString();
    }

    public String rdataToString() {
        StringBuffer sb = new StringBuffer();
        if (this.alg == null) {
            return sb.toString();
        }
        sb.append(this.alg);
        sb.append(" (\n\t");
        sb.append(SIGRecord.formatDate(this.timeInception));
        sb.append(" ");
        sb.append(SIGRecord.formatDate(this.timeExpire));
        sb.append(" ");
        sb.append(this.modeString());
        sb.append(" ");
        sb.append(Rcode.TSIGstring(this.error));
        sb.append("\n");
        if (this.key != null) {
            sb.append(base64.formatString(this.key, 64, "\t", false));
        }
        if (this.other != null) {
            sb.append(base64.formatString(this.other, 64, "\t", false));
        }
        sb.append(" )");
        return sb.toString();
    }

    public Name getAlgorithm() {
        return this.alg;
    }

    public Date getTimeInception() {
        return this.timeInception;
    }

    public Date getTimeExpire() {
        return this.timeExpire;
    }

    public short getMode() {
        return this.mode;
    }

    public short getError() {
        return this.error;
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] getOther() {
        return this.other;
    }

    void rrToWire(DataByteOutputStream out, Compression c, boolean canonical) {
        if (this.alg == null) {
            return;
        }
        this.alg.toWire(out, null, canonical);
        out.writeInt((int)(this.timeInception.getTime() / 1000L));
        out.writeInt((int)(this.timeExpire.getTime() / 1000L));
        out.writeShort(this.mode);
        out.writeShort(this.error);
        if (this.key != null) {
            out.writeShort((short)this.key.length);
            out.writeArray(this.key);
        } else {
            out.writeShort(0);
        }
        if (this.other != null) {
            out.writeShort((short)this.other.length);
            out.writeArray(this.other);
        } else {
            out.writeShort(0);
        }
    }
}

