/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.xml.ClassValidator;
import org.exolab.castor.xml.FieldValidator;
import org.exolab.castor.xml.MarshalFramework;
import org.exolab.castor.xml.NodeType;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationContext;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLClassDescriptor;
import org.exolab.castor.xml.XMLFieldDescriptor;
import org.exolab.castor.xml.XPathLocation;
import org.exolab.castor.xml.util.ClassDescriptorResolverImpl;

public class Validator
implements ClassValidator {
    public void validate(Object object) throws ValidationException {
        this.validate(object, null);
    }

    public void validate(Object object, ValidationContext context) throws ValidationException {
        if (object == null) {
            throw new ValidationException("Cannot validate a null Object.");
        }
        if (context == null) {
            context = new ValidationContext();
        }
        if (context.getResolver() == null) {
            context.setResolver(new ClassDescriptorResolverImpl());
        }
        XMLClassDescriptor classDesc = null;
        if (!MarshalFramework.isPrimitive(object.getClass())) {
            classDesc = context.getResolver().resolve(object.getClass());
        }
        if (classDesc == null) {
            return;
        }
        TypeValidator validator = classDesc.getValidator();
        XMLFieldDescriptor fieldDesc = null;
        try {
            if (validator != null) {
                validator.validate(object, context);
            } else {
                FieldDescriptor[] fields = classDesc.getFields();
                if (fields != null) {
                    int i = 0;
                    while (i < fields.length) {
                        FieldValidator fieldValidator;
                        fieldDesc = (XMLFieldDescriptor)fields[i];
                        if (fieldDesc != null && (fieldValidator = fieldDesc.getValidator()) != null) {
                            fieldValidator.validate(object, context);
                        }
                        ++i;
                    }
                }
            }
        }
        catch (ValidationException vx) {
            XPathLocation loc = (XPathLocation)vx.getLocation();
            if (loc == null) {
                loc = new XPathLocation();
                vx.setLocation(loc);
                if (fieldDesc != null) {
                    if (fieldDesc.getNodeType() == NodeType.Attribute) {
                        loc.addAttribute(fieldDesc.getXMLName());
                    } else {
                        loc.addChild(fieldDesc.getXMLName());
                    }
                }
            }
            if (classDesc.getXMLName() != null) {
                loc.addParent(classDesc.getXMLName());
            }
            throw vx;
        }
    }
}

