/*
 * Decompiled with CFR 0.152.
 */
package ORG.oclc.oai.server.catalog.helpers;

import ORG.oclc.oai.util.OAIUtil;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.SortedMap;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class RecordStringHandler
extends DefaultHandler {
    private static final boolean debug = false;
    private static final String OAI_NS = "http://www.openarchives.org/OAI/2.0/";
    private static final String DATABASE_NS = "http://www.oclc.org/pears/";
    private static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    private SortedMap nativeRecords = new TreeMap();
    private int recordFlag = 0;
    private int metadataFlag = 0;
    private StringWriter metadata = null;
    private int recordidFlag = 0;
    private StringBuffer recordid = null;
    private String schemaLocation = null;
    private int identifierFlag = 0;
    private StringBuffer identifier = null;
    private int datestampFlag = 0;
    private StringBuffer datestamp = null;
    private ArrayList setSpecs = null;
    private int setSpecFlag = 0;
    private StringBuffer setSpec = null;

    public SortedMap getNativeRecords() {
        return this.nativeRecords;
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) {
        if (OAI_NS.equals(uri) && "record".equals(localName)) {
            this.setSpecs = new ArrayList();
            ++this.recordFlag;
        }
        if (this.metadataFlag > 0) {
            this.metadata.write("<" + this.getName(localName, qName));
            if (attrs != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    String attributeName = this.getName(attrs.getLocalName(i), attrs.getQName(i));
                    this.metadata.write(" " + attributeName + "=\"" + OAIUtil.xmlEncode(attrs.getValue(i)) + "\"");
                    ++i;
                }
            }
            this.metadata.write(">");
        }
        if (this.schemaLocation == null && this.metadataFlag == 1) {
            this.schemaLocation = attrs.getValue(XSI_NS, "schemaLocation");
        }
        if (OAI_NS.equals(uri) && "metadata".equals(localName)) {
            if (this.metadata == null) {
                this.metadata = new StringWriter();
            }
            ++this.metadataFlag;
        }
        if (OAI_NS.equals(uri) && "identifier".equals(localName)) {
            if (this.identifier == null) {
                this.identifier = new StringBuffer();
            }
            ++this.identifierFlag;
        }
        if (DATABASE_NS.equals(uri) && "recordid".equals(localName)) {
            if (this.recordid == null) {
                this.recordid = new StringBuffer();
            }
            ++this.recordidFlag;
        }
        if (OAI_NS.equals(uri) && "datestamp".equals(localName)) {
            if (this.datestamp == null) {
                this.datestamp = new StringBuffer();
            }
            ++this.datestampFlag;
        }
        if (OAI_NS.equals(uri) && "setSpec".equals(localName)) {
            if (this.setSpec == null) {
                this.setSpec = new StringBuffer();
            }
            ++this.setSpecFlag;
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if (OAI_NS.equals(uri) && "identifier".equals(localName)) {
            --this.identifierFlag;
        }
        if (DATABASE_NS.equals(uri) && "recordid".equals(localName)) {
            --this.recordidFlag;
        }
        if (OAI_NS.equals(uri) && "datestamp".equals(localName)) {
            --this.datestampFlag;
        }
        if (OAI_NS.equals(uri) && "setSpec".equals(localName)) {
            this.setSpecs.add(this.setSpec.toString());
            this.setSpec = null;
            --this.setSpecFlag;
        }
        if (OAI_NS.equals(uri) && "record".equals(localName)) {
            --this.recordFlag;
            if (this.recordFlag == 0) {
                HashMap<String, Object> nativeRecord = new HashMap<String, Object>();
                nativeRecord.put("recordString", this.metadata.toString());
                nativeRecord.put("localIdentifier", this.identifier.toString());
                nativeRecord.put("recordid", this.recordid.toString());
                nativeRecord.put("schemaLocation", this.schemaLocation);
                nativeRecord.put("datestamp", this.datestamp.toString());
                nativeRecord.put("setSpecs", this.setSpecs);
                this.nativeRecords.put(this.recordid.toString().toLowerCase(), nativeRecord);
                this.setSpecs = null;
                this.identifier = null;
                this.metadata = null;
                this.recordid = null;
                this.schemaLocation = null;
                this.datestamp = null;
            }
        }
        if (OAI_NS.equals(uri) && "metadata".equals(localName)) {
            --this.metadataFlag;
        }
        if (this.metadataFlag > 0) {
            this.metadata.write("</" + this.getName(localName, qName) + ">");
        }
    }

    public void characters(char[] ch, int start, int length) {
        String s = new String(ch, start, length);
        if (this.metadataFlag > 0) {
            this.metadata.write(OAIUtil.xmlEncode(s));
        }
        if (this.identifierFlag > 0) {
            this.identifier.append(s);
        }
        if (this.recordidFlag > 0) {
            this.recordid.append(s);
        }
        if (this.datestampFlag > 0) {
            this.datestamp.append(s);
        }
        if (this.setSpecFlag > 0) {
            this.setSpec.append(s);
        }
    }

    private String getName(String s1, String s2) {
        if (s2 == null || "".equals(s2)) {
            return s1;
        }
        return s2;
    }
}

