/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lsid.server.servlet;

import com.ibm.lsid.ExpiringResponse;
import com.ibm.lsid.LSID;
import com.ibm.lsid.LSIDException;
import com.ibm.lsid.client.LSIDAuthority;
import com.ibm.lsid.server.LSIDAuthorityService;
import com.ibm.lsid.server.LSIDRequestContext;
import com.ibm.lsid.server.LSIDServerException;
import com.ibm.lsid.server.conf.ServiceConfigurationConstants;
import com.ibm.lsid.server.conf.ServiceRegistry;
import com.ibm.lsid.server.servlet.BaseServlet;
import com.ibm.lsid.soap.SOAPConstants;
import com.ibm.lsid.wsdl.HTTPLocation;
import com.ibm.lsid.wsdl.LSIDAuthorityPort;
import com.ibm.lsid.wsdl.LSIDWSDLWrapper;
import com.ibm.lsid.wsdl.SOAPLocation;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthorityServlet
extends BaseServlet
implements SOAPConstants,
ServiceConfigurationConstants {
    public void init() throws ServletException {
        super.init();
        try {
            ServletContext ctx = this.getServletContext();
            this.serviceRegistry = ServiceRegistry.getAuthorityServiceRegistry(this.serviceConfigLocation);
            ctx.setAttribute("authserviceImplRegistry", (Object)this.serviceRegistry);
        }
        catch (LSIDServerException e) {
            throw new ServletException((Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processGet(HttpServletRequest req, HttpServletResponse resp, LSIDRequestContext rc) throws LSIDException, IOException {
        if (rc.getLsid() == null) {
            PrintWriter out2 = null;
            try {
                URL url = new URL(req.getRequestURL().toString());
                String host = url.getHost();
                int port = url.getPort();
                LSID s = null;
                LSIDWSDLWrapper wrapper = new LSIDWSDLWrapper(s);
                wrapper.setAuthorityLocation((LSIDAuthorityPort)new HTTPLocation("AuthorityServiceHTTP", "HTTPPort", host, port, null));
                wrapper.setAuthorityLocation((LSIDAuthorityPort)new SOAPLocation("AuthorityServiceSOAP", "SOAPPort", "http://" + host + ":" + port + "/authority/"));
                out2 = resp.getWriter();
                out2.println(wrapper.toString());
                out2.flush();
                Object var11_16 = null;
                if (out2 == null) return;
                out2.close();
                return;
            }
            catch (Throwable throwable) {
                Object var11_17 = null;
                if (out2 == null) throw throwable;
                out2.close();
                throw throwable;
            }
        }
        OutputStream out = null;
        try {
            LSID lsid = rc.getLsid();
            if (lsid == null) {
                throw new LSIDServerException(712, "Must specify HTTP Parameter 'lsid'");
            }
            LSIDAuthorityService service = (LSIDAuthorityService)this.getServiceRegistry("authserviceImplRegistry").lookupService(lsid);
            if (service == null) {
                throw new LSIDServerException(201, "LSID Unknown: " + lsid);
            }
            String path = new URL(req.getRequestURL().toString()).getPath();
            if (path.equals("/authority/notify/")) {
                service.notifyForeignAuthority(rc, new LSIDAuthority(req.getParameter("authorityName")));
            } else if (path.equals("/authority/revoke/")) {
                service.revokeNotificationForeignAuthority(rc, new LSIDAuthority(req.getParameter("authorityName")));
            } else {
                ExpiringResponse er = service.getAvailableServices(rc);
                String wsdl = (String)er.getValue();
                out = resp.getOutputStream();
                out.write(wsdl.getBytes());
                out.flush();
            }
            Object var13_19 = null;
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            try {
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (out == null) return;
        out.close();
    }
}

