<xsl:stylesheet 
	version="1.0"
	
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">


<xsl:output method="xml" />


<xsl:template match="rdf:RDF">
	<rdf:RDF>
		<xsl:for-each select="@*">
			<xsl:copy/>
		</xsl:for-each>
		
		<xsl:apply-templates select="descendant::*"/>
	</rdf:RDF>
</xsl:template>


<xsl:template match="rdf:Description" priority="1"/>


<xsl:template match="rdf:RDF//*[not(@rdf:about or @rdf:ID)]">
	<!--
	
	This is a predicate node.  Create an rdf:Description node in the target document
	which contains this predicate.
	
	The predicate may contain either:
		an rdf:resource attribute:
			copy the attribute to the target element.
		an rdf:Description node or a typed node:
			create an rdf:resouce attribute on the target element, and set
			its value to the value of the rdf:about attribute of this child node.
		a text node:
			copy it to the target element.

	-->

	<rdf:Description>
		<xsl:attribute name="rdf:about">
			<xsl:apply-templates select="../@rdf:about|../@rdf:ID"/>
		</xsl:attribute>

		<xsl:copy>
			<xsl:choose>
				<xsl:when test="@rdf:resource">
					<xsl:attribute name="rdf:resource">
						<xsl:value-of select="@rdf:resource"/>
					</xsl:attribute>
				</xsl:when>
				<xsl:when test="*[@rdf:about]">
					<xsl:attribute name="rdf:resource">
						<xsl:value-of select="*[@rdf:about][position() = 1]/@rdf:about"/>
					</xsl:attribute>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="."/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:copy>
	</rdf:Description>
</xsl:template>


<xsl:template match="rdf:RDF//*[@rdf:about or @rdf:ID]">
	<!-- 

	This is a subject expressed as a typed node.  Convert it to an rdf:Description node with an
	rdf:type child.

	-->

	<rdf:Description>
		<xsl:attribute name="rdf:about">
			<xsl:apply-templates select="@rdf:about|@rdf:ID"/>
		</xsl:attribute>

		<rdf:type>
			<xsl:attribute name="rdf:resource">
				<xsl:value-of select="concat(namespace-uri(.), local-name())"/>
			</xsl:attribute>
		</rdf:type>
	</rdf:Description>
</xsl:template>


<xsl:template match="@rdf:ID">
	<xsl:value-of select="concat('#', .)"/>
</xsl:template>


<xsl:template match="@rdf:about">
	<xsl:value-of select="."/>
</xsl:template>

</xsl:stylesheet>