/*
 * Copyright 2006 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.dev.js.ast;

/**
 * Represents a JavaScript catch clause.
 */
public class JsCatch extends JsNode implements HasCondition {

  protected final JsCatchScope scope;

  private JsBlock body;

  private JsExpression condition;

  private final JsParameter param;

  public JsCatch(JsScope parent, String ident) {
    assert (parent != null);
    scope = new JsCatchScope(parent, ident);
    param = new JsParameter(scope.findExistingName(ident));
  }

  public JsBlock getBody() {
    return body;
  }

  public JsExpression getCondition() {
    return condition;
  }

  public JsParameter getParameter() {
    return param;
  }

  public JsScope getScope() {
    return scope;
  }

  public void setBody(JsBlock body) {
    this.body = body;
  }

  public void setCondition(JsExpression condition) {
    this.condition = condition;
  }

  public void traverse(JsVisitor v) {
    if (v.visit(this)) {
      if (condition != null) {
        condition.traverse(v);
      }
      body.traverse(v);
    }
    v.endVisit(this);
  }
}
