/*
 * Copyright 2006 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.dev.jjs.ast;

/**
 * Java field definition. 
 */
public class JField extends JVariable implements CanBeStatic, HasEnclosingType {

  private JReferenceType enclosingType;
  public JLiteral constInitializer;
  private final boolean isStatic;
  private final boolean hasInitializer;

  JField(JProgram program, JSourceInfo info, String name,
      JReferenceType enclosingType, JType type, boolean isStatic, boolean isFinal, boolean hasInitializer) {
    super(program, info, name, type, isFinal);
    this.enclosingType = enclosingType;
    this.isStatic = isStatic;
    this.hasInitializer  = hasInitializer;
  }

  public JReferenceType getEnclosingType() {
    return enclosingType;
  }

  public boolean hasInitializer() {
    return hasInitializer;
  }

  public boolean isStatic() {
    return isStatic;
  }

  public void traverse(JVisitor visitor, Context ctx) {
    if (visitor.visit(this, ctx)) {
    }
    visitor.endVisit(this, ctx);
  }

}
