/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupElement;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.internal.HtmlHeaderContainer;
import org.apache.wicket.markup.resolver.ComponentResolvers;
import org.apache.wicket.markup.resolver.IComponentResolver;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.http.WebRequest;

public class TransparentWebMarkupContainer
extends WebMarkupContainer
implements IComponentResolver {
    private static final long serialVersionUID = 1L;

    public TransparentWebMarkupContainer(String id) {
        super(id);
    }

    @Override
    public Component resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (tag instanceof WicketTag && ((WicketTag)tag).isFragmentTag()) {
            return null;
        }
        Component resolvedComponent = this.getParent().get(tag.getId());
        if (resolvedComponent != null && this.getPage().wasRendered(resolvedComponent)) {
            return null;
        }
        return resolvedComponent;
    }

    @Override
    public void internalRenderHead(HtmlHeaderContainer container) {
        if (this.isAjaxRequest() && !this.isParentRendering()) {
            this.renderHeadForInnerSiblings(container);
        }
        super.internalRenderHead(container);
    }

    private boolean isParentRendering() {
        MarkupContainer parent = this.getParent();
        return parent != null && parent.isRendering();
    }

    private boolean isAjaxRequest() {
        Request request = RequestCycle.get().getRequest();
        if (request instanceof WebRequest) {
            WebRequest webRequest = (WebRequest)request;
            return webRequest.isAjax();
        }
        return false;
    }

    private void renderHeadForInnerSiblings(HtmlHeaderContainer container) {
        MarkupStream stream = new MarkupStream(this.getMarkup());
        while (stream.isCurrentIndexInsideTheStream()) {
            MarkupElement childOpenTag = stream.nextOpenTag();
            if (!(childOpenTag instanceof ComponentTag) || stream.atCloseTag()) continue;
            ComponentTag tag = (ComponentTag)childOpenTag;
            String id = tag.getId();
            Component component = null;
            if (this.get(id) == null) {
                component = ComponentResolvers.resolveByComponentHierarchy(this, stream, tag);
            }
            if (component != null) {
                component.internalRenderHead(container);
            }
            stream.skipToMatchingCloseTag(tag);
        }
    }

    @Override
    protected Component findChildComponent(ComponentTag tag) {
        Component childComponent = super.findChildComponent(tag);
        return childComponent != null ? childComponent : this.resolve(this, null, tag);
    }
}

