/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.server.rpc.impl;

import com.google.gwt.user.client.rpc.IsSerializable;
import com.google.gwt.user.server.rpc.impl.SerializedInstanceReference;
import com.google.gwt.user.server.rpc.impl.ServerSerializableTypeOracle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.CRC32;

public class ServerSerializableTypeOracleImpl
implements ServerSerializableTypeOracle {
    private static final Map classCRC32Cache;
    private static final Map classCustomSerializerCache;
    private static final Map SERIALIZED_PRIMITIVE_TYPE_NAMES;
    private static final Set TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES;
    private String[] packagePaths;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean containsCachedSerializerForClass(Class instanceType) {
        Map map = classCustomSerializerCache;
        synchronized (map) {
            return classCustomSerializerCache.containsKey(instanceType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getCachedCRCForClass(Class instanceType) {
        Map map = classCRC32Cache;
        synchronized (map) {
            return (String)classCRC32Cache.get(instanceType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class getCachedSerializerForClass(Class instanceType) {
        Map map = classCustomSerializerCache;
        synchronized (map) {
            return (Class)classCustomSerializerCache.get(instanceType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putCachedCRCForClass(Class instanceType, String crc32) {
        Map map = classCRC32Cache;
        synchronized (map) {
            classCRC32Cache.put(instanceType, crc32);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putCachedSerializerForClass(Class instanceType, Class customFieldSerializer) {
        Map map = classCustomSerializerCache;
        synchronized (map) {
            classCustomSerializerCache.put(instanceType, customFieldSerializer);
        }
    }

    public ServerSerializableTypeOracleImpl(String[] packagePaths) {
        this.packagePaths = packagePaths;
    }

    public Field[] applyFieldSerializationPolicy(Field[] fields) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        for (int index = 0; index < fields.length; ++index) {
            Field field = fields[index];
            if (!$assertionsDisabled && field == null) {
                throw new AssertionError();
            }
            int fieldModifiers = field.getModifiers();
            if (Modifier.isStatic(fieldModifiers) || Modifier.isTransient(fieldModifiers) || Modifier.isFinal(fieldModifiers)) continue;
            fieldList.add(field);
        }
        Field[] fieldSubset = fieldList.toArray(new Field[fieldList.size()]);
        Comparator comparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                Field f1 = (Field)o1;
                Field f2 = (Field)o2;
                return f1.getName().compareTo(f2.getName());
            }
        };
        Arrays.sort(fieldSubset, 0, fieldSubset.length, comparator);
        return fieldSubset;
    }

    public SerializedInstanceReference decodeSerializedInstanceReference(String encodedSerializedInstanceReference) {
        final String[] components = encodedSerializedInstanceReference.split("/");
        return new SerializedInstanceReference(){

            public String getName() {
                return components.length > 0 ? components[0] : "";
            }

            public String getSignature() {
                return components.length > 1 ? components[1] : "";
            }
        };
    }

    public String encodeSerializedInstanceReference(Class instanceType) {
        return instanceType.getName() + "/" + this.getSerializationSignature(instanceType);
    }

    public String getSerializationSignature(Class instanceType) {
        String result = ServerSerializableTypeOracleImpl.getCachedCRCForClass(instanceType);
        if (result == null) {
            CRC32 crc = new CRC32();
            this.generateSerializationSignature(instanceType, crc);
            result = Long.toString(crc.getValue());
            ServerSerializableTypeOracleImpl.putCachedCRCForClass(instanceType, result);
        }
        return result;
    }

    public String getSerializedTypeName(Class instanceType) {
        if (instanceType.isPrimitive()) {
            return (String)SERIALIZED_PRIMITIVE_TYPE_NAMES.get(instanceType.getName());
        }
        return instanceType.getName();
    }

    public Class hasCustomFieldSerializer(Class instanceType) {
        if (!$assertionsDisabled && instanceType == null) {
            throw new AssertionError();
        }
        Class result = ServerSerializableTypeOracleImpl.getCachedSerializerForClass(instanceType);
        if (result != null) {
            return result;
        }
        if (ServerSerializableTypeOracleImpl.containsCachedSerializerForClass(instanceType)) {
            return null;
        }
        result = this.computeHasCustomFieldSerializer(instanceType);
        ServerSerializableTypeOracleImpl.putCachedSerializerForClass(instanceType, result);
        return result;
    }

    public boolean isSerializable(Class instanceType) {
        if (instanceType.isArray()) {
            return this.isSerializable(instanceType.getComponentType());
        }
        if (instanceType.isPrimitive()) {
            return true;
        }
        if (IsSerializable.class.isAssignableFrom(instanceType)) {
            return true;
        }
        return this.hasCustomFieldSerializer(instanceType) != null;
    }

    private Class computeHasCustomFieldSerializer(Class instanceType) {
        String qualifiedTypeName;
        if (!$assertionsDisabled && instanceType == null) {
            throw new AssertionError();
        }
        if (instanceType.isArray()) {
            Class<?> componentType = instanceType.getComponentType();
            qualifiedTypeName = componentType.isPrimitive() ? "java.lang." + componentType.getName() : Object.class.getName();
            qualifiedTypeName = qualifiedTypeName + "_Array";
        } else {
            qualifiedTypeName = instanceType.getName();
        }
        Class customSerializer = this.getCustomFieldSerializer(qualifiedTypeName + "_CustomFieldSerializer");
        if (customSerializer != null) {
            return customSerializer;
        }
        String simpleSerializerName = qualifiedTypeName + "_CustomFieldSerializer";
        for (int i = 0; i < this.packagePaths.length; ++i) {
            Class customSerializerClass = this.getCustomFieldSerializer(this.packagePaths[i] + "." + simpleSerializerName);
            if (customSerializerClass == null) continue;
            return customSerializerClass;
        }
        return null;
    }

    private boolean excludeImplementationFromSerializationSignature(Class instanceType) {
        return TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.contains(instanceType);
    }

    private void generateSerializationSignature(Class instanceType, CRC32 crc) {
        crc.update(this.getSerializedTypeName(instanceType).getBytes());
        if (this.excludeImplementationFromSerializationSignature(instanceType)) {
            return;
        }
        Class customSerializer = this.hasCustomFieldSerializer(instanceType);
        if (customSerializer != null) {
            this.generateSerializationSignature(customSerializer, crc);
        } else if (instanceType.isArray()) {
            this.generateSerializationSignature(instanceType.getComponentType(), crc);
        } else if (!instanceType.isPrimitive()) {
            Field[] fields = this.applyFieldSerializationPolicy(instanceType.getDeclaredFields());
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                if (!$assertionsDisabled && field == null) {
                    throw new AssertionError();
                }
                crc.update(field.getName().getBytes());
                crc.update(this.getSerializedTypeName(field.getType()).getBytes());
            }
            Class superClass = instanceType.getSuperclass();
            if (superClass != null) {
                this.generateSerializationSignature(superClass, crc);
            }
        }
    }

    private Class getCustomFieldSerializer(String qualifiedSerialzierName) {
        try {
            Class<?> customSerializerClass = Class.forName(qualifiedSerialzierName, false, this.getClass().getClassLoader());
            return customSerializerClass;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private String[] getPackagePaths() {
        return this.packagePaths;
    }

    static {
        $assertionsDisabled = !ServerSerializableTypeOracleImpl.class.desiredAssertionStatus();
        classCRC32Cache = new HashMap();
        classCustomSerializerCache = new HashMap();
        SERIALIZED_PRIMITIVE_TYPE_NAMES = new HashMap();
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES = new HashSet();
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Boolean.TYPE.getName(), "Z");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Byte.TYPE.getName(), "B");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Character.TYPE.getName(), "C");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Double.TYPE.getName(), "D");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Float.TYPE.getName(), "F");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Integer.TYPE.getName(), "I");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Long.TYPE.getName(), "J");
        SERIALIZED_PRIMITIVE_TYPE_NAMES.put(Short.TYPE.getName(), "S");
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Boolean.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Byte.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Character.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Double.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Exception.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Float.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Integer.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Long.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Object.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Short.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(String.class);
        TYPES_WHOSE_IMPLEMENTATION_IS_EXCLUDED_FROM_SIGNATURES.add(Throwable.class);
    }
}

