/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.itis;

import edu.ucsb.nceas.itis.ItisException;
import edu.ucsb.nceas.itis.ItisInterface;
import edu.ucsb.nceas.itis.ItisXmlHandler;
import edu.ucsb.nceas.itis.Taxon;
import edu.ucsb.nceas.itis.Utility;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public class Itis
implements ItisInterface {
    private String itisBase;
    private String itisSearchStub;
    private String itisTaxaStub;
    private String itisChildStub;
    private String itisParentStub;
    private Hashtable tsnCache;
    private Hashtable nameCache;

    public Itis() {
        this.loadConfigurationParameters();
        this.tsnCache = new Hashtable();
        this.nameCache = new Hashtable();
    }

    public long findTaxonTsn(String string) throws ItisException {
        long l = 0L;
        Taxon taxon = null;
        if (this.nameCache.containsKey(string)) {
            Utility.debug(9, "Reading data from cache.");
            taxon = (Taxon)this.nameCache.get(string);
        } else {
            Utility.debug(9, "Reading data from ITIS.");
            URL uRL = null;
            try {
                uRL = new URL(this.itisBase + this.itisSearchStub + string);
            }
            catch (MalformedURLException malformedURLException) {
                Utility.debug(1, "URL for ITIS is invalid.");
                throw new ItisException("URL for ITIS is invalid.");
            }
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
                taxon = this.parseAndCacheTaxa(inputStreamReader);
            }
            catch (IOException iOException) {
                Utility.debug(9, "Error reading from connection to ITIS.");
                throw new ItisException("Error reading from connection to ITIS.");
            }
        }
        if (taxon != null) {
            l = taxon.getTsn();
        }
        return l;
    }

    public Taxon getTaxon(long l) throws ItisException {
        Taxon taxon = null;
        Long l2 = new Long(l);
        if (this.tsnCache.containsKey(l2)) {
            Utility.debug(9, "Reading data from cache.");
            taxon = (Taxon)this.tsnCache.get(l2);
        }
        if (taxon == null || !taxon.isDataComplete()) {
            Utility.debug(9, "Reading data from ITIS.");
            URL uRL = null;
            try {
                uRL = new URL(this.itisBase + this.itisTaxaStub + l);
            }
            catch (MalformedURLException malformedURLException) {
                Utility.debug(1, "URL for ITIS is invalid.");
                throw new ItisException("URL for ITIS is invalid.");
            }
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
                taxon = this.parseAndCacheTaxa(inputStreamReader);
            }
            catch (IOException iOException) {
                Utility.debug(9, "Error reading from connection to ITIS.");
                throw new ItisException("Error reading from connection to ITIS.");
            }
        }
        return taxon;
    }

    public String getScientificName(long l) throws ItisException {
        String string = null;
        Taxon taxon = this.getTaxon(l);
        if (taxon != null) {
            string = taxon.getScientificName();
        }
        return string;
    }

    public long getParentTsn(long l) throws ItisException {
        long l2 = 0L;
        Taxon taxon = this.getTaxon(l);
        if (taxon != null) {
            l2 = taxon.getParentTsn();
        }
        return l2;
    }

    public Vector getChildTsnList(long l) throws ItisException {
        Serializable serializable;
        Taxon taxon = null;
        Long l2 = new Long(l);
        if (this.tsnCache.containsKey(l2)) {
            Utility.debug(9, "Reading data from cache.");
            taxon = (Taxon)this.tsnCache.get(l2);
        }
        if (taxon == null || !taxon.hasChildList()) {
            Utility.debug(9, "Reading child data from ITIS.");
            serializable = null;
            try {
                serializable = new URL(this.itisBase + this.itisChildStub + l);
            }
            catch (MalformedURLException malformedURLException) {
                Utility.debug(1, "URL for ITIS is invalid.");
                throw new ItisException("URL for ITIS is invalid.");
            }
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(((URL)serializable).openStream());
                taxon = this.parseAndCacheTaxa(inputStreamReader);
            }
            catch (IOException iOException) {
                Utility.debug(9, "Error reading from connection to ITIS.");
                throw new ItisException("Error reading from connection to ITIS.");
            }
        }
        serializable = taxon.getChildTsn();
        return serializable;
    }

    public Vector getSynonymTsnList(long l) throws ItisException {
        Vector vector = null;
        Taxon taxon = this.getTaxon(l);
        if (taxon != null) {
            vector = taxon.getSynonymTsn();
        }
        return vector;
    }

    private Taxon parseAndCacheTaxa(Reader reader) throws ItisException {
        ItisXmlHandler itisXmlHandler = new ItisXmlHandler();
        Vector vector = itisXmlHandler.parseTaxa(reader);
        Taxon taxon = null;
        int n = 0;
        while (n < vector.size()) {
            Taxon taxon2 = (Taxon)vector.get(n);
            if (taxon2 != null) {
                long l = taxon2.getTsn();
                this.tsnCache.put(new Long(l), taxon2);
                if (taxon2.getScientificName() != null) {
                    this.nameCache.put(taxon2.getScientificName(), taxon2);
                }
                Utility.debug(20, "Taxa found: " + l + "(" + n + ")");
                if (n == vector.size() - 1) {
                    taxon = taxon2;
                }
            }
            ++n;
        }
        return taxon;
    }

    private void loadConfigurationParameters() {
        this.itisBase = "http://sis.agr.gc.ca/pls/itisca";
        this.itisSearchStub = "/taxastep?hierarchy=no&king=every&p_action=exactly+for&p_format=xml&taxa=";
        this.itisTaxaStub = "/next?p_format=xml&v_tsn=";
        this.itisChildStub = "/taxa_xml.child?p_type=y&p_tsn=";
        this.itisParentStub = "/taxa_xml.upwards?p_type=y&p_tsn=";
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Wrong number of arguments!!!");
            System.err.println("USAGE: java Itis <phrase>");
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n < stringArray.length - 1) {
                stringBuffer.append("+");
            }
            ++n;
        }
        String string = stringBuffer.toString();
        try {
            Itis itis = new Itis();
            Utility.debug(8, " ");
            Utility.debug(8, "Searching for: " + string);
            long l = itis.findTaxonTsn(string);
            Utility.debug(8, "TSN found is: " + l);
            Utility.debug(8, " ");
            Utility.debug(8, "Getting taxon...");
            Taxon taxon = itis.getTaxon(l);
            if (taxon != null) {
                Utility.debug(8, "            TSN: " + taxon.getTsn());
                Utility.debug(8, "Scientific Name: " + taxon.getScientificName());
                Utility.debug(8, "           Rank: " + taxon.getTaxonRank());
            }
            long l2 = taxon.getParentTsn();
            Utility.debug(8, " ");
            Utility.debug(8, "Getting parent (" + l2 + ") ...");
            Taxon taxon2 = itis.getTaxon(l2);
            if (taxon2 != null) {
                Utility.debug(8, "            TSN: " + taxon2.getTsn());
                Utility.debug(8, "Scientific Name: " + taxon2.getScientificName());
                Utility.debug(8, "           Rank: " + taxon2.getTaxonRank());
            }
            Utility.debug(8, " ");
            Utility.debug(8, "Getting synonym taxa for " + l + " ...");
            Vector vector = itis.getSynonymTsnList(l);
            int n2 = 0;
            while (n2 < vector.size()) {
                long l3 = (Long)vector.get(n2);
                Utility.debug(8, " ");
                Utility.debug(8, "      Synonym TSN: " + l3);
                Taxon taxon3 = itis.getTaxon(l3);
                if (taxon3 != null) {
                    Utility.debug(8, "              TSN: " + taxon3.getTsn());
                    Utility.debug(8, "  Scientific Name: " + taxon3.getScientificName());
                    Utility.debug(8, "             Rank: " + taxon3.getTaxonRank());
                }
                ++n2;
            }
            Utility.debug(8, " ");
            Utility.debug(8, "Getting child taxa for " + l + " ...");
            Vector vector2 = itis.getChildTsnList(l);
            int n3 = 0;
            while (n3 < vector2.size()) {
                long l4 = (Long)vector2.get(n3);
                Utility.debug(8, " ");
                Utility.debug(8, "      Child TSN: " + l4);
                Taxon taxon4 = itis.getTaxon(l4);
                if (taxon4 != null) {
                    Utility.debug(8, "              TSN: " + taxon4.getTsn());
                    Utility.debug(8, "  Scientific Name: " + taxon4.getScientificName());
                    Utility.debug(8, "             Rank: " + taxon4.getTaxonRank());
                }
                ++n3;
            }
        }
        catch (ItisException itisException) {
            Utility.debug(8, "Error generated while querying Itis");
            Utility.debug(8, itisException.getMessage());
        }
    }
}

