/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.ScrollListener;
import com.google.gwt.user.client.ui.ScrollListenerCollection;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.SourcesScrollEvents;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;

public class ScrollPanel
extends SimplePanel
implements SourcesScrollEvents {
    private ScrollListenerCollection scrollListeners;

    public ScrollPanel() {
        this.setAlwaysShowScrollBars(false);
        this.sinkEvents(16384);
    }

    public ScrollPanel(Widget child) {
        this();
        this.setWidget(child);
    }

    public void addScrollListener(ScrollListener listener) {
        if (this.scrollListeners == null) {
            this.scrollListeners = new ScrollListenerCollection();
        }
        this.scrollListeners.add(listener);
    }

    public void ensureVisible(UIObject item) {
        Element scroll = this.getElement();
        Element element = item.getElement();
        this.ensureVisibleImpl(scroll, element);
    }

    public int getHorizontalScrollPosition() {
        return DOM.getIntAttribute(this.getElement(), "scrollLeft");
    }

    public int getScrollPosition() {
        return DOM.getIntAttribute(this.getElement(), "scrollTop");
    }

    public void onBrowserEvent(Event event) {
        if (DOM.eventGetType(event) == 16384 && this.scrollListeners != null) {
            this.scrollListeners.fireScroll(this, this.getHorizontalScrollPosition(), this.getScrollPosition());
        }
    }

    public void removeScrollListener(ScrollListener listener) {
        if (this.scrollListeners != null) {
            this.scrollListeners.remove(listener);
        }
    }

    public void setAlwaysShowScrollBars(boolean alwaysShow) {
        DOM.setStyleAttribute(this.getElement(), "overflow", alwaysShow ? "scroll" : "auto");
    }

    public void setHorizontalScrollPosition(int position) {
        DOM.setIntAttribute(this.getElement(), "scrollLeft", position);
    }

    public void setScrollPosition(int position) {
        DOM.setIntAttribute(this.getElement(), "scrollTop", position);
    }

    private native void ensureVisibleImpl(Element var1, Element var2);
}

