/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.buffer;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateList;

public class BufferInputLineSimplifier {
    private Coordinate[] inputLine;
    private double distanceTol;
    private boolean[] isDeleted;
    private int angleOrientation = 1;

    public static Coordinate[] simplify(Coordinate[] inputLine, double distanceTol) {
        BufferInputLineSimplifier simp = new BufferInputLineSimplifier(inputLine);
        return simp.simplify(distanceTol);
    }

    public BufferInputLineSimplifier(Coordinate[] inputLine) {
        this.inputLine = inputLine;
    }

    public Coordinate[] simplify(double distanceTol) {
        this.distanceTol = Math.abs(distanceTol);
        if (distanceTol < 0.0) {
            this.angleOrientation = -1;
        }
        this.isDeleted = new boolean[this.inputLine.length];
        boolean isChanged = false;
        while (isChanged = this.deleteShallowConcavities()) {
        }
        return this.collapseLine();
    }

    private boolean deleteShallowConcavities() {
        int index = 1;
        int maxIndex = this.inputLine.length - 1;
        int midIndex = this.findNextValidIndex(index);
        int lastIndex = this.findNextValidIndex(midIndex);
        boolean isChanged = false;
        while (lastIndex < maxIndex) {
            if (this.isShallowConcavity(this.inputLine[index], this.inputLine[midIndex], this.inputLine[lastIndex], this.distanceTol)) {
                this.isDeleted[midIndex] = true;
                isChanged = true;
            }
            index = lastIndex;
            midIndex = this.findNextValidIndex(index);
            lastIndex = this.findNextValidIndex(midIndex);
        }
        return isChanged;
    }

    private int findNextValidIndex(int index) {
        int next;
        for (next = index + 1; next < this.inputLine.length - 1 && this.isDeleted[next]; ++next) {
        }
        return next;
    }

    private Coordinate[] collapseLine() {
        CoordinateList coordList = new CoordinateList();
        for (int i = 0; i < this.inputLine.length; ++i) {
            if (this.isDeleted[i]) continue;
            coordList.add(this.inputLine[i]);
        }
        return coordList.toCoordinateArray();
    }

    private boolean isShallowConcavity(Coordinate p0, Coordinate p1, Coordinate p2, double distanceTol) {
        boolean isAngleToSimplify;
        int orientation = CGAlgorithms.computeOrientation(p0, p1, p2);
        boolean bl = isAngleToSimplify = orientation == this.angleOrientation;
        if (!isAngleToSimplify) {
            return false;
        }
        double dist = CGAlgorithms.distancePointLine(p1, p0, p2);
        return dist < distanceTol;
    }
}

