/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram;

import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;

public class StateDiagram
extends AbstractEntityDiagram {
    private boolean hideEmptyDescription = false;

    public IEntity getOrCreateClass(String string) {
        if (string.startsWith("[*]")) {
            throw new IllegalArgumentException();
        }
        if (this.isGroup(string)) {
            return this.getGroup(string).getEntityCluster();
        }
        IEntity iEntity = this.getOrCreateEntity(string, EntityType.STATE);
        return iEntity;
    }

    public IEntity getStart() {
        Group group = this.getCurrentGroup();
        if (group == null) {
            return this.getOrCreateEntity("*start", EntityType.CIRCLE_START);
        }
        return this.getOrCreateEntity("*start*" + group.getCode(), EntityType.CIRCLE_START);
    }

    public IEntity getEnd() {
        Group group = this.getCurrentGroup();
        if (group == null) {
            return this.getOrCreateEntity("*end", EntityType.CIRCLE_END);
        }
        return this.getOrCreateEntity("*end*" + group.getCode(), EntityType.CIRCLE_END);
    }

    public boolean concurrentState() {
        Group group = this.getCurrentGroup();
        if (group != null && group.getType() == GroupType.CONCURRENT_STATE) {
            super.endGroup();
        }
        Group group2 = this.getOrCreateGroup("CONC" + UniqueSequence.getValue(), "", null, GroupType.CONCURRENT_STATE, this.getCurrentGroup());
        group2.setDashed(true);
        if (group != null && group.getType() == GroupType.STATE) {
            group.moveEntitiesTo(group2);
            super.endGroup();
            Group group3 = this.getOrCreateGroup("CONC" + UniqueSequence.getValue(), "", null, GroupType.CONCURRENT_STATE, this.getCurrentGroup());
            group3.setDashed(true);
        }
        return true;
    }

    public void endGroup() {
        Group group = this.getCurrentGroup();
        if (group != null && group.getType() == GroupType.CONCURRENT_STATE) {
            super.endGroup();
        }
        super.endGroup();
    }

    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.STATE;
    }

    public final void setHideEmptyDescription(boolean bl) {
        this.hideEmptyDescription = bl;
    }

    public final boolean isHideEmptyDescription() {
        return this.hideEmptyDescription;
    }
}

