/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sourceforge.plantuml.ugraphic.ColorChangerMonochrome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlColor {
    private static final Map<String, String> htmlNames = new HashMap<String, String>();
    private static final Set<String> names = new TreeSet<String>();
    private final Color color;
    private final boolean monochrome;
    public static final HtmlColor BLACK;
    public static final HtmlColor WHITE;
    public static final HtmlColor RED;
    public static final HtmlColor GREEN;
    public static final HtmlColor BLUE;
    public static final HtmlColor GRAY;
    public static final HtmlColor LIGHT_GRAY;

    private static void register(String string, String string2) {
        htmlNames.put(string.toLowerCase(), string2);
        names.add(string);
    }

    private HtmlColor(String string) {
        if (string.matches("#[0-9A-Fa-f]{6}")) {
            this.color = new Color(Integer.parseInt(string.substring(1), 16));
        } else {
            String string2 = htmlNames.get(string = HtmlColor.removeFirstDieseAndToLowercase(string));
            if (string2 == null) {
                throw new IllegalArgumentException(string);
            }
            this.color = new Color(Integer.parseInt(string2.substring(1), 16));
        }
        this.monochrome = false;
        assert (HtmlColor.isValid(string));
    }

    private HtmlColor(Color color, boolean bl) {
        this.color = color;
        this.monochrome = bl;
    }

    public static boolean isValid(String string) {
        if (string.matches("#[0-9A-Fa-f]{6}")) {
            return true;
        }
        return htmlNames.containsKey(string = HtmlColor.removeFirstDieseAndToLowercase(string));
    }

    public static HtmlColor getColorIfValid(String string) {
        if (string == null || !HtmlColor.isValid(string)) {
            return null;
        }
        return new HtmlColor(string);
    }

    private static String removeFirstDieseAndToLowercase(String string) {
        if ((string = string.toLowerCase()).startsWith("#")) {
            string = string.substring(1);
        }
        return string;
    }

    public Color getColor999() {
        return this.color;
    }

    public HtmlColor asMonochrome() {
        if (this.monochrome) {
            throw new IllegalStateException();
        }
        return new HtmlColor(new ColorChangerMonochrome().getChangedColor(this.color), true);
    }

    public static Collection<String> names() {
        return Collections.unmodifiableSet(names);
    }

    static {
        HtmlColor.register("AliceBlue", "#F0F8FF");
        HtmlColor.register("AntiqueWhite", "#FAEBD7");
        HtmlColor.register("Aqua", "#00FFFF");
        HtmlColor.register("Aquamarine", "#7FFFD4");
        HtmlColor.register("Azure", "#F0FFFF");
        HtmlColor.register("Beige", "#F5F5DC");
        HtmlColor.register("Bisque", "#FFE4C4");
        HtmlColor.register("Black", "#000000");
        HtmlColor.register("BlanchedAlmond", "#FFEBCD");
        HtmlColor.register("Blue", "#0000FF");
        HtmlColor.register("BlueViolet", "#8A2BE2");
        HtmlColor.register("Brown", "#A52A2A");
        HtmlColor.register("BurlyWood", "#DEB887");
        HtmlColor.register("CadetBlue", "#5F9EA0");
        HtmlColor.register("Chartreuse", "#7FFF00");
        HtmlColor.register("Chocolate", "#D2691E");
        HtmlColor.register("Coral", "#FF7F50");
        HtmlColor.register("CornflowerBlue", "#6495ED");
        HtmlColor.register("Cornsilk", "#FFF8DC");
        HtmlColor.register("Crimson", "#DC143C");
        HtmlColor.register("Cyan", "#00FFFF");
        HtmlColor.register("DarkBlue", "#00008B");
        HtmlColor.register("DarkCyan", "#008B8B");
        HtmlColor.register("DarkGoldenRod", "#B8860B");
        HtmlColor.register("DarkGray", "#A9A9A9");
        HtmlColor.register("DarkGrey", "#A9A9A9");
        HtmlColor.register("DarkGreen", "#006400");
        HtmlColor.register("DarkKhaki", "#BDB76B");
        HtmlColor.register("DarkMagenta", "#8B008B");
        HtmlColor.register("DarkOliveGreen", "#556B2F");
        HtmlColor.register("Darkorange", "#FF8C00");
        HtmlColor.register("DarkOrchid", "#9932CC");
        HtmlColor.register("DarkRed", "#8B0000");
        HtmlColor.register("DarkSalmon", "#E9967A");
        HtmlColor.register("DarkSeaGreen", "#8FBC8F");
        HtmlColor.register("DarkSlateBlue", "#483D8B");
        HtmlColor.register("DarkSlateGray", "#2F4F4F");
        HtmlColor.register("DarkSlateGrey", "#2F4F4F");
        HtmlColor.register("DarkTurquoise", "#00CED1");
        HtmlColor.register("DarkViolet", "#9400D3");
        HtmlColor.register("DeepPink", "#FF1493");
        HtmlColor.register("DeepSkyBlue", "#00BFFF");
        HtmlColor.register("DimGray", "#696969");
        HtmlColor.register("DimGrey", "#696969");
        HtmlColor.register("DodgerBlue", "#1E90FF");
        HtmlColor.register("FireBrick", "#B22222");
        HtmlColor.register("FloralWhite", "#FFFAF0");
        HtmlColor.register("ForestGreen", "#228B22");
        HtmlColor.register("Fuchsia", "#FF00FF");
        HtmlColor.register("Gainsboro", "#DCDCDC");
        HtmlColor.register("GhostWhite", "#F8F8FF");
        HtmlColor.register("Gold", "#FFD700");
        HtmlColor.register("GoldenRod", "#DAA520");
        HtmlColor.register("Gray", "#808080");
        HtmlColor.register("Grey", "#808080");
        HtmlColor.register("Green", "#008000");
        HtmlColor.register("GreenYellow", "#ADFF2F");
        HtmlColor.register("HoneyDew", "#F0FFF0");
        HtmlColor.register("HotPink", "#FF69B4");
        HtmlColor.register("IndianRed", "#CD5C5C");
        HtmlColor.register("Indigo", "#4B0082");
        HtmlColor.register("Ivory", "#FFFFF0");
        HtmlColor.register("Khaki", "#F0E68C");
        HtmlColor.register("Lavender", "#E6E6FA");
        HtmlColor.register("LavenderBlush", "#FFF0F5");
        HtmlColor.register("LawnGreen", "#7CFC00");
        HtmlColor.register("LemonChiffon", "#FFFACD");
        HtmlColor.register("LightBlue", "#ADD8E6");
        HtmlColor.register("LightCoral", "#F08080");
        HtmlColor.register("LightCyan", "#E0FFFF");
        HtmlColor.register("LightGoldenRodYellow", "#FAFAD2");
        HtmlColor.register("LightGray", "#D3D3D3");
        HtmlColor.register("LightGrey", "#D3D3D3");
        HtmlColor.register("LightGreen", "#90EE90");
        HtmlColor.register("LightPink", "#FFB6C1");
        HtmlColor.register("LightSalmon", "#FFA07A");
        HtmlColor.register("LightSeaGreen", "#20B2AA");
        HtmlColor.register("LightSkyBlue", "#87CEFA");
        HtmlColor.register("LightSlateGray", "#778899");
        HtmlColor.register("LightSlateGrey", "#778899");
        HtmlColor.register("LightSteelBlue", "#B0C4DE");
        HtmlColor.register("LightYellow", "#FFFFE0");
        HtmlColor.register("Lime", "#00FF00");
        HtmlColor.register("LimeGreen", "#32CD32");
        HtmlColor.register("Linen", "#FAF0E6");
        HtmlColor.register("Magenta", "#FF00FF");
        HtmlColor.register("Maroon", "#800000");
        HtmlColor.register("MediumAquaMarine", "#66CDAA");
        HtmlColor.register("MediumBlue", "#0000CD");
        HtmlColor.register("MediumOrchid", "#BA55D3");
        HtmlColor.register("MediumPurple", "#9370D8");
        HtmlColor.register("MediumSeaGreen", "#3CB371");
        HtmlColor.register("MediumSlateBlue", "#7B68EE");
        HtmlColor.register("MediumSpringGreen", "#00FA9A");
        HtmlColor.register("MediumTurquoise", "#48D1CC");
        HtmlColor.register("MediumVioletRed", "#C71585");
        HtmlColor.register("MidnightBlue", "#191970");
        HtmlColor.register("MintCream", "#F5FFFA");
        HtmlColor.register("MistyRose", "#FFE4E1");
        HtmlColor.register("Moccasin", "#FFE4B5");
        HtmlColor.register("NavajoWhite", "#FFDEAD");
        HtmlColor.register("Navy", "#000080");
        HtmlColor.register("OldLace", "#FDF5E6");
        HtmlColor.register("Olive", "#808000");
        HtmlColor.register("OliveDrab", "#6B8E23");
        HtmlColor.register("Orange", "#FFA500");
        HtmlColor.register("OrangeRed", "#FF4500");
        HtmlColor.register("Orchid", "#DA70D6");
        HtmlColor.register("PaleGoldenRod", "#EEE8AA");
        HtmlColor.register("PaleGreen", "#98FB98");
        HtmlColor.register("PaleTurquoise", "#AFEEEE");
        HtmlColor.register("PaleVioletRed", "#D87093");
        HtmlColor.register("PapayaWhip", "#FFEFD5");
        HtmlColor.register("PeachPuff", "#FFDAB9");
        HtmlColor.register("Peru", "#CD853F");
        HtmlColor.register("Pink", "#FFC0CB");
        HtmlColor.register("Plum", "#DDA0DD");
        HtmlColor.register("PowderBlue", "#B0E0E6");
        HtmlColor.register("Purple", "#800080");
        HtmlColor.register("Red", "#FF0000");
        HtmlColor.register("RosyBrown", "#BC8F8F");
        HtmlColor.register("RoyalBlue", "#4169E1");
        HtmlColor.register("SaddleBrown", "#8B4513");
        HtmlColor.register("Salmon", "#FA8072");
        HtmlColor.register("SandyBrown", "#F4A460");
        HtmlColor.register("SeaGreen", "#2E8B57");
        HtmlColor.register("SeaShell", "#FFF5EE");
        HtmlColor.register("Sienna", "#A0522D");
        HtmlColor.register("Silver", "#C0C0C0");
        HtmlColor.register("SkyBlue", "#87CEEB");
        HtmlColor.register("SlateBlue", "#6A5ACD");
        HtmlColor.register("SlateGray", "#708090");
        HtmlColor.register("SlateGrey", "#708090");
        HtmlColor.register("Snow", "#FFFAFA");
        HtmlColor.register("SpringGreen", "#00FF7F");
        HtmlColor.register("SteelBlue", "#4682B4");
        HtmlColor.register("Tan", "#D2B48C");
        HtmlColor.register("Teal", "#008080");
        HtmlColor.register("Thistle", "#D8BFD8");
        HtmlColor.register("Tomato", "#FF6347");
        HtmlColor.register("Turquoise", "#40E0D0");
        HtmlColor.register("Violet", "#EE82EE");
        HtmlColor.register("Wheat", "#F5DEB3");
        HtmlColor.register("White", "#FFFFFF");
        HtmlColor.register("WhiteSmoke", "#F5F5F5");
        HtmlColor.register("Yellow", "#FFFF00");
        HtmlColor.register("YellowGreen", "#9ACD32");
        BLACK = HtmlColor.getColorIfValid("black");
        WHITE = HtmlColor.getColorIfValid("white");
        RED = HtmlColor.getColorIfValid("#FF0000");
        GREEN = HtmlColor.getColorIfValid("#00FF00");
        BLUE = HtmlColor.getColorIfValid("#0000FF");
        GRAY = HtmlColor.getColorIfValid("#808080");
        LIGHT_GRAY = HtmlColor.getColorIfValid("#C0C0C0");
    }
}

