/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.graph.ALink;
import net.sourceforge.plantuml.graph.ANode;
import net.sourceforge.plantuml.graph.AbstractEntityImage;
import net.sourceforge.plantuml.graph.Board;
import net.sourceforge.plantuml.graph.Elastane;
import net.sourceforge.plantuml.graph.EntityImageFactory;
import net.sourceforge.plantuml.graph.Galaxy4;
import net.sourceforge.plantuml.graphic.StringBounderUtils;

public class Graph2 {
    private static final Graphics2D dummyGraphics2D;
    private final Elastane elastane;
    private int widthCell;
    private int heightCell;

    public Graph2(Board board) {
        board.normalize();
        for (ANode arrayList2 : board.getNodes()) {
            Dimension2D dimension2D = this.images(arrayList2).getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D));
            this.widthCell = Math.max(this.widthCell, (int)dimension2D.getWidth());
            this.heightCell = Math.max(this.heightCell, (int)dimension2D.getHeight());
        }
        Galaxy4 galaxy4 = new Galaxy4(board, this.widthCell, this.heightCell);
        this.elastane = new Elastane(galaxy4);
        for (ANode aNode : board.getNodes()) {
            Dimension2D dimension2D = this.images(aNode).getDimension(StringBounderUtils.asStringBounder(dummyGraphics2D));
            this.elastane.addBox(aNode, (int)dimension2D.getWidth(), (int)dimension2D.getHeight());
        }
        ArrayList<? extends ALink> arrayList = new ArrayList<ALink>(board.getLinks());
        Collections.sort(arrayList, board.getLinkComparator());
        for (ALink aLink : arrayList) {
            galaxy4.addLink(aLink);
        }
        this.elastane.init();
    }

    private AbstractEntityImage images(ANode aNode) {
        return new EntityImageFactory().createEntityImage((Entity)aNode.getUserData());
    }

    public Dimension2D getDimension() {
        return this.elastane.getDimension();
    }

    public void draw(Graphics2D graphics2D) {
        this.elastane.draw(graphics2D);
    }

    static {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, Color.WHITE);
        dummyGraphics2D = emptyImageBuilder.getGraphics2D();
    }
}

