/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.objectdiagram.AbstractClassOrObjectDiagram;

public class ClassDiagram
extends AbstractClassOrObjectDiagram {
    public IEntity getOrCreateEntity(String string, EntityType entityType) {
        assert (entityType == EntityType.ABSTRACT_CLASS || entityType == EntityType.CLASS || entityType == EntityType.INTERFACE || entityType == EntityType.ENUM || entityType == EntityType.LOLLIPOP || entityType == EntityType.POINT_FOR_ASSOCIATION);
        if (super.entityExist(string = this.getFullyQualifiedCode(string))) {
            return super.getOrCreateEntity(string, entityType);
        }
        return this.createEntityWithNamespace(string, this.getShortName(string), entityType);
    }

    public Entity createEntity(String string, String string2, EntityType entityType) {
        if (entityType != EntityType.ABSTRACT_CLASS && entityType != EntityType.CLASS && entityType != EntityType.INTERFACE && entityType != EntityType.ENUM && entityType != EntityType.LOLLIPOP) {
            return super.createEntity(string, string2, entityType);
        }
        if (super.entityExist(string = this.getFullyQualifiedCode(string))) {
            throw new IllegalArgumentException("Already known: " + string);
        }
        return this.createEntityWithNamespace(string, string2, entityType);
    }

    private Entity createEntityWithNamespace(String string, String string2, EntityType entityType) {
        Group group = this.getCurrentGroup();
        String string3 = this.getNamespace(string);
        if (!(string3 == null || group != null && group.getCode().equals(string3))) {
            group = this.getOrCreateGroupInternal(string3, string3, string3, GroupType.PACKAGE, null);
            group.setBold(true);
        }
        return this.createEntityInternal(string, string2 == null ? this.getShortName(string) : string2, entityType, group);
    }

    public final boolean entityExist(String string) {
        return super.entityExist(this.getFullyQualifiedCode(string));
    }

    public IEntity getOrCreateClass(String string) {
        return this.getOrCreateEntity(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string), EntityType.CLASS);
    }

    public final IEntity getOrCreateClass(String string, EntityType entityType) {
        if (entityType != EntityType.ABSTRACT_CLASS && entityType != EntityType.CLASS && entityType != EntityType.INTERFACE && entityType != EntityType.ENUM && entityType != EntityType.LOLLIPOP) {
            throw new IllegalArgumentException();
        }
        return this.getOrCreateEntity(string, entityType);
    }

    private String getFullyQualifiedCode(String string) {
        if (string.startsWith("\\") || string.startsWith("~") || string.startsWith(".")) {
            return string.substring(1);
        }
        if (string.contains(".")) {
            return string;
        }
        Group group = this.getCurrentGroup();
        if (group == null) {
            return string;
        }
        String string2 = group.getNamespace();
        if (string2 == null) {
            return string;
        }
        return string2 + "." + string;
    }

    private String getShortName(String string) {
        String string2 = this.getNamespace(string);
        if (string2 == null) {
            return string;
        }
        return string.substring(string2.length() + 1);
    }

    private String getNamespace(String string) {
        int n;
        assert (!string.startsWith("\\"));
        assert (!string.startsWith("~"));
        do {
            if ((n = string.lastIndexOf(46)) != -1) continue;
            return null;
        } while (this.entityExist(string = string.substring(0, n)));
        return string;
    }

    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.CLASS;
    }
}

