/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Dimension2D;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.cucadiagram.dot.DrawFile;
import net.sourceforge.plantuml.cucadiagram.dot.Lazy;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.UDrawable;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;

public class CircledCharacter
implements UDrawable,
TextBlock {
    private final String c;
    private final UFont font;
    private final HtmlColor innerCircle;
    private final HtmlColor circle;
    private final HtmlColor fontColor;
    private final double radius;

    public CircledCharacter(char c, double d, UFont uFont, HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3) {
        this.c = "" + c;
        this.radius = d;
        this.font = uFont;
        this.innerCircle = htmlColor;
        this.circle = htmlColor2;
        this.fontColor = htmlColor3;
    }

    public void draw(ColorMapper colorMapper, Graphics2D graphics2D, int n, int n2, double d) {
        this.drawU(new UGraphicG2d(colorMapper, graphics2D, null, 1.0), n, n2);
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        if (this.circle != null) {
            uGraphic.getParam().setColor(this.circle);
        }
        uGraphic.getParam().setBackcolor(this.innerCircle);
        uGraphic.draw(d, d2, new UEllipse(this.radius * 2.0, this.radius * 2.0));
        uGraphic.getParam().setColor(this.fontColor);
        uGraphic.centerChar(d + this.radius, d2 + this.radius, this.c.charAt(0), this.font);
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        return 2.0 * this.radius;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return 2.0 * this.radius;
    }

    public void drawU(UGraphic uGraphic) {
        this.drawU(uGraphic, 0.0, 0.0);
    }

    private PathIterator getPathIteratorCharacter(FontRenderContext fontRenderContext) {
        TextLayout textLayout = new TextLayout(this.c, this.font.getFont(), fontRenderContext);
        Shape shape = textLayout.getOutline(null);
        return shape.getPathIterator(null);
    }

    public UPath getUPath(FontRenderContext fontRenderContext) {
        UPath uPath = new UPath();
        PathIterator pathIterator = this.getPathIteratorCharacter(fontRenderContext);
        double[] dArray = new double[6];
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            uPath.add(dArray, USegmentType.getByCode(n));
            pathIterator.next();
        }
        return uPath;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return new Dimension2DDouble(this.getPreferredWidth(stringBounder), this.getPreferredHeight(stringBounder));
    }

    public void drawTOBEREMOVED(ColorMapper colorMapper, Graphics2D graphics2D, double d, double d2) {
        throw new UnsupportedOperationException();
    }

    public DrawFile generateCircleCharacter(final ColorMapper colorMapper, final HtmlColor htmlColor, final double d) throws IOException {
        Lazy<File> lazy = new Lazy<File>(){

            @Override
            public File getNow() throws IOException {
                File file = FileUtils.createTempFile("circle", ".png");
                EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder((int)(60.0 * d), (int)(60.0 * d), colorMapper.getMappedColor(htmlColor), d);
                BufferedImage bufferedImage = emptyImageBuilder.getBufferedImage();
                Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
                StringBounder stringBounder = StringBounderUtils.asStringBounder(graphics2D);
                CircledCharacter.this.draw(colorMapper, graphics2D, 0, 0, d);
                bufferedImage = bufferedImage.getSubimage(0, 0, (int)(CircledCharacter.this.getPreferredWidth(stringBounder) * d) + 5, (int)(CircledCharacter.this.getPreferredHeight(stringBounder) * d) + 1);
                ImageIO.write((RenderedImage)bufferedImage, "png", file);
                return file;
            }
        };
        Lazy<File> lazy2 = new Lazy<File>(){

            @Override
            public File getNow() throws IOException {
                File file = FileUtils.createTempFile("circle", ".eps");
                UGraphicEps.copyEpsToFile(colorMapper, CircledCharacter.this, file);
                return file;
            }
        };
        Lazy<String> lazy3 = new Lazy<String>(){

            @Override
            public String getNow() throws IOException {
                return UGraphicG2d.getSvgString(colorMapper, CircledCharacter.this);
            }
        };
        List<Object> list = Arrays.asList("circle", this.c, this.font, this.innerCircle, this.circle, this.fontColor, this.radius, htmlColor, d);
        return DrawFile.create(lazy, lazy3, lazy2, list);
    }
}

