/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import net.sourceforge.plantuml.DirWatcher;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.Option;
import net.sourceforge.plantuml.swing.ImageWindow;
import net.sourceforge.plantuml.swing.SimpleLine;

public class MainWindow
extends JFrame {
    private static final Preferences prefs = Preferences.userNodeForPackage(MainWindow.class);
    private static final String KEY_DIR = "cur";
    private static final String KEY_PATTERN = "pat";
    private final JList jList1 = new JList();
    private final JScrollPane scrollPane;
    private final JButton changeDirButton = new JButton("Change Directory");
    private final JTextField extensions = new JTextField();
    private final List<SimpleLine> currentDirectoryListing = new ArrayList<SimpleLine>();
    private final Set<ImageWindow> openWindows = new HashSet<ImageWindow>();
    private final Option option;
    private DirWatcher dirWatcher;

    public MainWindow(Option option) {
        this(new File(prefs.get(KEY_DIR, ".")), option);
    }

    private String getExtensions() {
        return prefs.get(KEY_PATTERN, this.getDefaultFileExtensions());
    }

    private String getDefaultFileExtensions() {
        return "txt, tex, java, htm, html, c, h, cpp, apt";
    }

    private void changeExtensions(String string) {
        if (string.equals(this.getExtensions())) {
            return;
        }
        Pattern pattern = Pattern.compile("\\w+");
        Matcher matcher = pattern.matcher(string);
        StringBuilder stringBuilder = new StringBuilder();
        while (matcher.find()) {
            String string2 = matcher.group();
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string2);
        }
        string = stringBuilder.toString();
        if (string.length() == 0) {
            string = this.getDefaultFileExtensions();
        }
        this.extensions.setText(string);
        prefs.put(KEY_PATTERN, string);
        this.changeDir(this.dirWatcher.getDir());
    }

    private String getRegexpPattern(String string) {
        Pattern pattern = Pattern.compile("\\w+");
        Matcher matcher = pattern.matcher(string);
        StringBuilder stringBuilder = new StringBuilder("(?i)^.*\\.(");
        while (matcher.find()) {
            String string2 = matcher.group();
            if (!stringBuilder.toString().endsWith("(")) {
                stringBuilder.append("|");
            }
            stringBuilder.append(string2);
        }
        if (!stringBuilder.toString().endsWith("(")) {
            stringBuilder.append(")$");
            return stringBuilder.toString();
        }
        return Option.getPattern();
    }

    private MainWindow(File file, Option option) {
        super(file.getAbsolutePath());
        this.option = option;
        this.dirWatcher = new DirWatcher(file, option, this.getRegexpPattern(this.getExtensions()));
        Log.info("Showing MainWindow");
        this.scrollPane = new JScrollPane(this.jList1);
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("File extensions: ");
        this.extensions.setText(this.getExtensions());
        jLabel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createEtchedBorder()));
        jPanel.add((Component)jLabel, "West");
        jPanel.add((Component)this.extensions, "Center");
        jPanel.add((Component)this.changeDirButton, "South");
        this.getContentPane().add((Component)jPanel, "South");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.setSize(320, 200);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = MainWindow.this.jList1.locationToIndex(mouseEvent.getPoint());
                    MainWindow.this.doubleClick((SimpleLine)MainWindow.this.jList1.getModel().getElementAt(n), MainWindow.this.jList1.getModel(), n);
                }
            }
        };
        this.jList1.addMouseListener(mouseAdapter);
        this.changeDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.err.println("Opening Directory Window");
                MainWindow.this.displayDialogChangeDir();
            }
        });
        this.extensions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.changeExtensions(MainWindow.this.extensions.getText());
            }
        });
        this.extensions.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                MainWindow.this.changeExtensions(MainWindow.this.extensions.getText());
            }
        });
        this.startTimer();
    }

    private void startTimer() {
        Log.info("Init done");
        Timer timer = new Timer(3000, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainWindow.this.tick();
            }
        });
        timer.setInitialDelay(0);
        timer.start();
        Log.info("Timer started");
    }

    private void displayDialogChangeDir() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogType(2);
        jFileChooser.setDialogTitle("Directory to watch:");
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        String string = prefs.get(KEY_DIR, ".");
        jFileChooser.setCurrentDirectory(new File(string));
        Log.info("Showing OpenDialog");
        int n = jFileChooser.showOpenDialog(this);
        Log.info("Closing OpenDialog");
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.changeDir(file);
        }
    }

    private void changeDir(File file) {
        prefs.put(KEY_DIR, file.getAbsolutePath());
        this.dirWatcher = new DirWatcher(file, this.option, this.getRegexpPattern(this.getExtensions()));
        this.setTitle(file.getAbsolutePath());
        Log.info("Creating DirWatcher");
        this.currentDirectoryListing.clear();
        this.jList1.setListData(new Vector<SimpleLine>(this.currentDirectoryListing));
        this.jList1.setVisible(true);
    }

    private void doubleClick(SimpleLine simpleLine, ListModel listModel, int n) {
        for (ImageWindow imageWindow : this.openWindows) {
            if (!imageWindow.getSimpleLine().equals(simpleLine)) continue;
            imageWindow.setVisible(true);
            imageWindow.setExtendedState(0);
            return;
        }
        this.openWindows.add(new ImageWindow(simpleLine, this, listModel, n));
    }

    private void tick() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    boolean bl = MainWindow.this.refreshDir();
                    if (bl) {
                        MainWindow.this.jList1.setListData(new Vector(MainWindow.this.currentDirectoryListing));
                        MainWindow.this.jList1.setVisible(true);
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        });
    }

    private boolean refreshDir() throws IOException, InterruptedException {
        List<GeneratedImage> list = this.dirWatcher.buildCreatedFiles();
        boolean bl = false;
        for (GeneratedImage comparable : list) {
            SimpleLine simpleLine = new SimpleLine(comparable);
            this.mayRefreshImageWindow(comparable.getPngFile());
            if (this.currentDirectoryListing.contains(simpleLine)) continue;
            this.removeAllThatUseThisFile(comparable.getPngFile());
            this.currentDirectoryListing.add(simpleLine);
            bl = true;
        }
        Iterator<Object> iterator = this.currentDirectoryListing.iterator();
        while (iterator.hasNext()) {
            SimpleLine simpleLine = (SimpleLine)iterator.next();
            if (simpleLine.exists()) continue;
            iterator.remove();
            bl = true;
        }
        Collections.sort(this.currentDirectoryListing);
        return bl;
    }

    private void removeAllThatUseThisFile(File file) {
        Iterator<SimpleLine> iterator = this.currentDirectoryListing.iterator();
        while (iterator.hasNext()) {
            SimpleLine simpleLine = iterator.next();
            if (!simpleLine.getGeneratedImage().getPngFile().equals(file)) continue;
            iterator.remove();
        }
    }

    private void mayRefreshImageWindow(File file) {
        for (ImageWindow imageWindow : this.openWindows) {
            if (!file.equals(imageWindow.getSimpleLine().getGeneratedImage().getPngFile())) continue;
            imageWindow.refreshImage();
        }
    }

    public void closing(ImageWindow imageWindow) {
        boolean bl = this.openWindows.remove(imageWindow);
        if (!bl) {
            throw new IllegalStateException();
        }
    }
}

