/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ArrowPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentType {
    private static final Map<ArrowConfiguration, ComponentType> arrows = new HashMap<ArrowConfiguration, ComponentType>();
    private static final List<ComponentType> nonArrows = new ArrayList<ComponentType>();
    public static final ComponentType ACTOR_HEAD = new ComponentType("ACTOR_HEAD");
    public static final ComponentType ACTOR_TAIL = new ComponentType("ACTOR_TAIL");
    public static final ComponentType ALIVE_BOX_CLOSE_CLOSE = new ComponentType("ALIVE_BOX_CLOSE_CLOSE");
    public static final ComponentType ALIVE_BOX_CLOSE_OPEN = new ComponentType("ALIVE_BOX_CLOSE_OPEN");
    public static final ComponentType ALIVE_BOX_OPEN_CLOSE = new ComponentType("ALIVE_BOX_OPEN_CLOSE");
    public static final ComponentType ALIVE_BOX_OPEN_OPEN = new ComponentType("ALIVE_BOX_OPEN_OPEN");
    public static final ComponentType DELAY_TEXT = new ComponentType("DELAY_TEXT");
    public static final ComponentType DESTROY = new ComponentType("DESTROY");
    public static final ComponentType DELAY_LINE = new ComponentType("DELAY_LINE");
    public static final ComponentType PARTICIPANT_LINE = new ComponentType("PARTICIPANT_LINE");
    public static final ComponentType CONTINUE_LINE = new ComponentType("CONTINUE_LINE");
    public static final ComponentType GROUPING_BODY = new ComponentType("GROUPING_BODY");
    public static final ComponentType GROUPING_ELSE = new ComponentType("GROUPING_ELSE");
    public static final ComponentType GROUPING_HEADER = new ComponentType("GROUPING_HEADER");
    public static final ComponentType GROUPING_TAIL = new ComponentType("GROUPING_TAIL");
    public static final ComponentType NEWPAGE = new ComponentType("NEWPAGE");
    public static final ComponentType NOTE = new ComponentType("NOTE");
    public static final ComponentType DIVIDER = new ComponentType("DIVIDER");
    public static final ComponentType REFERENCE = new ComponentType("REFERENCE");
    public static final ComponentType ENGLOBER = new ComponentType("ENGLOBER");
    public static final ComponentType PARTICIPANT_HEAD = new ComponentType("PARTICIPANT_HEAD");
    public static final ComponentType PARTICIPANT_TAIL = new ComponentType("PARTICIPANT_TAIL");
    public static final ComponentType TITLE = new ComponentType("TITLE");
    public static final ComponentType SIGNATURE = new ComponentType("SIGNATURE");
    private final ArrowConfiguration arrowConfiguration;
    private final String name;

    private ComponentType(String string) {
        this(string, null);
        nonArrows.add(this);
    }

    private ComponentType(String string, ArrowConfiguration arrowConfiguration) {
        this.name = string;
        this.arrowConfiguration = arrowConfiguration;
    }

    public static ComponentType getArrow(ArrowDirection arrowDirection) {
        ArrowConfiguration arrowConfiguration = ArrowConfiguration.withDirection(arrowDirection);
        return ComponentType.getArrow(arrowConfiguration);
    }

    private static ComponentType getArrow(ArrowConfiguration arrowConfiguration) {
        ComponentType componentType = arrows.get(arrowConfiguration);
        if (componentType == null) {
            componentType = new ComponentType(arrowConfiguration.name(), arrowConfiguration);
            arrows.put(arrowConfiguration, componentType);
        }
        return componentType;
    }

    public ComponentType withAsync() {
        this.checkArrow();
        return ComponentType.getArrow(this.arrowConfiguration.withAsync());
    }

    public ComponentType withDotted() {
        this.checkArrow();
        return ComponentType.getArrow(this.arrowConfiguration.withDotted());
    }

    public ComponentType withPart(ArrowPart arrowPart) {
        this.checkArrow();
        return ComponentType.getArrow(this.arrowConfiguration.withPart(arrowPart));
    }

    public String name() {
        return this.name;
    }

    public boolean isArrow() {
        return this.arrowConfiguration != null;
    }

    private void checkArrow() {
        if (this.arrowConfiguration == null) {
            throw new IllegalArgumentException(this.name());
        }
    }

    public static Collection<ComponentType> all() {
        ComponentType componentType;
        Iterator iterator2;
        ArrayList<ComponentType> arrayList = new ArrayList<ComponentType>();
        arrayList.add(ComponentType.getArrow(ArrowDirection.LEFT_TO_RIGHT_NORMAL));
        arrayList.add(ComponentType.getArrow(ArrowDirection.RIGHT_TO_LEFT_REVERSE));
        arrayList.add(ComponentType.getArrow(ArrowDirection.SELF));
        arrayList.add(ComponentType.getArrow(ArrowDirection.LEFT_TO_RIGHT_NORMAL).withDotted());
        arrayList.add(ComponentType.getArrow(ArrowDirection.RIGHT_TO_LEFT_REVERSE).withDotted());
        arrayList.add(ComponentType.getArrow(ArrowDirection.SELF).withDotted());
        for (Iterator iterator2 : new ArrayList(arrayList)) {
            arrayList.add(((ComponentType)((Object)iterator2)).withAsync());
        }
        ArrayList arrayList2 = new ArrayList(arrayList);
        iterator2 = arrayList2.iterator();
        while (iterator2.hasNext()) {
            componentType = (ComponentType)iterator2.next();
            arrayList.add(componentType.withPart(ArrowPart.TOP_PART));
        }
        iterator2 = arrayList2.iterator();
        while (iterator2.hasNext()) {
            componentType = (ComponentType)iterator2.next();
            arrayList.add(componentType.withPart(ArrowPart.BOTTOM_PART));
        }
        arrayList.addAll(nonArrows);
        return Collections.unmodifiableCollection(arrayList);
    }

    public final ArrowConfiguration getArrowConfiguration() {
        return this.arrowConfiguration;
    }
}

