/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.cucadiagram.dot.Lazy;
import net.sourceforge.plantuml.cucadiagram.dot.LazyCached;
import net.sourceforge.plantuml.cucadiagram.dot.LazyFile;
import net.sourceforge.plantuml.cucadiagram.dot.Unlazy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawFile {
    private static final Map<Object, DrawFile> cache = new HashMap<Object, DrawFile>();
    private static final Collection<DrawFile> toDelete = new HashSet<DrawFile>();
    private final LazyFile png2;
    private final LazyCached<String> svg2;
    private final LazyFile eps2;
    private final String toStringValue;
    private final boolean cached;
    private final AtomicInteger useCounter = new AtomicInteger(0);
    private final AtomicInteger totalUse = new AtomicInteger(0);
    private final AtomicBoolean useable = new AtomicBoolean(true);
    private int widthPng = -1;
    private int heightPng = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCacheClean() {
        Collection<DrawFile> collection = toDelete;
        synchronized (collection) {
            for (DrawFile drawFile : toDelete) {
                if (drawFile.useCounter.get() == 0) continue;
                Log.error("Remaining " + drawFile);
                return false;
            }
            for (DrawFile drawFile : cache.values()) {
                if (drawFile.useCounter.get() == 0) continue;
                Log.error("Remaining " + drawFile);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DrawFile create(Lazy<File> lazy, Lazy<String> lazy2, Lazy<File> lazy3, Object object) {
        DrawFile drawFile = null;
        Collection<DrawFile> collection = toDelete;
        synchronized (collection) {
            if (object != null) {
                drawFile = cache.get(object);
            }
            if (drawFile == null) {
                drawFile = new DrawFile(lazy, lazy2, lazy3, object == null ? null : object.toString(), object != null);
                if (object != null) {
                    cache.put(object, drawFile);
                    Log.info("DrawFile cache size = " + cache.size());
                }
                DrawFile.deleteOnExit(drawFile);
            }
            drawFile.useCounter.addAndGet(1);
            drawFile.totalUse.addAndGet(1);
        }
        return drawFile;
    }

    private static void checkCacheSize() {
        int n = Integer.MAX_VALUE;
        for (DrawFile drawFile : cache.values()) {
            int n2 = drawFile.totalUse.get();
            if (n2 >= n) continue;
            n = n2;
        }
        Iterator<DrawFile> iterator = cache.values().iterator();
        while (iterator.hasNext()) {
            DrawFile drawFile;
            drawFile = iterator.next();
            if (drawFile.useCounter.get() != 0 || drawFile.totalUse.get() != n) continue;
            iterator.remove();
        }
    }

    public String toString() {
        if (this.toStringValue == null) {
            return super.toString() + " " + this.useCounter.get() + " " + this.totalUse.get();
        }
        return this.toStringValue + " " + this.useCounter.get() + " " + this.totalUse.get();
    }

    public static DrawFile createFromFile(File file, String string, File file2) {
        DrawFile drawFile = new DrawFile(file, string, file2, file.getName(), false);
        drawFile.useCounter.addAndGet(1);
        DrawFile.deleteOnExit(drawFile);
        return drawFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteOnExit(DrawFile drawFile) {
        Collection<DrawFile> collection = toDelete;
        synchronized (collection) {
            toDelete.add(drawFile);
        }
    }

    private DrawFile(Lazy<File> lazy, Lazy<String> lazy2, Lazy<File> lazy3, String string, boolean bl) {
        this.png2 = new LazyFile(lazy);
        this.svg2 = new LazyCached<String>(lazy2);
        this.eps2 = new LazyFile(lazy3);
        this.toStringValue = string;
        this.cached = bl;
    }

    private DrawFile(File file, String string, File file2, String string2, boolean bl) {
        this(new Unlazy<File>(file), new Unlazy<String>(string), new Unlazy<File>(file2), string2, bl);
    }

    public File getPngOrEps(FileFormat fileFormat) throws IOException {
        this.checkUseable();
        if (fileFormat.isEps()) {
            if (this.eps2 == null) {
                throw new UnsupportedOperationException("No eps for " + this.getPng().getAbsolutePath());
            }
            return this.getEps();
        }
        return this.getPng();
    }

    private void checkUseable() {
        if (!this.useable.get()) {
            throw new IllegalStateException("Useable false");
        }
    }

    public synchronized File getPng() throws IOException {
        this.checkUseable();
        return (File)this.png2.getNow();
    }

    public synchronized String getSvg() throws IOException {
        this.checkUseable();
        return this.svg2.getNow();
    }

    public synchronized File getEps() throws IOException {
        this.checkUseable();
        return (File)this.eps2.getNow();
    }

    private synchronized void initSize() throws IOException {
        this.checkUseable();
        BufferedImage bufferedImage = ImageIO.read(this.getPng());
        this.widthPng = bufferedImage.getWidth();
        this.heightPng = bufferedImage.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void deleteDrawFile() {
        if (!this.useable.get()) {
            return;
        }
        int n = this.useCounter.addAndGet(-1);
        if (n == 0) {
            if (this.cached && !DrawFile.isCacheTooBig()) {
                return;
            }
            Collection<DrawFile> collection = toDelete;
            synchronized (collection) {
                boolean bl;
                this.deleteNow();
                if (this.cached && !(bl = cache.values().remove(this))) {
                    Log.error("Not found in cache " + this);
                }
                if (!(bl = toDelete.remove(this))) {
                    Log.error("Not found in delete list " + this);
                }
            }
        }
    }

    private static boolean isCacheTooBig() {
        return true;
    }

    private synchronized void deleteNow() {
        boolean bl;
        this.useable.set(false);
        if (this.png2 != null && this.png2.isLoaded()) {
            try {
                Log.info("Deleting temporary file " + this.png2.getNow());
                bl = ((File)this.png2.getNow()).delete();
                if (!bl) {
                    Log.error("Cannot delete: " + this.png2.getNow());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Log.error("Problem deleting PNG file");
            }
        }
        if (this.eps2 != null && this.eps2.isLoaded()) {
            try {
                Log.info("Deleting temporary file " + this.eps2.getNow());
                bl = ((File)this.eps2.getNow()).delete();
                if (!bl) {
                    Log.error("Cannot delete: " + this.eps2.getNow());
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                Log.error("Problem deleting EPS file");
            }
        }
    }

    public final int getWidthPng() throws IOException {
        this.checkUseable();
        if (this.widthPng == -1) {
            this.initSize();
        }
        return this.widthPng;
    }

    public final int getHeightPng() throws IOException {
        this.checkUseable();
        if (this.widthPng == -1) {
            this.initSize();
        }
        return this.heightPng;
    }

    private static void addHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                if (!OptionFlags.getInstance().isKeepTmpFiles()) {
                    Collection collection = toDelete;
                    synchronized (collection) {
                        for (DrawFile drawFile : toDelete) {
                            int n = drawFile.useCounter.get();
                            if (n != 0) {
                                Log.error("useCounter " + n + " for " + drawFile);
                            }
                            drawFile.deleteNow();
                        }
                    }
                }
            }
        });
    }

    static {
        DrawFile.addHook();
    }
}

