/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.CrossingType;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.EntityGender;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Imaged;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramFileMaker;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramFileMakerBeta;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramPngMaker3;
import net.sourceforge.plantuml.cucadiagram.dot.CucaDiagramTxtMaker;
import net.sourceforge.plantuml.cucadiagram.dot.DrawFile;
import net.sourceforge.plantuml.png.PngSplitter;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.xmi.CucaDiagramXmiMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CucaDiagram
extends UmlDiagram
implements GroupHierarchy,
PortionShower {
    private int horizontalPages = 1;
    private int verticalPages = 1;
    private final Map<String, Entity> entities = new TreeMap<String, Entity>();
    private final Map<IEntity, Integer> nbLinks = new HashMap<IEntity, Integer>();
    private final List<Link> links = new ArrayList<Link>();
    private final Map<String, Group> groups = new LinkedHashMap<String, Group>();
    private Group currentGroup = null;
    private Rankdir rankdir = Rankdir.TOP_TO_BOTTOM;
    private boolean visibilityModifierPresent;
    public static boolean BETA;
    private final List<HideOrShow> hideOrShows = new ArrayList<HideOrShow>();
    private final Set<VisibilityModifier> hides = new HashSet<VisibilityModifier>();
    private final Set<DrawFile> ensureDeletes = new HashSet<DrawFile>();

    public boolean hasUrl() {
        for (Entity entity : this.entities.values()) {
            if (entity.getUrl() == null) continue;
            return true;
        }
        return false;
    }

    public IEntity getOrCreateEntity(String string, EntityType entityType) {
        IEntity iEntity = this.entities.get(string);
        if (iEntity == null) {
            iEntity = this.createEntityInternal(string, string, entityType, this.getCurrentGroup());
        }
        return iEntity;
    }

    public Entity createEntity(String string, String string2, EntityType entityType) {
        if (this.entities.containsKey(string)) {
            throw new IllegalArgumentException("Already known: " + string);
        }
        return this.createEntityInternal(string, string2, entityType, this.getCurrentGroup());
    }

    protected final Entity createEntityInternal(String string, String string2, EntityType entityType, Group group) {
        if (string2 == null) {
            string2 = string;
        }
        Entity entity = new Entity(string, string2, entityType, group, this.getHides());
        this.entities.put(string, entity);
        this.nbLinks.put(entity, 0);
        return entity;
    }

    public boolean entityExist(String string) {
        return this.entities.containsKey(string);
    }

    public void overideGroup(Group group, Entity entity) {
        Imaged imaged;
        if (!this.groups.containsValue(group)) {
            throw new IllegalArgumentException();
        }
        if (this.entities.containsKey(entity.getCode())) {
            throw new IllegalArgumentException();
        }
        if (this.entities.containsValue(entity)) {
            throw new IllegalArgumentException();
        }
        Iterator<Imaged> iterator = this.links.listIterator();
        while (iterator.hasNext()) {
            imaged = iterator.next();
            Link link = ((Link)imaged).mute(group, entity);
            if (link == null) {
                iterator.remove();
                continue;
            }
            if (link == imaged) continue;
            iterator.set(link);
        }
        this.groups.remove(group.getCode());
        assert (!this.groups.containsValue(group));
        iterator = this.entities.values().iterator();
        while (iterator.hasNext()) {
            imaged = (IEntity)iterator.next();
            if (imaged.getParent() != group) continue;
            iterator.remove();
        }
        this.entities.put(entity.getCode(), entity);
    }

    @Override
    public final Collection<Group> getChildrenGroups(Group group) {
        ArrayList<Group> arrayList = new ArrayList<Group>();
        for (Group group2 : this.groups.values()) {
            if (group2.getParent() != group) continue;
            arrayList.add(group2);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public final Group getOrCreateGroup(String string, String string2, String string3, GroupType groupType, Group group) {
        Group group2;
        this.currentGroup = group2 = this.getOrCreateGroupInternal(string, string2, string3, groupType, group);
        return group2;
    }

    protected final Group getOrCreateGroupInternal(String string, String string2, String string3, GroupType groupType, Group group) {
        Group group2 = this.groups.get(string);
        if (group2 == null) {
            group2 = new Group(string, string2, string3, groupType, group);
            this.groups.put(string, group2);
            Entity entity = this.entities.get(string);
            if (entity == null) {
                entity = new Entity("$$" + string, string, EntityType.GROUP, group2, this.getHides());
            } else {
                entity.muteToCluster(group2);
            }
            group2.setEntityCluster(entity);
            this.nbLinks.put(entity, 0);
        }
        return group2;
    }

    public final Group getCurrentGroup() {
        return this.currentGroup;
    }

    public final Group getGroup(String string) {
        Group group = this.groups.get(string);
        if (group == null) {
            return null;
        }
        return group;
    }

    public void endGroup() {
        if (this.currentGroup == null) {
            Log.error("No parent group");
            return;
        }
        this.currentGroup = this.currentGroup.getParent();
    }

    public final boolean isGroup(String string) {
        return this.groups.containsKey(string);
    }

    public final Collection<Group> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    public final Map<String, Entity> entities() {
        return Collections.unmodifiableMap(this.entities);
    }

    public final void addLink(Link link) {
        this.links.add(link);
        this.inc(link.getEntity1());
        this.inc(link.getEntity2());
    }

    protected final void removeLink(Link link) {
        boolean bl = this.links.remove(link);
        if (!bl) {
            throw new IllegalStateException();
        }
    }

    private void inc(IEntity iEntity) {
        if (iEntity == null) {
            throw new IllegalArgumentException();
        }
        this.nbLinks.put(iEntity, this.nbLinks.get(iEntity) + 1);
    }

    public final List<Link> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public final int getHorizontalPages() {
        return this.horizontalPages;
    }

    public final void setHorizontalPages(int n) {
        this.horizontalPages = n;
    }

    public final int getVerticalPages() {
        return this.verticalPages;
    }

    public final void setVerticalPages(int n) {
        this.verticalPages = n;
    }

    public final List<File> createPng2(File file) throws IOException, InterruptedException {
        CucaDiagramPngMaker3 cucaDiagramPngMaker3 = new CucaDiagramPngMaker3(this);
        return cucaDiagramPngMaker3.createPng(file);
    }

    public final void createPng2(OutputStream outputStream) throws IOException {
        CucaDiagramPngMaker3 cucaDiagramPngMaker3 = new CucaDiagramPngMaker3(this);
        cucaDiagramPngMaker3.createPng(outputStream);
    }

    protected abstract List<String> getDotStrings();

    private void createFilesXmi(OutputStream outputStream, FileFormat fileFormat) throws IOException {
        CucaDiagramXmiMaker cucaDiagramXmiMaker = new CucaDiagramXmiMaker(this, fileFormat);
        cucaDiagramXmiMaker.createFiles(outputStream);
    }

    private List<File> createFilesTxt(File file, FileFormat fileFormat) throws IOException {
        CucaDiagramTxtMaker cucaDiagramTxtMaker = new CucaDiagramTxtMaker(this, fileFormat);
        return cucaDiagramTxtMaker.createFiles(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<File> exportDiagrams(File file, FileFormatOption fileFormatOption) throws IOException, InterruptedException {
        if (file.exists() && file.isDirectory()) {
            throw new IllegalArgumentException("File is a directory " + file);
        }
        StringBuilder stringBuilder = new StringBuilder();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            this.exportDiagram(fileOutputStream, stringBuilder, 0, fileFormatOption);
        }
        finally {
            if (fileOutputStream != null) {
                ((OutputStream)fileOutputStream).close();
            }
        }
        List<File> list = Arrays.asList(file);
        if (this.hasUrl() && stringBuilder.length() > 0) {
            this.exportCmap(file, stringBuilder);
        }
        if (fileFormatOption.getFileFormat() == FileFormat.PNG) {
            list = new PngSplitter(file, this.getHorizontalPages(), this.getVerticalPages(), this.getMetadata(), this.getDpi(fileFormatOption)).getFiles();
        }
        return list;
    }

    @Override
    protected final void exportDiagramInternal(OutputStream outputStream, StringBuilder stringBuilder, int n, FileFormatOption fileFormatOption, List<BufferedImage> list) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.ATXT || fileFormat == FileFormat.UTXT) {
            try {
                this.createFilesTxt(outputStream, n, fileFormat);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace(new PrintStream(outputStream));
            }
            return;
        }
        if (fileFormat.name().startsWith("XMI")) {
            this.createFilesXmi(outputStream, fileFormat);
            return;
        }
        if (this.getUmlDiagramType() == UmlDiagramType.COMPOSITE || BETA && this.getUmlDiagramType() == UmlDiagramType.CLASS) {
            CucaDiagramFileMakerBeta cucaDiagramFileMakerBeta = new CucaDiagramFileMakerBeta(this);
            try {
                cucaDiagramFileMakerBeta.createFile(outputStream, this.getDotStrings(), fileFormat);
            }
            catch (InterruptedException interruptedException) {
                throw new IOException(interruptedException.toString());
            }
            return;
        }
        if (this.getUmlDiagramType() == UmlDiagramType.COMPOSITE) {
            CucaDiagramFileMakerBeta cucaDiagramFileMakerBeta = new CucaDiagramFileMakerBeta(this);
            try {
                cucaDiagramFileMakerBeta.createFile(outputStream, this.getDotStrings(), fileFormat);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                throw new IOException(interruptedException.toString());
            }
            return;
        }
        CucaDiagramFileMaker cucaDiagramFileMaker = new CucaDiagramFileMaker(this, list);
        try {
            String string = cucaDiagramFileMaker.createFile(outputStream, this.getDotStrings(), fileFormatOption);
            if (string != null && stringBuilder != null) {
                stringBuilder.append(string);
            }
        }
        catch (InterruptedException interruptedException) {
            Log.error(interruptedException.toString());
            throw new IOException(interruptedException.toString());
        }
    }

    private void createFilesTxt(OutputStream outputStream, int n, FileFormat fileFormat) throws IOException {
        CucaDiagramTxtMaker cucaDiagramTxtMaker = new CucaDiagramTxtMaker(this, fileFormat);
        cucaDiagramTxtMaker.createFiles(outputStream, n);
    }

    public final Rankdir getRankdir() {
        return this.rankdir;
    }

    public final void setRankdir(Rankdir rankdir) {
        this.rankdir = rankdir;
    }

    public boolean isAutarkic(Group group) {
        if (group.getType() == GroupType.PACKAGE) {
            return false;
        }
        if (group.getType() == GroupType.INNER_ACTIVITY) {
            return true;
        }
        if (group.getType() == GroupType.CONCURRENT_ACTIVITY) {
            return true;
        }
        if (group.getType() == GroupType.CONCURRENT_STATE) {
            return true;
        }
        if (this.getChildrenGroups(group).size() > 0) {
            return false;
        }
        for (Link link : this.links) {
            IEntity iEntity = link.getEntity1();
            IEntity iEntity2 = link.getEntity2();
            if (iEntity.getParent() != group && iEntity2.getParent() == group && iEntity2.getType() != EntityType.GROUP) {
                return false;
            }
            if (iEntity2.getParent() != group && iEntity.getParent() == group && iEntity.getType() != EntityType.GROUP) {
                return false;
            }
            if (link.isAutolink(group)) continue;
            if (iEntity.getType() == EntityType.GROUP && iEntity2.getParent() == iEntity.getParent() && iEntity.getParent() == group) {
                return false;
            }
            if (iEntity2.getType() != EntityType.GROUP || iEntity2.getParent() != iEntity.getParent() || iEntity.getParent() != group) continue;
            return false;
        }
        return true;
    }

    private static boolean isNumber(String string) {
        return string.matches("[+-]?(\\.?\\d+|\\d+\\.\\d*)");
    }

    public void resetPragmaLabel() {
        this.getPragma().undefine("labeldistance");
        this.getPragma().undefine("labelangle");
    }

    public String getLabeldistance() {
        String string;
        if (this.getPragma().isDefine("labeldistance") && CucaDiagram.isNumber(string = this.getPragma().getValue("labeldistance"))) {
            return string;
        }
        if (this.getPragma().isDefine("defaultlabeldistance") && CucaDiagram.isNumber(string = this.getPragma().getValue("defaultlabeldistance"))) {
            return string;
        }
        return "1.7";
    }

    public String getLabelangle() {
        String string;
        if (this.getPragma().isDefine("labelangle") && CucaDiagram.isNumber(string = this.getPragma().getValue("labelangle"))) {
            return string;
        }
        if (this.getPragma().isDefine("defaultlabelangle") && CucaDiagram.isNumber(string = this.getPragma().getValue("defaultlabelangle"))) {
            return string;
        }
        return "25";
    }

    @Override
    public final boolean isEmpty(Group group) {
        for (Group group2 : this.groups.values()) {
            if (group2 == group || group2.getParent() != group) continue;
            return false;
        }
        return group.entities().size() == 0;
    }

    public final boolean isVisibilityModifierPresent() {
        return this.visibilityModifierPresent;
    }

    public final void setVisibilityModifierPresent(boolean bl) {
        this.visibilityModifierPresent = bl;
    }

    private boolean isAutonom(Group group) {
        for (Link link : this.links) {
            CrossingType crossingType = group.getCrossingType(link);
            if (crossingType != CrossingType.CUT) continue;
            return false;
        }
        return true;
    }

    public final void computeAutonomyOfGroups() {
        for (Group group : this.groups.values()) {
            group.setAutonom(this.isAutonom(group));
        }
    }

    @Override
    public final boolean showPortion(EntityPortion entityPortion, IEntity iEntity) {
        boolean bl = true;
        for (HideOrShow hideOrShow : this.hideOrShows) {
            if (hideOrShow.portion != entityPortion || !hideOrShow.gender.contains(iEntity)) continue;
            bl = hideOrShow.show;
        }
        return bl;
    }

    public final void hideOrShow(EntityGender entityGender, Set<EntityPortion> set, boolean bl) {
        for (EntityPortion entityPortion : set) {
            this.hideOrShows.add(new HideOrShow(entityGender, entityPortion, bl));
        }
    }

    public void hideOrShow(Set<VisibilityModifier> set, boolean bl) {
        if (bl) {
            this.hides.removeAll(set);
        } else {
            this.hides.addAll(set);
        }
    }

    @Override
    public int getNbImages() {
        return this.horizontalPages * this.verticalPages;
    }

    public final Set<VisibilityModifier> getHides() {
        return Collections.unmodifiableSet(this.hides);
    }

    public void clean() throws IOException {
        for (Entity object : this.entities().values()) {
            this.cleanTemporaryFiles(object);
        }
        for (Link link : this.getLinks()) {
            this.cleanTemporaryFiles(link);
        }
        for (Group group : this.groups.values()) {
            IEntity iEntity = group.getEntityCluster();
            if (iEntity == null) continue;
            this.cleanTemporaryFiles(iEntity);
        }
        for (DrawFile drawFile : this.ensureDeletes) {
            drawFile.deleteDrawFile();
        }
    }

    private void cleanTemporaryFiles(Imaged imaged) {
        if (imaged.getImageFile() != null) {
            imaged.getImageFile().deleteDrawFile();
        }
        if (imaged instanceof Entity) {
            ((Entity)imaged).cleanSubImage();
        }
    }

    public void ensureDelete(DrawFile drawFile) {
        if (drawFile == null) {
            throw new IllegalArgumentException();
        }
        this.ensureDeletes.add(drawFile);
    }

    public ColorMapper getColorMapper() {
        return this.getSkinParam().getColorMapper();
    }

    static class HideOrShow {
        private final EntityGender gender;
        private final EntityPortion portion;
        private final boolean show;

        public HideOrShow(EntityGender entityGender, EntityPortion entityPortion, boolean bl) {
            this.gender = entityGender;
            this.portion = entityPortion;
            this.show = bl;
        }
    }
}

