/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram.command;

import java.util.List;
import net.sourceforge.plantuml.UniqueSequence;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.cucadiagram.Entity;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandNoteActivity
extends SingleLineCommand<ActivityDiagram> {
    public CommandNoteActivity(ActivityDiagram activityDiagram) {
        super(activityDiagram, "(?i)^note\\s+(right|left|top|bottom)\\s*:\\s*(.*)$");
    }

    @Override
    protected CommandExecutionResult executeArg(List<String> list) {
        Link link;
        String string = list.get(0);
        Entity entity = ((ActivityDiagram)this.getSystem()).createNote("GN" + UniqueSequence.getValue(), list.get(1));
        IEntity iEntity = ((ActivityDiagram)this.getSystem()).getLastEntityConsulted();
        if (iEntity == null) {
            iEntity = ((ActivityDiagram)this.getSystem()).getStart();
        }
        Position position = Position.valueOf(string.toUpperCase()).withRankdir(((ActivityDiagram)this.getSystem()).getRankdir());
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getDashed();
        if (position == Position.RIGHT) {
            link = new Link(iEntity, entity, linkType, null, 1);
        } else if (position == Position.LEFT) {
            link = new Link(entity, iEntity, linkType, null, 1);
        } else if (position == Position.BOTTOM) {
            link = new Link(iEntity, entity, linkType, null, 2);
        } else if (position == Position.TOP) {
            link = new Link(entity, iEntity, linkType, null, 2);
        } else {
            throw new IllegalArgumentException();
        }
        ((ActivityDiagram)this.getSystem()).addLink(link);
        return CommandExecutionResult.ok();
    }
}

