/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.USegment;
import net.sourceforge.plantuml.ugraphic.USegmentType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvgGraphics {
    private final Document document;
    private final Element root;
    private final Element defs;
    private final Element gRoot;
    private String fill = "black";
    private String stroke = "black";
    private String strokeWidth = "1";
    private String strokeDasharray = null;
    private final String backcolor;
    private int maxX = 10;
    private int maxY = 10;
    private Map<List<String>, String> gradients = new HashMap<List<String>, String>();
    private boolean xlinkXmlns = false;
    private Element pendingLink;
    private StringBuilder currentPath = null;

    protected final void ensureVisible(double d, double d2) {
        if (d > (double)this.maxX) {
            this.maxX = (int)(d + 1.0);
        }
        if (d2 > (double)this.maxY) {
            this.maxY = (int)(d2 + 1.0);
        }
    }

    public SvgGraphics() {
        this(null);
    }

    public SvgGraphics(String string) {
        try {
            this.document = this.getDocument();
            this.backcolor = string;
            this.root = this.getRootNode();
            this.defs = this.simpleElement("defs");
            this.gRoot = this.simpleElement("g");
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new IllegalStateException(parserConfigurationException);
        }
    }

    private Element simpleElement(String string) {
        Element element = this.document.createElement(string);
        this.root.appendChild(element);
        return element;
    }

    private Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        document.setXmlStandalone(true);
        return document;
    }

    private Element getRootNode() {
        Element element = this.document.createElement("svg");
        this.document.appendChild(element);
        element.setAttribute("xmlns", "http://www.w3.org/2000/svg");
        element.setAttribute("version", "1.1");
        return element;
    }

    public void svgEllipse(double d, double d2, double d3, double d4) {
        Element element = this.document.createElement("ellipse");
        element.setAttribute("cx", "" + d);
        element.setAttribute("cy", "" + d2);
        element.setAttribute("rx", "" + d3);
        element.setAttribute("ry", "" + d4);
        element.setAttribute("fill", this.fill);
        element.setAttribute("style", this.getStyle());
        this.getG().appendChild(element);
        this.ensureVisible(d + d3, d2 + d4);
    }

    public String createSvgGradient(String string, String string2) {
        List<String> list = Arrays.asList(string, string2);
        String string3 = this.gradients.get(list);
        if (string3 == null) {
            Element element = this.document.createElement("linearGradient");
            element.setAttribute("x1", "0%");
            element.setAttribute("y1", "0%");
            element.setAttribute("x2", "100%");
            element.setAttribute("y2", "100%");
            string3 = "gr" + this.gradients.size();
            this.gradients.put(list, string3);
            element.setAttribute("id", string3);
            Element element2 = this.document.createElement("stop");
            element2.setAttribute("stop-color", string);
            element2.setAttribute("offset", "0%");
            Element element3 = this.document.createElement("stop");
            element3.setAttribute("stop-color", string2);
            element3.setAttribute("offset", "100%");
            element.appendChild(element2);
            element.appendChild(element3);
            this.defs.appendChild(element);
        }
        return string3;
    }

    public final void setFillColor(String string) {
        this.fill = string == null ? "none" : string;
    }

    public final void setStrokeColor(String string) {
        this.stroke = string;
    }

    public final void setStrokeWidth(String string, String string2) {
        this.strokeWidth = string;
        this.strokeDasharray = string2;
    }

    public void closeLink() {
        this.gRoot.appendChild(this.pendingLink);
        this.pendingLink = null;
    }

    public void openLink(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (!this.xlinkXmlns) {
            this.root.setAttribute("xmlns:xlink", "http://www.w3.org/1999/xlink");
            this.xlinkXmlns = true;
        }
        this.pendingLink = this.document.createElement("a");
        this.pendingLink.setAttribute("xlink:href", string);
        if (string2 == null) {
            this.pendingLink.setAttribute("xlink:title", string);
        } else {
            this.pendingLink.setAttribute("xlink:title", string2);
        }
    }

    public final Element getG() {
        if (this.pendingLink == null) {
            return this.gRoot;
        }
        return this.pendingLink;
    }

    public void svgRectangle(double d, double d2, double d3, double d4, double d5, double d6) {
        Element element = this.document.createElement("rect");
        element.setAttribute("x", "" + d);
        element.setAttribute("y", "" + d2);
        element.setAttribute("width", "" + d3);
        element.setAttribute("height", "" + d4);
        element.setAttribute("fill", this.fill);
        element.setAttribute("style", this.getStyle());
        if (d5 > 0.0 && d6 > 0.0) {
            element.setAttribute("rx", "" + d5);
            element.setAttribute("ry", "" + d6);
        }
        this.getG().appendChild(element);
        this.ensureVisible(d + d3, d2 + d4);
    }

    public void svgLine(double d, double d2, double d3, double d4) {
        Element element = this.document.createElement("line");
        element.setAttribute("x1", "" + d);
        element.setAttribute("y1", "" + d2);
        element.setAttribute("x2", "" + d3);
        element.setAttribute("y2", "" + d4);
        element.setAttribute("style", this.getStyle());
        this.getG().appendChild(element);
        this.ensureVisible(d, d2);
        this.ensureVisible(d3, d4);
    }

    private String getStyle() {
        StringBuilder stringBuilder = new StringBuilder("stroke: " + this.stroke + "; stroke-width: " + this.strokeWidth + ";");
        if (this.strokeDasharray != null) {
            stringBuilder.append(" stroke-dasharray: " + this.strokeDasharray + ";");
        }
        return stringBuilder.toString();
    }

    public void svgPolygon(double ... dArray) {
        Element element = this.document.createElement("polygon");
        StringBuilder stringBuilder = new StringBuilder();
        for (double d : dArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(d);
        }
        element.setAttribute("points", stringBuilder.toString());
        element.setAttribute("fill", this.fill);
        element.setAttribute("style", this.getStyle());
        this.getG().appendChild(element);
        for (int i = 0; i < dArray.length; i += 2) {
            this.ensureVisible(dArray[i], dArray[i + 1]);
        }
    }

    public void text(String string, double d, double d2, String string2, int n, String string3, String string4, String string5, double d3) {
        Element element = this.document.createElement("text");
        element.setAttribute("x", "" + d);
        element.setAttribute("y", "" + d2);
        element.setAttribute("fill", this.fill);
        element.setAttribute("font-size", "" + n);
        element.setAttribute("lengthAdjust", "spacingAndGlyphs");
        element.setAttribute("textLength", "" + d3);
        if (string3 != null) {
            element.setAttribute("font-weight", string3);
        }
        if (string4 != null) {
            element.setAttribute("font-style", string4);
        }
        if (string5 != null) {
            element.setAttribute("text-decoration", string5);
        }
        if (string2 != null) {
            element.setAttribute("font-family", string2);
        }
        element.setTextContent(string);
        this.getG().appendChild(element);
        this.ensureVisible(d, d2);
        this.ensureVisible(d + d3, d2);
    }

    public final Element getDefs() {
        return this.defs;
    }

    private Transformer getTransformer() throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Log.info("TransformerFactory=" + transformerFactory.getClass());
        Transformer transformer = transformerFactory.newTransformer();
        Log.info("Transformer=" + transformer.getClass());
        transformer.setOutputProperty("standalone", "yes");
        return transformer;
    }

    public void createXml(OutputStream outputStream) throws TransformerException {
        DOMSource dOMSource = new DOMSource(this.document);
        String string = "width:" + this.maxX + ";height:" + this.maxY + ";";
        if (this.backcolor != null) {
            string = string + "background:" + this.backcolor + ";";
        }
        this.root.setAttribute("style", string);
        this.root.setAttribute("width", "" + this.maxX + "pt");
        this.root.setAttribute("height", "" + this.maxY + "pt");
        this.root.setAttribute("viewBox", "0 0 " + this.maxX + " " + this.maxY);
        StreamResult streamResult = new StreamResult(outputStream);
        this.getTransformer().transform(dOMSource, streamResult);
    }

    public String getGElement() throws TransformerException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamResult streamResult = new StreamResult(byteArrayOutputStream);
        this.getTransformer().transform(new DOMSource(this.gRoot), streamResult);
        byteArrayOutputStream.close();
        String string = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        return string.replaceFirst("^\\<\\?xml.*?\\?\\>", "");
    }

    public void svgPath(double d, double d2, UPath uPath) {
        StringBuilder stringBuilder = new StringBuilder();
        for (USegment uSegment : uPath) {
            USegmentType uSegmentType = uSegment.getSegmentType();
            double[] dArray = uSegment.getCoord();
            if (uSegmentType == USegmentType.SEG_MOVETO) {
                stringBuilder.append("M" + (dArray[0] + d) + "," + (dArray[1] + d2) + " ");
                continue;
            }
            if (uSegmentType == USegmentType.SEG_LINETO) {
                stringBuilder.append("L" + (dArray[0] + d) + "," + (dArray[1] + d2) + " ");
                continue;
            }
            if (uSegmentType == USegmentType.SEG_QUADTO) {
                stringBuilder.append("Q" + (dArray[0] + d) + "," + (dArray[1] + d2) + " " + (dArray[2] + d) + "," + (dArray[3] + d2) + " ");
                continue;
            }
            if (uSegmentType == USegmentType.SEG_CLOSE) continue;
            System.err.println("unknown " + uSegment);
        }
        Element element = this.document.createElement("path");
        element.setAttribute("d", stringBuilder.toString());
        element.setAttribute("style", this.getStyle());
        this.getG().appendChild(element);
        this.ensureVisible(d, d2);
    }

    public void newpath() {
        this.currentPath = new StringBuilder();
    }

    public void moveto(double d, double d2) {
        this.currentPath.append("M" + SvgGraphics.format(d) + "," + SvgGraphics.format(d2) + " ");
        this.ensureVisible(d, d2);
    }

    public void lineto(double d, double d2) {
        this.currentPath.append("L" + SvgGraphics.format(d) + "," + SvgGraphics.format(d2) + " ");
        this.ensureVisible(d, d2);
    }

    public void closepath() {
        this.currentPath.append("Z ");
    }

    public void curveto(double d, double d2, double d3, double d4, double d5, double d6) {
        this.currentPath.append("C" + SvgGraphics.format(d) + "," + SvgGraphics.format(d2) + " " + SvgGraphics.format(d3) + "," + SvgGraphics.format(d4) + " " + SvgGraphics.format(d5) + "," + SvgGraphics.format(d6) + " ");
        this.ensureVisible(d, d2);
        this.ensureVisible(d3, d4);
        this.ensureVisible(d5, d6);
    }

    public void quadto(double d, double d2, double d3, double d4) {
        this.currentPath.append("Q" + SvgGraphics.format(d) + "," + SvgGraphics.format(d2) + " " + SvgGraphics.format(d3) + "," + SvgGraphics.format(d4) + " ");
        this.ensureVisible(d, d2);
        this.ensureVisible(d3, d4);
    }

    private static String format(double d) {
        return EpsGraphics.format(d);
    }

    public void fill(int n) {
        Element element = this.document.createElement("path");
        element.setAttribute("d", this.currentPath.toString());
        this.getG().appendChild(element);
        this.currentPath = null;
    }
}

