/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.graphic.HtmlCommand;
import net.sourceforge.plantuml.graphic.ImgValign;
import net.sourceforge.plantuml.graphic.Text;
import net.sourceforge.plantuml.graphic.TileImage;

public class Img
implements HtmlCommand {
    private static final Pattern srcPattern = Pattern.compile("(?i)src\\s*=\\s*[\"']?([^ \">]+)[\"']?");
    private static final Pattern vspacePattern = Pattern.compile("(?i)vspace\\s*=\\s*[\"']?(\\d+)[\"']?");
    private static final Pattern valignPattern = Pattern.compile("(?i)valign\\s*=\\s*[\"']?(top|bottom|middle)[\"']?");
    private static final Pattern srcPattern2 = Pattern.compile("(?i)<img[\\s:]+([^>]+)/?>");
    private final TileImage tileImage;
    private final String filePath;

    private Img(TileImage tileImage, String string) throws IOException {
        this.tileImage = tileImage;
        this.filePath = string;
    }

    static int getVspace(String string) {
        Matcher matcher = vspacePattern.matcher(string);
        if (!matcher.find()) {
            return 0;
        }
        return Integer.parseInt(matcher.group(1));
    }

    static ImgValign getValign(String string) {
        Matcher matcher = valignPattern.matcher(string);
        if (!matcher.find()) {
            return ImgValign.TOP;
        }
        return ImgValign.valueOf(matcher.group(1).toUpperCase());
    }

    static HtmlCommand getInstance(String string) {
        Matcher matcher = srcPattern.matcher(string);
        if (!matcher.find()) {
            return new Text("(SYNTAX ERROR)");
        }
        String string2 = matcher.group(1);
        try {
            File file = FileSystem.getInstance().getFile(string2);
            if (!file.exists()) {
                return new Text("(File not found: " + file + ")");
            }
            int n = Img.getVspace(string);
            ImgValign imgValign = Img.getValign(string);
            return new Img(new TileImage(ImageIO.read(file), imgValign, n), string2);
        }
        catch (IOException iOException) {
            return new Text("ERROR " + iOException.toString());
        }
    }

    static HtmlCommand getInstance2(String string) {
        Matcher matcher = srcPattern2.matcher(string);
        if (!matcher.find()) {
            return new Text("(SYNTAX ERROR)");
        }
        String string2 = matcher.group(1);
        try {
            File file = FileSystem.getInstance().getFile(string2);
            if (!file.exists()) {
                return new Text("(File not found: " + file + ")");
            }
            return new Img(new TileImage(ImageIO.read(file), ImgValign.TOP, 0), string2);
        }
        catch (IOException iOException) {
            return new Text("ERROR " + iOException.toString());
        }
    }

    public TileImage createMonoImage() {
        return this.tileImage;
    }

    public final String getFilePath() {
        return this.filePath;
    }
}

