/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRoseDelayText
extends AbstractTextualComponent {
    public ComponentRoseDelayText(HtmlColor htmlColor, UFont uFont, List<? extends CharSequence> list) {
        super(list, htmlColor, uFont, HorizontalAlignement.CENTER, 4, 4, 4);
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, Dimension2D dimension2D) {
        TextBlock textBlock = this.getTextBlock();
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = this.getTextWidth(stringBounder);
        double d2 = this.getTextHeight(stringBounder);
        double d3 = (dimension2D.getWidth() - d) / 2.0;
        double d4 = (dimension2D.getHeight() - d2) / 2.0;
        uGraphic.getParam().setColor(this.getFontColor());
        textBlock.drawU(uGraphic, d3, d4 + (double)this.getMarginY());
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 20.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + 30.0;
    }
}

