/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core;

import java.sql.SQLException;
import java.util.Properties;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.v2.ConnectionFactoryImpl;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public abstract class ConnectionFactory {
    private static final Object[][] versions = new Object[][]{{"3", new org.postgresql.core.v3.ConnectionFactoryImpl()}, {"2", new ConnectionFactoryImpl()}};

    public static ProtocolConnection openConnection(String host, int port, String user, String database, Properties info) throws SQLException {
        String protoName = info.getProperty("protocolVersion");
        for (int i = 0; i < versions.length; ++i) {
            ConnectionFactory factory;
            ProtocolConnection connection;
            String versionProtoName = (String)versions[i][0];
            if (protoName != null && !protoName.equals(versionProtoName) || (connection = (factory = (ConnectionFactory)versions[i][1]).openConnectionImpl(host, port, user, database, info)) == null) continue;
            return connection;
        }
        throw new PSQLException(GT.tr("A connection could not be made using the requested protocol {0}.", protoName), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    public abstract ProtocolConnection openConnectionImpl(String var1, int var2, String var3, String var4, Properties var5) throws SQLException;
}

