/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query;

import com.hazelcast.core.MapEntry;
import com.hazelcast.impl.Record;
import com.hazelcast.query.IndexStore;
import com.hazelcast.query.MultiResultSet;
import com.hazelcast.query.PredicateType;
import com.hazelcast.query.SingleResultSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsortedIndexStore
implements IndexStore {
    private final ConcurrentMap<Long, ConcurrentMap<Long, Record>> mapRecords = new ConcurrentHashMap<Long, ConcurrentMap<Long, Record>>(100, 0.75f, 1);
    private volatile boolean doubleValue = false;

    public void setDoubleValue(boolean doubleValue) {
        this.doubleValue = doubleValue;
    }

    @Override
    public void getSubRecordsBetween(MultiResultSet results, Long from, Long to) {
        Set values = this.mapRecords.keySet();
        if (this.doubleValue) {
            double f = Double.longBitsToDouble(from);
            double t = Double.longBitsToDouble(to);
            for (Long value : values) {
                ConcurrentMap records;
                double v = Double.longBitsToDouble(value);
                if (!(v >= f) || !(v <= t) || (records = (ConcurrentMap)this.mapRecords.get(value)) == null) continue;
                results.addResultSet(value, records.values());
            }
        } else {
            for (Long value : values) {
                ConcurrentMap records;
                if (value < from || value > to || (records = (ConcurrentMap)this.mapRecords.get(value)) == null) continue;
                results.addResultSet(value, records.values());
            }
        }
    }

    @Override
    public void getSubRecords(MultiResultSet results, PredicateType predicateType, Long searchedValue) {
        Set values = this.mapRecords.keySet();
        for (Long value : values) {
            ConcurrentMap records;
            boolean valid = false;
            if (this.doubleValue) {
                double v = Double.longBitsToDouble(value);
                double searchedV = Double.longBitsToDouble(searchedValue);
                switch (predicateType) {
                    case LESSER: {
                        valid = v < searchedV;
                        break;
                    }
                    case LESSER_EQUAL: {
                        valid = v <= searchedV;
                        break;
                    }
                    case GREATER: {
                        valid = v > searchedV;
                        break;
                    }
                    case GREATER_EQUAL: {
                        valid = v >= searchedV;
                        break;
                    }
                    case NOT_EQUAL: {
                        valid = v != searchedV;
                    }
                }
            }
            switch (predicateType) {
                case LESSER: {
                    valid = value < searchedValue;
                    break;
                }
                case LESSER_EQUAL: {
                    valid = value <= searchedValue;
                    break;
                }
                case GREATER: {
                    valid = value > searchedValue;
                    break;
                }
                case GREATER_EQUAL: {
                    valid = value >= searchedValue;
                    break;
                }
                case NOT_EQUAL: {
                    boolean bl = valid = value.longValue() != searchedValue.longValue();
                }
            }
            if (!valid || (records = (ConcurrentMap)this.mapRecords.get(value)) == null) continue;
            results.addResultSet(value, records.values());
        }
    }

    @Override
    public void newRecordIndex(Long newValue, Record record) {
        Long recordId = record.getId();
        ConcurrentHashMap<Long, Record> records = (ConcurrentHashMap<Long, Record>)this.mapRecords.get(newValue);
        if (records == null) {
            records = new ConcurrentHashMap<Long, Record>(1, 0.75f, 1);
            this.mapRecords.put(newValue, records);
        }
        records.put(recordId, record);
    }

    @Override
    public void removeRecordIndex(Long oldValue, Long recordId) {
        ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(oldValue);
        if (records != null) {
            records.remove(recordId);
            if (records.size() == 0) {
                this.mapRecords.remove(oldValue);
            }
        }
    }

    @Override
    public Set<MapEntry> getRecords(Long value) {
        return new SingleResultSet((ConcurrentMap)this.mapRecords.get(value));
    }

    @Override
    public void getRecords(MultiResultSet results, Set<Long> values) {
        for (Long value : values) {
            ConcurrentMap records = (ConcurrentMap)this.mapRecords.get(value);
            if (records == null) continue;
            results.addResultSet(value, records.values());
        }
    }

    @Override
    public ConcurrentMap<Long, ConcurrentMap<Long, Record>> getMapRecords() {
        return this.mapRecords;
    }

    public String toString() {
        return "UnsortedIndexStore{mapRecords=" + this.mapRecords.size() + '}';
    }
}

