/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.ListenerConfig;
import com.hazelcast.nio.DataSerializable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TopicConfig
implements DataSerializable {
    public static final boolean DEFAULT_GLOBAL_ORDERING_ENABLED = false;
    private String name;
    private boolean globalOrderingEnabled = false;
    private List<ListenerConfig> listenerConfigs;

    public TopicConfig() {
    }

    public TopicConfig(TopicConfig config) {
        this.name = config.name;
        this.globalOrderingEnabled = config.globalOrderingEnabled;
    }

    public String getName() {
        return this.name;
    }

    public TopicConfig setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isGlobalOrderingEnabled() {
        return this.globalOrderingEnabled;
    }

    public TopicConfig setGlobalOrderingEnabled(boolean globalOrderingEnabled) {
        this.globalOrderingEnabled = globalOrderingEnabled;
        return this;
    }

    public TopicConfig addMessageListenerConfig(ListenerConfig listenerConfig) {
        this.getMessageListenerConfigs().add(listenerConfig);
        return this;
    }

    public List<ListenerConfig> getMessageListenerConfigs() {
        if (this.listenerConfigs == null) {
            this.listenerConfigs = new ArrayList<ListenerConfig>();
        }
        return this.listenerConfigs;
    }

    public void setMessageListenerConfigs(List<ListenerConfig> listenerConfigs) {
        this.listenerConfigs = listenerConfigs;
    }

    public int hashCode() {
        return (this.globalOrderingEnabled ? 1231 : 1237) + 31 * (this.name != null ? this.name.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TopicConfig)) {
            return false;
        }
        TopicConfig other = (TopicConfig)obj;
        return (this.name != null ? this.name.equals(other.name) : other.name == null) && this.globalOrderingEnabled == other.globalOrderingEnabled;
    }

    public String toString() {
        return "TopicConfig [name=" + this.name + ", globalOrderingEnabled=" + this.globalOrderingEnabled + "]";
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeBoolean(this.globalOrderingEnabled);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.name = in.readUTF();
        this.globalOrderingEnabled = in.readBoolean();
    }
}

