/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.resources;

import com.codahale.metrics.annotation.Timed;
import io.dropwizard.auth.AuthenticationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Positive;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.bookkeeper.api.Customer;
import org.dataone.bookkeeper.api.Quota;
import org.dataone.bookkeeper.api.Usage;
import org.dataone.bookkeeper.api.UsageList;
import org.dataone.bookkeeper.api.UsageStatus;
import org.dataone.bookkeeper.jdbi.QuotaStore;
import org.dataone.bookkeeper.jdbi.UsageStore;
import org.dataone.bookkeeper.security.DataONEAuthHelper;
import org.jdbi.v3.core.Jdbi;

@Timed
@Path(value="/usages")
@Produces(value={"application/json"})
public class UsagesResource {
    private Log log = LogFactory.getLog(UsagesResource.class);
    private final QuotaStore quotaStore;
    private final UsageStore usageStore;
    private final DataONEAuthHelper dataoneAuthHelper;

    public UsagesResource(Jdbi database, DataONEAuthHelper dataoneAuthHelper) {
        this.quotaStore = (QuotaStore)database.onDemand(QuotaStore.class);
        this.usageStore = (UsageStore)database.onDemand(UsageStore.class);
        this.dataoneAuthHelper = dataoneAuthHelper;
    }

    @Timed
    @GET
    @PermitAll
    public UsageList listUsages(@Context SecurityContext context, @QueryParam(value="start") @DefaultValue(value="0") Integer start, @QueryParam(value="count") @DefaultValue(value="1000") Integer count, @QueryParam(value="quotaId") Integer quotaId, @QueryParam(value="quotaType") String quotaType, @QueryParam(value="instanceId") String instanceId, @QueryParam(value="status") String status, @QueryParam(value="subject") Set<String> subjects, @QueryParam(value="requestor") String requestor) {
        List<Object> usages = null;
        Usage usage = null;
        Customer caller = (Customer)context.getUserPrincipal();
        boolean isAdmin = this.dataoneAuthHelper.isAdmin(caller.getSubject());
        ArrayList<Object> approvedSubjects = new ArrayList<String>();
        Boolean isProxy = isAdmin && requestor != null;
        if (requestor != null) {
            if (isAdmin) {
                try {
                    caller = this.dataoneAuthHelper.createCustomerFromSubject(requestor);
                }
                catch (AuthenticationException dae) {
                    String message = "The requested usages couldn't be listed: " + dae.getMessage();
                    throw new WebApplicationException(message, Response.Status.BAD_REQUEST);
                }
            } else {
                throw new WebApplicationException(caller.getSubject() + " does not have admin privilege needed to set 'requestor'. ", Response.Status.FORBIDDEN);
            }
        }
        if (subjects != null && subjects.size() > 0) {
            if (!isAdmin || isProxy.booleanValue()) {
                Set<String> associatedSubjects = this.dataoneAuthHelper.filterByAssociatedSubjects(caller, subjects);
                if (associatedSubjects.size() > 0) {
                    approvedSubjects.addAll(associatedSubjects);
                }
                if (approvedSubjects.size() == 0) {
                    throw new WebApplicationException("The requested subjects don't exist or requestor doesn't have privilege to view them.", Response.Status.FORBIDDEN);
                }
            } else {
                approvedSubjects.addAll(subjects);
            }
        } else if ((!isAdmin || isProxy.booleanValue()) && approvedSubjects.size() == 0) {
            approvedSubjects = new ArrayList<String>(this.dataoneAuthHelper.getAssociatedSubjects(caller));
        }
        if (instanceId != null && quotaId != null) {
            usage = approvedSubjects.size() == 0 ? this.usageStore.findUsageByInstanceIdAndQuotaId(instanceId, quotaId) : this.usageStore.findUsageByInstanceIdQuotaIdAndSubjects(instanceId, quotaId, approvedSubjects);
            if (usage == null) {
                usages = null;
            } else {
                usages = new ArrayList<Usage>();
                usages.add(usage);
            }
        } else if (instanceId != null && quotaType != null) {
            usage = this.usageStore.findUsageByInstanceIdAndQuotaType(instanceId, quotaType);
            if (usage == null) {
                usages = null;
            } else {
                usages = new ArrayList<Usage>();
                usages.add(usage);
            }
        } else {
            usages = instanceId != null ? (approvedSubjects.size() == 0 ? this.usageStore.findUsagesByInstanceId(instanceId) : this.usageStore.findUsagesByInstanceIdAndSubjects(instanceId, approvedSubjects)) : (quotaId != null ? (approvedSubjects.size() == 0 ? this.usageStore.findUsagesByQuotaId(quotaId) : this.usageStore.findUsagesByQuotaIdAndSubjects(quotaId, approvedSubjects)) : (quotaType != null ? (approvedSubjects.size() == 0 ? this.usageStore.findUsagesByQuotaType(quotaType) : this.usageStore.findUsagesByQuotaTypeAndSubjects(quotaType, approvedSubjects)) : (approvedSubjects.size() > 0 ? this.usageStore.findUsagesByQuotaSubjects(approvedSubjects) : this.usageStore.listUsages())));
        }
        if (usages == null || usages.size() == 0) {
            if (!isAdmin || isProxy.booleanValue()) {
                throw new WebApplicationException("The requested usages were not found or requestor does not have privilege to view them.", Response.Status.NOT_FOUND);
            }
            throw new WebApplicationException("The requested usage was not found.", Response.Status.NOT_FOUND);
        }
        if (status != null) {
            List filteredUsages = usages.stream().filter(u -> u.getStatus().compareToIgnoreCase(status) == 0).collect(Collectors.toList());
            if (filteredUsages.size() > 0) {
                usages = filteredUsages;
            } else {
                throw new WebApplicationException("No requested usages found with status = " + status, Response.Status.NOT_FOUND);
            }
        }
        return new UsageList(usages);
    }

    @Timed
    @POST
    @PermitAll
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Usage create(@Context SecurityContext context, @NotNull @Valid Usage usage) throws WebApplicationException {
        String DEFAULT_STATUS = "active";
        Customer caller = (Customer)context.getUserPrincipal();
        boolean isAdmin = this.dataoneAuthHelper.isAdmin(caller.getSubject());
        if (isAdmin) {
            try {
                if (usage.getStatus().compareToIgnoreCase(DEFAULT_STATUS) != 0) {
                    usage.setStatus(DEFAULT_STATUS);
                }
                Integer id = this.usageStore.insert(usage);
                usage = this.usageStore.getUsage(id);
            }
            catch (Exception e) {
                String message = "Couldn't insert the usage: " + e.getMessage();
                throw new WebApplicationException(message, Response.Status.INTERNAL_SERVER_ERROR);
            }
            return usage;
        }
        throw new WebApplicationException("Admin privilege is required to create a usage, " + caller.getSubject() + " is not authorized.", Response.Status.FORBIDDEN);
    }

    @Timed
    @GET
    @PermitAll
    @Produces(value={"application/json"})
    @Path(value="{id}")
    public Usage retrieve(@Context SecurityContext context, @PathParam(value="id") @NotNull Integer id) throws WebApplicationException {
        Usage usage = null;
        Customer caller = (Customer)context.getUserPrincipal();
        usage = this.usageStore.getUsage(id);
        if (usage == null) {
            throw new WebApplicationException("The requested usage was not found.", Response.Status.NOT_FOUND);
        }
        if (this.dataoneAuthHelper.isAdmin(caller.getSubject())) {
            return usage;
        }
        Integer quotaId = usage.getQuotaId();
        Quota quota = this.quotaStore.getQuota(quotaId);
        HashSet<String> subjects = new HashSet<String>();
        subjects.add(quota.getSubject());
        Set<String> associatedSubjects = this.dataoneAuthHelper.filterByAssociatedSubjects(caller, subjects);
        if (associatedSubjects.size() > 0) {
            return usage;
        }
        throw new WebApplicationException(caller.getSubject() + " is not associated with this usage.", Response.Status.FORBIDDEN);
    }

    @Timed
    @PUT
    @PermitAll
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{usageId}")
    public Usage update(@Context SecurityContext context, @NotNull @Valid Usage usage, @PathParam(value="usageId") @NotNull @Positive Integer usageId) throws WebApplicationException {
        Usage updatedUsage;
        Customer caller = (Customer)context.getUserPrincipal();
        boolean isAdmin = this.dataoneAuthHelper.isAdmin(caller.getSubject());
        if (isAdmin) {
            try {
                updatedUsage = this.usageStore.update(usage);
            }
            catch (Exception e) {
                String message = "Couldn't update the usage: " + e.getMessage();
                throw new WebApplicationException(message, Response.Status.INTERNAL_SERVER_ERROR);
            }
        } else {
            throw new WebApplicationException("Admin privilege is required to update a usage, " + caller.getSubject() + " is not authorized.", Response.Status.FORBIDDEN);
        }
        return updatedUsage;
    }

    @Timed
    @DELETE
    @PermitAll
    @Path(value="{usageId}")
    public Response delete(@Context SecurityContext context, @PathParam(value="usageId") @Valid Integer usageId) throws WebApplicationException {
        String message = "The usageId cannot be null.";
        if (usageId == null) {
            throw new WebApplicationException(message, Response.Status.BAD_REQUEST);
        }
        Customer caller = (Customer)context.getUserPrincipal();
        if (!this.dataoneAuthHelper.isAdmin(caller.getSubject())) {
            throw new WebApplicationException("Admin privilege is required to delete a usage, " + caller.getSubject() + " is not authorized.", Response.Status.FORBIDDEN);
        }
        try {
            this.usageStore.delete(usageId);
        }
        catch (Exception e) {
            message = "Deleting the usage with id " + usageId + " failed: " + e.getMessage();
            this.log.error((Object)message);
            e.printStackTrace();
            throw new WebApplicationException(message, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return Response.ok().build();
    }

    @Timed
    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    public UsageStatus getStatus(@QueryParam(value="quotaType") String quotaType, @QueryParam(value="instanceId") String instanceId) throws WebApplicationException {
        this.log.debug((Object)"Usage status");
        Usage usage = null;
        UsageStatus usageStatus = null;
        String message = null;
        if (quotaType == null || instanceId == null) {
            message = "Both quotaType and instanceId must be specified.";
            throw new WebApplicationException(message, Response.Status.BAD_REQUEST);
        }
        try {
            this.log.debug((Object)"Usage status query");
            usage = this.usageStore.findUsageByInstanceIdAndQuotaType(instanceId, quotaType);
        }
        catch (Exception e) {
            message = "Retrieving the usage with instanceId: " + instanceId + ", quotaType: " + quotaType + " failed: " + e.getMessage();
            this.log.error((Object)message);
            throw new WebApplicationException(message, Response.Status.INTERNAL_SERVER_ERROR);
        }
        if (usage == null) {
            throw new WebApplicationException("The requested usage status was not found.", Response.Status.NOT_FOUND);
        }
        usageStatus = new UsageStatus("usagestatus", usage.getStatus());
        return usageStatus;
    }
}

