/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.resources;

import com.codahale.metrics.annotation.Timed;
import java.time.Instant;
import java.util.List;
import javax.annotation.security.PermitAll;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.bookkeeper.api.Customer;
import org.dataone.bookkeeper.api.Product;
import org.dataone.bookkeeper.api.ProductList;
import org.dataone.bookkeeper.jdbi.ProductStore;
import org.dataone.bookkeeper.resources.BaseResource;
import org.dataone.bookkeeper.security.DataONEAuthHelper;
import org.jdbi.v3.core.Jdbi;

@Timed
@Path(value="/products")
@Produces(value={"application/json"})
public class ProductsResource
extends BaseResource {
    private Log log = LogFactory.getLog(ProductsResource.class);
    private final ProductStore productStore;
    private final DataONEAuthHelper dataoneAuthHelper;

    public ProductsResource(Jdbi database, DataONEAuthHelper dataoneAuthHelper) {
        this.productStore = (ProductStore)database.onDemand(ProductStore.class);
        this.dataoneAuthHelper = dataoneAuthHelper;
    }

    @Timed
    @GET
    @Produces(value={"application/json"})
    public ProductList listProducts(@QueryParam(value="start") @DefaultValue(value="0") Integer start, @QueryParam(value="count") @DefaultValue(value="1000") Integer count, @QueryParam(value="name") String name, @QueryParam(value="description") String description, @QueryParam(value="status") Boolean status) throws WebApplicationException {
        List<Product> products = name != null ? this.productStore.findProductsByName(name) : (description != null ? this.productStore.findProductsByDescription(description) : (status != null ? this.productStore.findProductsByActiveStatus(status) : this.productStore.listProducts()));
        return new ProductList(products);
    }

    @Timed
    @POST
    @PermitAll
    @Consumes(value={"application/json"})
    public Product create(@Context SecurityContext context, @NotNull @Valid Product product) throws WebApplicationException {
        Customer caller = (Customer)context.getUserPrincipal();
        if (!this.dataoneAuthHelper.isBookkeeperAdmin(caller.getSubject())) {
            throw new WebApplicationException("Bookkeeper admin privilege is required to create a product, " + caller.getSubject() + " is not authorized.", Response.Status.FORBIDDEN);
        }
        try {
            product.setCreated(new Integer((int)Instant.now().getEpochSecond()));
            Integer id = this.productStore.insert(product);
            product = this.productStore.getProduct(id);
        }
        catch (Exception e) {
            String message = "Couldn't insert the product: " + e.getMessage();
            throw new WebApplicationException(message, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return product;
    }

    @Timed
    @GET
    @Produces(value={"application/json"})
    @Path(value="{productId}")
    public Product retrieve(@PathParam(value="productId") @NotNull Integer productId) throws WebApplicationException {
        Product product = null;
        try {
            product = this.productStore.getProduct(productId);
        }
        catch (Exception e) {
            String message = "Couldn't get the product: " + e.getMessage();
            throw new WebApplicationException(message, Response.Status.NOT_FOUND);
        }
        return product;
    }

    @Timed
    @PUT
    @PermitAll
    @Produces(value={"application/json"})
    @Path(value="{productId}")
    public Product update(@Context SecurityContext context, @NotNull @Valid Product product) throws WebApplicationException {
        Customer caller = (Customer)context.getUserPrincipal();
        if (!this.dataoneAuthHelper.isBookkeeperAdmin(caller.getSubject())) {
            throw new WebApplicationException("Bookkeeper admin privilege is required to update a product, " + caller.getSubject() + " is not authorized.", Response.Status.FORBIDDEN);
        }
        try {
            Product existing = this.productStore.getProduct(product.getId());
            product.setCreated(existing.getCreated());
            this.productStore.update(product);
        }
        catch (Exception e) {
            String message = "Couldn't update the product: " + e.getMessage();
            throw new WebApplicationException(message, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return product;
    }

    @Timed
    @DELETE
    @PermitAll
    @Path(value="{productId}")
    public Response delete(@Context SecurityContext context, @PathParam(value="productId") @Valid Integer productId) throws WebApplicationException {
        Customer caller = (Customer)context.getUserPrincipal();
        if (!this.dataoneAuthHelper.isBookkeeperAdmin(caller.getSubject())) {
            throw new WebApplicationException("Bookkeeper admin privilege is required to delete a product, " + caller.getSubject() + " is not authorized.", Response.Status.FORBIDDEN);
        }
        String message = "The productId cannot be null.";
        if (productId == null) {
            throw new WebApplicationException(message, Response.Status.BAD_REQUEST);
        }
        try {
            this.productStore.delete(productId);
        }
        catch (Exception e) {
            message = "Deleting the product with id " + productId + " failed: " + e.getMessage();
            this.log.error((Object)message);
            e.printStackTrace();
            throw e;
        }
        return Response.ok().build();
    }
}

