/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage.sql.internals;

import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnDescriptorEntry;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnDescriptors;
import edu.uiuc.ncsa.security.storage.sql.internals.ColumnTypeTranslator;

public abstract class Table {
    protected SerializationKeys keys;
    protected String tablename;
    protected ColumnDescriptors columnDescriptor;
    ColumnTypeTranslator columnTypeTranslator;
    String schema;
    String tablenamePrefix = "a";

    public String getFQTablename() {
        return this.fqTablename(this.getTablename());
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public void createColumnDescriptors() {
        this.getColumnDescriptor().add(new ColumnDescriptorEntry(this.keys.identifier(new String[0]), -1, false, true));
    }

    public ColumnDescriptors getColumnDescriptor() {
        if (this.columnDescriptor == null) {
            this.columnDescriptor = new ColumnDescriptors();
            this.createColumnDescriptors();
        }
        return this.columnDescriptor;
    }

    public Table(SerializationKeys keys, String schema, String tablenamePrefix, String tablename) {
        this.schema = schema;
        this.tablenamePrefix = tablenamePrefix;
        this.tablename = tablename;
        this.keys = keys;
    }

    public String getPrimaryKeyColumnName() {
        return this.getColumnDescriptor().getPrimaryKey().getName();
    }

    public ColumnTypeTranslator getColumnTypeTranslator() {
        if (this.columnTypeTranslator == null) {
            this.columnTypeTranslator = new ColumnTypeTranslator(){};
        }
        return this.columnTypeTranslator;
    }

    public String createTableStatement() {
        String x = "CREATE TABLE " + this.getFQTablename() + "(";
        boolean isFirst = true;
        for (ColumnDescriptorEntry cde : this.getColumnDescriptor()) {
            String temp = cde.getName() + " " + this.getColumnTypeTranslator().toSQL(cde) + " " + (cde.isNullable() ? "" : "NOT NULL");
            if (isFirst) {
                x = x + temp;
                isFirst = false;
                continue;
            }
            x = x + "," + temp;
        }
        x = x + ")";
        return x;
    }

    public String createSelectStatement() {
        return "SELECT * from " + this.getFQTablename() + " where " + this.getPrimaryKeyColumnName() + " =?";
    }

    public String createRegisterStatement() {
        String x = null;
        boolean isFirst = true;
        for (ColumnDescriptorEntry cde : this.getColumnDescriptor()) {
            if (isFirst) {
                x = cde.getName();
                isFirst = false;
                continue;
            }
            x = x + ", " + cde.getName();
        }
        return x;
    }

    public String getTablenamePrefix() {
        return this.tablenamePrefix;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setTablenamePrefix(String tablenamePrefix) {
        this.tablenamePrefix = tablenamePrefix;
    }

    protected String fqTablename(String name) {
        String prefix = this.getTablenamePrefix();
        if (prefix != null && prefix.length() != 0) {
            name = prefix + "_" + name;
        }
        if (this.getSchema() != null && this.getSchema().length() != 0) {
            return this.getSchema() + "." + name;
        }
        return name;
    }

    public String createUpdateStatement() {
        String out = "UPDATE " + this.getFQTablename() + " SET ";
        boolean isFirst = true;
        for (ColumnDescriptorEntry cde : this.getColumnDescriptor()) {
            if (cde.isPrimaryKey()) continue;
            out = out + (isFirst ? "" : ", ") + cde.getName() + "=?";
            if (!isFirst) continue;
            isFirst = false;
        }
        out = out + " WHERE " + this.getPrimaryKeyColumnName() + "=?";
        return out;
    }

    public String createInsertStatement() {
        String out = "insert into " + this.getFQTablename() + "(" + this.createRegisterStatement() + ") values (";
        String qmarks = "";
        for (int i = 0; i < this.getColumnDescriptor().size(); ++i) {
            qmarks = qmarks + "?" + (i + 1 == this.getColumnDescriptor().size() ? "" : ", ");
        }
        out = out + qmarks + ")";
        return out;
    }

    public String createMassInsertStatement() {
        String out = "insert IGNORE into " + this.getFQTablename() + "(" + this.createRegisterStatement() + ") values (";
        String qmarks = "";
        for (int i = 0; i < this.getColumnDescriptor().size(); ++i) {
            qmarks = qmarks + "?" + (i + 1 == this.getColumnDescriptor().size() ? "" : ", ");
        }
        out = out + qmarks + ")";
        return out;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[schema=" + this.getSchema() + ", prefix=" + this.getTablenamePrefix() + ", name=" + this.getTablename() + "]";
    }
}

