/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorDistinctAll;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.graph.NodeConst;
import org.apache.jena.atlas.logging.Log;

public class AggCountDistinct
extends AggregatorBase {
    @Override
    public Aggregator copy(Expr expr) {
        if (expr != null) {
            Log.warn(this, "Copying non-null expression for COUNT(DISTINCT *)");
        }
        return new AggCountDistinct();
    }

    @Override
    public String toString() {
        return "count(distinct *)";
    }

    @Override
    public String toPrefixString() {
        return "(count distinct)";
    }

    @Override
    public Expr getExpr() {
        return null;
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccCountDistinct();
    }

    @Override
    public Node getValueEmpty() {
        return NodeConst.nodeZero;
    }

    @Override
    public int hashCode() {
        return 371;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof AggCountDistinct;
    }

    static class AccCountDistinct
    extends AccumulatorDistinctAll {
        private long count = 0L;

        @Override
        public void accumulateDistinct(Binding binding, FunctionEnv functionEnv) {
            ++this.count;
        }

        @Override
        public NodeValue getValue() {
            return NodeValue.makeInteger(this.count);
        }
    }
}

