/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.v2.impl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.dataone.client.D1NodeFactory;
import org.dataone.client.exception.ClientSideException;
import org.dataone.client.rest.DefaultHttpMultipartRestClient;
import org.dataone.client.rest.MultipartRestClient;
import org.dataone.client.v2.CNode;
import org.dataone.client.v2.impl.NodeListNodeLocator;
import org.dataone.configuration.Settings;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v2.NodeList;

public class SettingsContextNodeLocator
extends NodeListNodeLocator {
    protected Map<String, String> baseUrlMap;
    protected CNode designatedCN;

    public SettingsContextNodeLocator() throws NotImplemented, ServiceFailure, ClientSideException, IOException {
        this(new DefaultHttpMultipartRestClient());
    }

    public SettingsContextNodeLocator(MultipartRestClient mrc) throws NotImplemented, ServiceFailure, ClientSideException {
        super(SettingsContextNodeLocator.getNodeListFromSettingsCN(mrc), mrc);
        this.designatedCN = SettingsContextNodeLocator.getCnFromSettings(mrc);
    }

    @Override
    public CNode getCNode() {
        return this.designatedCN;
    }

    private static NodeList getNodeListFromSettingsCN(MultipartRestClient mrc) throws ClientSideException, NotImplemented, ServiceFailure {
        return SettingsContextNodeLocator.getCnFromSettings(mrc).listNodes();
    }

    private static CNode getCnFromSettings(MultipartRestClient mrc) throws ClientSideException {
        CNode cn;
        String cnUri = Settings.getConfiguration().getString("D1Client.CN_URL");
        String cnClassName = Settings.getConfiguration().getString("D1Client.cnClassName");
        String uri = null;
        try {
            if (cnClassName == null) {
                uri = cnUri;
                cn = D1NodeFactory.buildNode(CNode.class, mrc, new URI(cnUri));
            } else {
                uri = cnClassName;
                cn = D1NodeFactory.buildNode(CNode.class, mrc, new URI(cnClassName));
                Method setBaseUrlMethod = cn.getClass().getMethod("setNodeBaseServiceUrl", String.class);
                setBaseUrlMethod.invoke((Object)cn, cnUri);
            }
        }
        catch (URISyntaxException e) {
            throw new ClientSideException("Failed to build a CNode from provided CN baseUri: " + uri, e);
        }
        catch (NoSuchMethodException e) {
            throw new ClientSideException("Failed to find the setNodeBaseServiceUrl via reflection from the instantiated CN class: " + cnClassName, e);
        }
        catch (IllegalAccessException e) {
            throw new ClientSideException("Failed to set the nodeBaseServiceUrl via reflection from the instantiated CN class: " + cnClassName, e);
        }
        catch (InvocationTargetException e) {
            throw new ClientSideException("Failed to set the nodeBaseServiceUrl via reflection from the instantiated CN class: " + cnClassName, e);
        }
        if (cn == null) {
            throw new ClientSideException("Libclient error:  CNode return value would have been null!!!");
        }
        return cn;
    }
}

