/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.transfer;

import gov.loc.repository.bagit.Bag;
import gov.loc.repository.bagit.BagFactory;
import gov.loc.repository.bagit.BagFile;
import gov.loc.repository.bagit.BagHelper;
import gov.loc.repository.bagit.BagItTxt;
import gov.loc.repository.bagit.Cancellable;
import gov.loc.repository.bagit.FetchTxt;
import gov.loc.repository.bagit.Manifest;
import gov.loc.repository.bagit.ManifestHelper;
import gov.loc.repository.bagit.ProgressListenable;
import gov.loc.repository.bagit.ProgressListener;
import gov.loc.repository.bagit.impl.FileBagFile;
import gov.loc.repository.bagit.transfer.BagFetchResult;
import gov.loc.repository.bagit.transfer.BagTransferCancelledException;
import gov.loc.repository.bagit.transfer.BagTransferException;
import gov.loc.repository.bagit.transfer.FetchContext;
import gov.loc.repository.bagit.transfer.FetchFailStrategy;
import gov.loc.repository.bagit.transfer.FetchFailureAction;
import gov.loc.repository.bagit.transfer.FetchFilenameSorter;
import gov.loc.repository.bagit.transfer.FetchProtocol;
import gov.loc.repository.bagit.transfer.FetchTarget;
import gov.loc.repository.bagit.transfer.FetchedFileDestination;
import gov.loc.repository.bagit.transfer.FetchedFileDestinationFactory;
import gov.loc.repository.bagit.transfer.FileFetcher;
import gov.loc.repository.bagit.transfer.StandardFailStrategies;
import gov.loc.repository.bagit.transfer.dest.FileSystemFileDestination;
import gov.loc.repository.bagit.utilities.SimpleResult;
import gov.loc.repository.bagit.utilities.SimpleResultHelper;
import gov.loc.repository.bagit.verify.FailModeSupporting;
import gov.loc.repository.bagit.verify.impl.ValidHoleyBagVerifier;
import gov.loc.repository.bagit.writer.impl.FileSystemWriter;
import java.io.File;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class BagFetcher
implements Cancellable,
ProgressListenable {
    private static final Log log = LogFactory.getLog(BagFetcher.class);
    private int numberOfThreads;
    private FetchFailStrategy failStrategy = StandardFailStrategies.FAIL_FAST;
    private FetchedFileDestinationFactory destinationFactory;
    private Map<String, FetchProtocol> protocolFactories = Collections.synchronizedMap(new HashMap());
    private BagFactory bagFactory;
    private boolean isCancelled = false;
    private List<ProgressListener> progressListeners = new ArrayList<ProgressListener>();
    private String username;
    private String password;
    private Bag bagToFetch;
    private List<FetchTarget> fetchTargets;
    private List<FetchTarget> failedFetchTargets;
    private AtomicInteger nextFetchTargetIndex;
    private List<BagFile> newBagFiles;
    private List<Fetcher> runningFetchers = Collections.synchronizedList(new ArrayList());
    private String baseUrl;

    public BagFetcher(BagFactory bagFactory) {
        this.bagFactory = bagFactory;
        this.numberOfThreads = Runtime.getRuntime().availableProcessors();
    }

    @Override
    public void cancel() {
        log.info((Object)"Cancelled.");
        this.isCancelled = true;
        for (Fetcher fetcher : this.runningFetchers) {
            fetcher.cancel();
        }
    }

    @Override
    public boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public void addProgressListener(ProgressListener progressListener) {
        this.progressListeners.add(progressListener);
    }

    @Override
    public void removeProgressListener(ProgressListener progressListener) {
        this.progressListeners.remove(progressListener);
    }

    private void progress(String activity, Object item, Long count, Long total) {
        for (ProgressListener listener : this.progressListeners) {
            listener.reportProgress(activity, item, count, total);
        }
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int numberOfThreads) {
        if (this.numberOfThreads < 1) {
            throw new IllegalArgumentException(MessageFormat.format("Number of threads cannot be less than 1: {0}", numberOfThreads));
        }
        this.numberOfThreads = numberOfThreads;
    }

    public FetchFailStrategy getFetchFailStrategy() {
        return this.failStrategy;
    }

    public void setFetchFailStrategy(FetchFailStrategy strategy) {
        if (strategy == null) {
            throw new NullPointerException("strategy cannot be null");
        }
        this.failStrategy = strategy;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    protected String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected String getPassword() {
        return this.password;
    }

    public void registerProtocol(String scheme, FetchProtocol protocol) {
        String normalizedScheme = scheme.toLowerCase();
        this.protocolFactories.put(normalizedScheme, protocol);
    }

    public BagFetchResult fetch(Bag bag, FetchedFileDestinationFactory destinationFactory) throws BagTransferException {
        return this.fetch(bag, destinationFactory, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BagFetchResult fetch(Bag bag, FetchedFileDestinationFactory destinationFactory, boolean resume) throws BagTransferException {
        this.bagToFetch = bag;
        this.destinationFactory = destinationFactory;
        this.checkBagSanity();
        this.buildFetchTargets(resume);
        this.nextFetchTargetIndex = new AtomicInteger(0);
        this.newBagFiles = Collections.synchronizedList(new ArrayList(this.fetchTargets.size()));
        this.failedFetchTargets = Collections.synchronizedList(new ArrayList());
        BagFetchResult finalResult = new BagFetchResult(true);
        if (this.numberOfThreads > 1) {
            ExecutorService threadPool = Executors.newCachedThreadPool();
            BagFetcherShutdownHook shutdownHook = new BagFetcherShutdownHook();
            shutdownHook.hook();
            try {
                log.debug((Object)MessageFormat.format("Submitting {0} jobs.", this.numberOfThreads));
                ArrayList<Future<SimpleResult>> futureResults = new ArrayList<Future<SimpleResult>>();
                for (int i = 0; i < this.numberOfThreads; ++i) {
                    log.trace((Object)MessageFormat.format("Submitting job {0} of {1}.", i + 1, this.numberOfThreads));
                    Fetcher fetcher = new Fetcher();
                    this.runningFetchers.add(fetcher);
                    futureResults.add(threadPool.submit(fetcher));
                }
                log.debug((Object)"Jobs submitted.  Waiting on results.");
                for (Future future : futureResults) {
                    String msg;
                    try {
                        SimpleResult result = (SimpleResult)future.get();
                        finalResult.merge(result);
                    }
                    catch (ExecutionException e) {
                        msg = MessageFormat.format("An unexpected exception occurred while processing the transfers: {0}", e.getCause().getMessage());
                        finalResult.addMessage(msg);
                        finalResult.setSuccess(false);
                        log.error((Object)msg, (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        msg = MessageFormat.format("Interrupted while waiting for the child threads to complete: {0}", e.getMessage());
                        finalResult.addMessage(msg);
                        finalResult.setSuccess(false);
                        log.error((Object)msg, (Throwable)e);
                    }
                }
            }
            finally {
                log.trace((Object)"Shutting down thread pool.");
                threadPool.shutdown();
                log.trace((Object)"Shutting down thread pool.");
                log.trace((Object)"Releasing shutdown hook.");
                shutdownHook.unhook();
            }
        }
        log.debug((Object)"Fetching in single-threaded mode.");
        try {
            Fetcher fetcher = new Fetcher();
            SimpleResult result = fetcher.call();
            finalResult.merge(result);
        }
        catch (Exception e) {
            throw new BagTransferException("Caught unexpected exception from fetcher.", e);
        }
        log.trace((Object)"Creating new bag to return.");
        Bag resultBag = this.bagFactory.createBag(bag);
        finalResult.setResultingBag(resultBag);
        resultBag.putBagFiles(this.newBagFiles);
        log.trace((Object)MessageFormat.format("Adding {0} files that failed to fetch to the new bag.", this.failedFetchTargets.size()));
        if (this.failedFetchTargets.size() > 0) {
            if (resultBag.getFetchTxt() == null) {
                resultBag.putBagFile(resultBag.getBagPartFactory().createFetchTxt());
            }
            resultBag.getFetchTxt().clear();
            for (FetchTarget failedTarget : this.failedFetchTargets) {
                resultBag.getFetchTxt().addAll(failedTarget.getLines());
            }
        }
        log.debug((Object)MessageFormat.format("Fetch completed with result: {0}", finalResult.isSuccess()));
        return finalResult;
    }

    private void checkBagSanity() throws BagTransferException {
        log.debug((Object)"Checking sanity of bag prior to fetch.");
        SimpleResult verifyResult = this.bagToFetch.verify(new ValidHoleyBagVerifier());
        if (!verifyResult.isSuccess()) {
            throw new BagTransferException(MessageFormat.format("Bag is not valid: {0}", verifyResult.toString()));
        }
    }

    private void buildFetchTargets(boolean resume) {
        SimpleResult bagVerifyResult = null;
        if (resume) {
            bagVerifyResult = this.bagToFetch.verifyValid(FailModeSupporting.FailMode.FAIL_SLOW);
        }
        log.trace((Object)"Sorting fetch lines by file name.");
        ArrayList<FetchTxt.FilenameSizeUrl> sortedFetchLines = new ArrayList<FetchTxt.FilenameSizeUrl>(this.bagToFetch.getFetchTxt());
        Collections.sort(sortedFetchLines, new FetchFilenameSorter());
        this.fetchTargets = new ArrayList<FetchTarget>(sortedFetchLines.size());
        log.trace((Object)"Converting fetch lines into fetch targets.");
        FetchTarget currentTarget = null;
        for (FetchTxt.FilenameSizeUrl line : sortedFetchLines) {
            if (resume && BagHelper.isPayload(line.getFilename(), this.bagFactory.getBagConstants()) && !SimpleResultHelper.isMissingOrInvalid(bagVerifyResult, line.getFilename())) continue;
            if (currentTarget == null || !currentTarget.getFilename().equals(line.getFilename())) {
                currentTarget = new FetchTarget(line, new FetchTxt.FilenameSizeUrl[0]);
                this.fetchTargets.add(currentTarget);
                continue;
            }
            currentTarget.addLine(line);
        }
        log.trace((Object)MessageFormat.format("Sorting fetch target list with {0} items by size.", this.fetchTargets.size()));
        Collections.sort(this.fetchTargets, new Comparator<FetchTarget>(){

            @Override
            public int compare(FetchTarget left, FetchTarget right) {
                Long leftSize = left.getSize();
                Long rightSize = right.getSize();
                int result = leftSize == null ? (rightSize == null ? 0 : -1) : (rightSize == null ? 1 : leftSize.compareTo(rightSize));
                return result;
            }
        });
        log.trace((Object)"Sort complete.");
    }

    private FetchTarget getNextFetchTarget() {
        FetchTarget nextItem;
        int size;
        int next = this.nextFetchTargetIndex.getAndIncrement();
        if (next < (size = this.fetchTargets.size())) {
            nextItem = this.fetchTargets.get(next);
            log.trace((Object)MessageFormat.format("Fetching {0}/{1}: {2}", next + 1, size, nextItem.getFilename()));
            this.progress("starting fetch", nextItem.getFilename(), (long)next + 1L, Long.valueOf(size));
        } else {
            nextItem = null;
            log.trace((Object)"Nothing left to fetch.  Returning null.");
        }
        return nextItem;
    }

    private FileFetcher newFileFetcher(URI uri, Long size) throws BagTransferException {
        String scheme = uri.getScheme();
        log.trace((Object)MessageFormat.format("Getting fetcher for scheme: {0}", scheme));
        FetchProtocol factory = this.protocolFactories.get(scheme);
        if (factory == null) {
            throw new BagTransferException(MessageFormat.format("No registered factory for URI: {0}", uri));
        }
        return factory.createFetcher(uri, size);
    }

    private URI parseUri(String uriString) throws BagTransferException {
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            String msg = MessageFormat.format("Invalid target URL: {0}", uriString);
            log.error((Object)msg, (Throwable)e);
            throw new BagTransferException(msg, e);
        }
    }

    public SimpleResult fetchRemoteBag(File destFile, String url, boolean resume) throws BagTransferException {
        FileSystemFileDestination dest;
        BagFetchResult fetchResult;
        Bag partialBag;
        SimpleResult bagItResult;
        this.newBagFiles = Collections.synchronizedList(new ArrayList());
        this.destinationFactory = new FileSystemFileDestination(destFile);
        log.info((Object)"Making local holey bag from remote bag");
        this.baseUrl = url;
        if (!this.baseUrl.endsWith("/")) {
            this.baseUrl = this.baseUrl + "/";
        }
        if (!(bagItResult = this.fetchFile(this.baseUrl, this.bagFactory.getBagConstants().getBagItTxt())).isSuccess()) {
            log.info((Object)"Failed: BagIt.txt file does not exist on remote bag");
            return bagItResult;
        }
        String bagItTxtFilepath = this.destinationFactory.createDestination(this.bagFactory.getBagConstants().getBagItTxt(), null).getDirectAccessPath();
        BagItTxt bagItTxt = this.bagFactory.getBagPartFactory().createBagItTxt(new FileBagFile(this.bagFactory.getBagConstants().getBagItTxt(), new File(bagItTxtFilepath)));
        Bag.BagConstants bagConstants = this.bagFactory.getBagConstants(BagFactory.Version.valueOfString(bagItTxt.getVersion()));
        this.fetchManifestFiles(this.baseUrl, bagConstants);
        if (!resume) {
            this.fetchFile(this.baseUrl, bagConstants.getFetchTxt());
        }
        if ((partialBag = this.bagFactory.createBag(destFile, BagFactory.LoadOption.BY_MANIFESTS)).getFetchTxt() == null && partialBag.getPayloadManifests().isEmpty()) {
            return new SimpleResult(false, "Neither fetch.txt or payload manifest found");
        }
        for (Manifest manifest : partialBag.getTagManifests()) {
            this.fetchFromManifest(manifest, partialBag.getBagConstants());
        }
        this.fetchFile(this.baseUrl, bagConstants.getBagInfoTxt());
        if (partialBag.getFetchTxt() == null) {
            Bag holeyBag = partialBag.makeHoley(this.baseUrl, true, false, false);
            holeyBag.write(new FileSystemWriter(this.bagFactory), destFile);
        }
        if (!(fetchResult = this.fetch(partialBag, dest = new FileSystemFileDestination(destFile), resume)).isSuccess()) {
            return fetchResult;
        }
        return new SimpleResult(true);
    }

    protected SimpleResult fetchFromManifest(Manifest manifest, Bag.BagConstants bagConstants) throws BagTransferException {
        SimpleResult result = new SimpleResult(true);
        for (String filepath : manifest.keySet()) {
            result = this.fetchFile(this.baseUrl, filepath);
            if (result.isSuccess()) continue;
            this.fail("File {0} in manifest {1} missing from bag.", filepath, manifest.getFilepath());
            return result;
        }
        return result;
    }

    private void fail(String format, Object ... args) {
        this.fail(MessageFormat.format(format, args));
    }

    private void fail(String message) {
        log.trace((Object)message);
    }

    private SimpleResult fetchFile(String url, String filename) {
        SimpleResult result = new SimpleResult(true);
        Fetcher fetcher = new Fetcher();
        url = url + filename;
        FetchTxt.FilenameSizeUrl filenNameSizeUrl = new FetchTxt.FilenameSizeUrl(filename, null, url);
        try {
            fetcher.fetchSingleLine(filenNameSizeUrl);
        }
        catch (BagTransferCancelledException bte) {
            log.trace((Object)MessageFormat.format("File {0} does not exist in the remote bag", filename));
            result.setSuccess(false);
        }
        catch (BagTransferException bte) {
            log.trace((Object)MessageFormat.format("File {0} does not exist in the remote bag", filename));
            result.setSuccess(false);
        }
        return result;
    }

    private void fetchManifestFiles(String url, Bag.BagConstants bagConstants) throws BagTransferException {
        FetchTxt.FilenameSizeUrl filenNameSizeUrl;
        String filename;
        Fetcher fetcher = new Fetcher();
        for (Manifest.Algorithm algorithm : Manifest.Algorithm.values()) {
            filename = ManifestHelper.getTagManifestFilename(algorithm, bagConstants);
            filenNameSizeUrl = new FetchTxt.FilenameSizeUrl(filename, null, url + filename);
            try {
                fetcher.fetchSingleLine(filenNameSizeUrl);
            }
            catch (BagTransferCancelledException bte) {
                log.trace((Object)MessageFormat.format("Manifest file {0} does not exist in the remote bag", filename));
            }
            catch (BagTransferException bte) {
                log.trace((Object)MessageFormat.format("Manifest file {0} does not exist in the remote bag", filename));
            }
        }
        for (Manifest.Algorithm algorithm : Manifest.Algorithm.values()) {
            filename = ManifestHelper.getPayloadManifestFilename(algorithm, bagConstants);
            filenNameSizeUrl = new FetchTxt.FilenameSizeUrl(filename, null, url + filename);
            try {
                fetcher.fetchSingleLine(filenNameSizeUrl);
            }
            catch (BagTransferCancelledException bte) {
                log.trace((Object)MessageFormat.format("Manifest file {0} does not exist in the remote bag", filename));
            }
            catch (BagTransferException bte) {
                log.trace((Object)MessageFormat.format("Manifest file {0} does not exist in the remote bag", filename));
            }
        }
    }

    private class BagFetcherShutdownHook
    extends Thread {
        private CountDownLatch shutdownLatch;

        private BagFetcherShutdownHook() {
        }

        public synchronized void hook() {
            this.shutdownLatch = new CountDownLatch(1);
            Runtime.getRuntime().addShutdownHook(this);
        }

        public synchronized void unhook() {
            this.shutdownLatch.countDown();
            try {
                Runtime.getRuntime().removeShutdownHook(this);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            BagFetcher.this.cancel();
            try {
                this.shutdownLatch.await(7L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.error((Object)"Timed out while waiting for fetch shutdown to finish.");
            }
        }
    }

    private class MyContext
    implements FetchContext {
        private MyContext() {
        }

        @Override
        public boolean requiresLogin() {
            return false;
        }

        @Override
        public PasswordAuthentication getCredentials() {
            return null;
        }
    }

    private class Fetcher
    implements Callable<SimpleResult> {
        private SimpleResult result = new SimpleResult(true);
        private Map<String, FileFetcher> fetchers = new HashMap<String, FileFetcher>();

        private Fetcher() {
        }

        public synchronized void cancel() {
            for (FileFetcher fetcher : this.fetchers.values()) {
                if (fetcher.isCancelled()) continue;
                fetcher.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SimpleResult call() {
            log.trace((Object)"Internal fetcher started.");
            try {
                FetchTarget fetchTarget = BagFetcher.this.getNextFetchTarget();
                while (fetchTarget != null && !BagFetcher.this.isCancelled()) {
                    try {
                        this.fetchSingleTarget(fetchTarget);
                        fetchTarget = BagFetcher.this.getNextFetchTarget();
                    }
                    catch (BagTransferCancelledException e) {
                        log.info((Object)"Transfer cancelled.");
                        this.result.addMessage("Transfer cancelled.");
                        this.result.setSuccess(false);
                        break;
                    }
                    catch (BagTransferException e) {
                        FetchFailureAction failureAction = BagFetcher.this.failStrategy.registerFailure(fetchTarget, e);
                        log.trace((Object)MessageFormat.format("Failure action for {0} (size: {1}): {2} ", new Object[]{fetchTarget.getFilename(), fetchTarget.getSize(), failureAction}));
                        if (failureAction == FetchFailureAction.RETRY_CURRENT) continue;
                        if (failureAction == FetchFailureAction.CONTINUE_WITH_NEXT) {
                            BagFetcher.this.failedFetchTargets.add(fetchTarget);
                            this.result.addMessage(MessageFormat.format("An error occurred while fetching target: {0}", fetchTarget.getFilename()));
                            this.result.setSuccess(false);
                            fetchTarget = BagFetcher.this.getNextFetchTarget();
                            continue;
                        }
                        BagFetcher.this.cancel();
                        BagFetcher.this.failedFetchTargets.add(fetchTarget);
                        this.result.addMessage(MessageFormat.format("An error occurred while fetching target: {0}", fetchTarget.getFilename()));
                        this.result.setSuccess(false);
                        break;
                    }
                }
            }
            finally {
                this.closeFetchers();
            }
            return this.result;
        }

        private void fetchSingleTarget(FetchTarget target) throws BagTransferException {
            List<FetchTxt.FilenameSizeUrl> lines = target.getLines();
            if (lines.size() == 1) {
                FetchTxt.FilenameSizeUrl line = lines.get(0);
                log.debug((Object)MessageFormat.format("Fetching single line: {0}", line));
                this.fetchSingleLine(line);
            } else {
                for (int i = 0; i < lines.size() && !BagFetcher.this.isCancelled(); ++i) {
                    try {
                        FetchTxt.FilenameSizeUrl line = lines.get(i);
                        this.fetchSingleLine(line);
                        break;
                    }
                    catch (BagTransferCancelledException e) {
                        BagFetcher.this.failedFetchTargets.add(target);
                        throw new BagTransferCancelledException(e);
                    }
                    catch (BagTransferException e) {
                        if (i + 1 < lines.size()) continue;
                        BagFetcher.this.failedFetchTargets.add(target);
                        throw new BagTransferException(e);
                    }
                }
            }
        }

        private void fetchSingleLine(FetchTxt.FilenameSizeUrl fetchLine) throws BagTransferException {
            FetchedFileDestination destination = null;
            try {
                URI uri = BagFetcher.this.parseUri(fetchLine.getUrl());
                Long size = fetchLine.getSize();
                String destinationPath = fetchLine.getFilename();
                log.trace((Object)MessageFormat.format("Creating destination: {0}", destinationPath));
                destination = BagFetcher.this.destinationFactory.createDestination(destinationPath, size);
                FileFetcher fetcher = this.getFetcher(uri, size);
                log.trace((Object)MessageFormat.format("Fetching: {0} {1} {2}", uri, size == null ? "-" : size, destinationPath));
                fetcher.fetchFile(uri, size, destination, new MyContext());
                log.trace((Object)"Committing destination.");
                BagFile committedFile = destination.commit();
                BagFetcher.this.newBagFiles.add(committedFile);
                log.trace((Object)MessageFormat.format("Fetched: {0} -> {1}", uri, destinationPath));
            }
            catch (BagTransferCancelledException e) {
                throw new BagTransferCancelledException(e);
            }
            catch (BagTransferException e) {
                String msg = MessageFormat.format("An error occurred while fetching target: {0}", fetchLine);
                log.warn((Object)msg, (Throwable)e);
                if (destination != null) {
                    destination.abandon();
                    destination = null;
                }
                throw new BagTransferException(e);
            }
        }

        private synchronized FileFetcher getFetcher(URI uri, Long size) throws BagTransferException {
            FileFetcher fetcher = this.fetchers.get(uri.getScheme());
            if (fetcher == null) {
                log.trace((Object)MessageFormat.format("Creating new FileFetcher for scheme: {0}", uri.getScheme()));
                fetcher = BagFetcher.this.newFileFetcher(uri, size);
                log.trace((Object)"Initializing new FileFetcher.");
                fetcher.initialize();
                this.fetchers.put(uri.getScheme(), fetcher);
            }
            if (BagFetcher.this.username != null && BagFetcher.this.password != null) {
                fetcher.setUsername(BagFetcher.this.username);
                fetcher.setPassword(BagFetcher.this.password);
            }
            return fetcher;
        }

        private synchronized void closeFetchers() {
            for (FileFetcher fetcher : this.fetchers.values()) {
                fetcher.close();
            }
            this.fetchers.clear();
        }
    }
}

