<?xml version="1.0"?>
<!--
*  '$RCSfile: resultset.xsl,v $'
*      Authors: Matt Jones, Chad Berkley
*    Copyright: 2000 Regents of the University of California and the
*         National Center for Ecological Analysis and Synthesis
*  For Details: http://www.nceas.ucsb.edu/
*
*   '$Author: cjones $'
*     '$Date: 2004/10/05 23:50:46 $'
* '$Revision: 1.1 $'
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
* This is an XSLT (http://www.w3.org/TR/xslt) stylesheet designed to
* convert an XML file showing the resultset of a query
* into an HTML format suitable for rendering with modern web browsers.
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:param name="cgi-prefix"/>
  <xsl:param name="contextURL"/>
  <!-- This parameter gets overidden by the chosen default qformat -->
  <xsl:param name="qformat">default</xsl:param>
  <xsl:param name="servletURL"/>

  <!-- import the header, footer, and sidebars for customized styling -->
  <xsl:import href="{$contextURL}/style/skins/sbclter/templates/xsl/pageheader.xsl"/>
  <xsl:import href="{$contextURL}/style/skins/sbclter/templates/xsl/pagefooter.xsl"/>
  <xsl:import href="{$contextURL}/style/skins/sbclter/templates/xsl/page_leftsidebar.xsl"/>
  <xsl:import href="{$contextURL}/style/skins/sbclter/templates/xsl/page_rightsidebar.xsl"/>
  <xsl:import href="{$contextURL}/style/skins/sbclter/templates/xsl/loginbox.xsl"/>
  <xsl:import href="{$contextURL}/style/skins/sbclter/templates/xsl/searchbox.xsl"/>

  <!-- send the resultset back to the browser styled in HTML -->
  <xsl:output method="html" encoding="iso-8859-1" indent="yes" standalone="yes"
    doctype-public="-//W3C//DTD XHTML 1.0 Transitional//EN"
    doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd" />

  <xsl:param name="sessid"/>
  <xsl:param name="enableediting">false</xsl:param>
  <!-- This parameter gets overidden by the chosen default qformat -->
  <xsl:param name="qformat">default</xsl:param>

  <!-- The main template matches the XML document root -->
  <xsl:template match="/">
   <html>
      <head>
        <link rel="stylesheet" type="text/css" 
              href="{$contextURL}/style/skins/sbclter/sbclter.css" />
        <script language="Javascript" type="text/JavaScript"
          src="{$contextURL}/style/skins/sbclter/sbclter.js" />
        <script language="Javascript" type="text/JavaScript"
          src="{$contextURL}/style/common/branding.js" />
					
        <script language="JavaScript">
          <![CDATA[
          function submitform(action,form_ref) {
              form_ref.action.value=action;
              form_ref.sessionid.value="]]><xsl:value-of select="$sessid" /><![CDATA[";
              form_ref.qformat.value="sbclter";
              form_ref.submit();
          }
          ]]>
        </script>
      </head>

      <body>
        <!-- begin the header area -->
        <xsl:call-template name="pageheader" />
        <!-- end the header area -->
   
        <!-- begin the left sidebar area -->
        <xsl:call-template name="page_leftsidebar" />
        <!-- end the left sidebar area -->
   
        <!-- begin the content area -->
        <div id="content">

          <!-- begin login form area -->
          <xsl:call-template name="loginbox" />
          <!-- end login form area -->

          <!-- begin search form area -->
          <xsl:call-template name="searchbox" />
          <!-- end search form area --> 
         

          <!-- begin results section (XSLT generated) -->
          <div id="data-catalog-area">

          <!-- State how many package hits were returned -->
          <xsl:choose>
            <xsl:when test="count(resultset/document)=1">
              <p>
              <xsl:number value="count(resultset/document)" /> data package found:
              </p>
            </xsl:when>
            <xsl:otherwise>
              <p>
              <xsl:number value="count(resultset/document)" /> data packages found:
              </p>
            </xsl:otherwise>
          </xsl:choose>
          
          <!-- This tests to see if there are returned documents,
          if there are not then don't show the query results -->
          <xsl:if test="count(resultset/document) &gt; 0">

            <!-- create the results table, and style each of the returnfield that
            were specified in the original query -->
            <table class="group group_border">
              <tr>
    

              <!-- create links to each of the associated raw data entities -->
                <td>
                <xsl:attribute name="class">
                  <xsl:choose>
                    <xsl:when test="position() mod 2 = 1">rowodd</xsl:when>
                    <xsl:when test="position() mod 2 = 0">roweven</xsl:when>
                  </xsl:choose>
                </xsl:attribute>
                <!-- take each entity name and link it to the physical object url-->
		<xsl:for-each select="./param[@name='dataTable/entityName']">
                  <a>
                  <xsl:variable name="URL"
                    select="following-sibling::param[@name='dataTable/physical/distribution/online/url']" />

                    <xsl:choose>
                      <!-- if contents is a url to external data table -->
                      <xsl:when test="starts-with($URL,'http')">
                        <xsl:attribute name="href"><xsl:value-of select="$URL"/></xsl:attribute>
                      </xsl:when>

                      <!-- strip out the ecogrid:// syntax if it's there, and the rest is in metacat -->
                      <xsl:when test="starts-with($URL,'ecogrid')">
                        <xsl:variable name="URL1" select="substring-after($URL, 'ecogrid://')"/>
                        <xsl:variable name="docID" select="substring-after($URL1, '/')"/>
                        <xsl:attribute name="href">
                          <!-- this needs to be on one line ... -->
                          <xsl:text>{$servletURL}?action=read&amp;qformat=sbclter&amp;docid=</xsl:text><xsl:value-of select="$docID"/>
                        </xsl:attribute>
                      </xsl:when>
                      
                      <!-- otherwise, assume the url field names a metacat table -->
                      <xsl:otherwise>
                        <xsl:attribute name="href">
                          <!-- this needs to be on one line -->
                          <xsl:text>{$servletURL}?action=read&amp;qformat=sbclter&amp;docid=</xsl:text><xsl:value-of select="$URL"/>
                        </xsl:attribute>
                      </xsl:otherwise>
                    </xsl:choose>

                  <!-- show the entityName value as the link -->
                  <xsl:value-of select="." />
                  </a>
                  <br />
                  </xsl:for-each>
                </td>
              
                <xsl:if test="$enableediting = 'true'">
                <td>
                <xsl:attribute name="class">
                  <xsl:choose>
                    <xsl:when test="position() mod 2 = 1">rowodd</xsl:when>
                    <xsl:when test="position() mod 2 = 0">roweven</xsl:when>
                  </xsl:choose>
                </xsl:attribute>
          
                  <form action="{$servletURL}" method="POST">
                    <input type="hidden" name="action" value="read"/>
               <input type="hidden" name="qformat" value="sbclter"/>
                 <input type="hidden" name="sessionid"  value="{$sessid}"/>
                    <input type="hidden" name="docid">
                    <xsl:attribute name="value">
                 <xsl:value-of select="./docid"/>
                    </xsl:attribute>
                    </input>
                    <center>
                    <input type="SUBMIT"  value=" View " name="View">
               </input>
                    </center>
                  </form>
              <form action="{$cgi-prefix}/register-dataset.cgi" 
                    method="POST">
                    <input type="hidden" name="stage" value="modify"/>  
                   <input type="hidden" name="cfg" value="sbclter"/>
                   <input type="hidden" name="sessionid"  value="{$sessid}"/>
                <input type="hidden" name="docid">
                  <xsl:attribute name="value">
                    <xsl:value-of select="./docid"/>
                  </xsl:attribute>
                </input>
                    <input type="SUBMIT"  value=" Edit " name="Edit">
                 </input>
                  </form>
              <form action="{$cgi-prefix}/register-dataset.cgi" 
                    method="POST">
                    <input type="hidden" name="stage" value="delete"/>  
                   <input type="hidden" name="cfg" value="sbclter"/>
                   <input type="hidden" name="sessionid"  value="{$sessid}"/>
                <input type="hidden" name="docid">
                  <xsl:attribute name="value">
                    <xsl:value-of select="./docid"/>
                  </xsl:attribute>
                </input>
                    <input type="submit"  value="Delete" name="Delete">
                 </input>
                  </form>
                </td>    
                </xsl:if>
                </tr>
             </xsl:for-each>
             </table>
           </xsl:if>

         </div>  <!-- end data-catalog-area -->
        </div>
        <!-- end content area -->

        <!-- begin the right sidebar area -->
        <xsl:call-template name="page_rightsidebar" />
        <!-- end the right sidebar area -->

        <!-- begin the footer area -->
        <xsl:call-template name="pagefooter" />
        <!-- end the footer area -->

      </body>
    </html>
  </xsl:template>

</xsl:stylesheet>
