/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.ecogrid;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.StringReader;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EcogridUtils {
    private static boolean _printAll = false;
    private static boolean _debugOn = false;
    private static int _level = 100;

    public static void setDebug(boolean bl) {
        _debugOn = bl;
    }

    public static void setLevel(int n) {
        _level = n;
    }

    public static boolean isDebugOn() {
        return _debugOn;
    }

    public static void debugMessage(String string, int n) {
        if (_debugOn) {
            if (n < 0) {
                n = 0;
            }
            if (n <= _level) {
                System.err.println("EcogridUtils: " + string);
            }
        }
    }

    public static void debugMessage(String string) {
        EcogridUtils.debugMessage(string, 1);
    }

    public static void setPrintAll(boolean bl) {
        _printAll = bl;
    }

    public static String getNodeTypeStr(int n) {
        String string = "N/A";
        switch (n) {
            case 2: {
                string = "The node is an Attr.";
                break;
            }
            case 4: {
                string = "The node is a CDATASection.";
                break;
            }
            case 8: {
                string = "The node is a Comment.";
                break;
            }
            case 11: {
                string = "The node is a DocumentFragment.";
                break;
            }
            case 9: {
                string = "The node is a Document.";
                break;
            }
            case 10: {
                string = "The node is a DocumentType.";
                break;
            }
            case 1: {
                string = "The node is an Element.";
                break;
            }
            case 6: {
                string = "The node is an Entity.";
                break;
            }
            case 5: {
                string = "The node is an EntityReference.";
                break;
            }
            case 12: {
                string = "The node is a Notation.";
                break;
            }
            case 7: {
                string = "The node is a ProcessingInstruction.";
                break;
            }
            case 3: {
                string = "The node is a Text node.";
            }
        }
        return string;
    }

    public static String getNodeValue(Node node) {
        String string = null;
        if (node.getNodeValue() != null) {
            string = node.getNodeValue() != null ? node.getNodeValue().trim() : null;
        } else {
            Node node2;
            NodeList nodeList = node.getChildNodes();
            if (nodeList.getLength() == 1 && (node2 = nodeList.item(0)) != null) {
                string = node2.getNodeValue() != null ? node2.getNodeValue().trim() : null;
            }
        }
        return string;
    }

    public static Node findNode(Node node, String string) {
        String string2;
        String string3 = string2 = node.getNodeName() != null ? node.getNodeName().trim() : "";
        if (string.equalsIgnoreCase(string2)) {
            return node;
        }
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2;
                Node node3 = nodeList.item(i);
                if (node3 == null || (node2 = EcogridUtils.findNode(node3, string)) == null) continue;
                return node2;
            }
        }
        return null;
    }

    protected static Node findNodeWithXPath(Node node, Vector vector, int n) {
        if (n == vector.size()) {
            return null;
        }
        String string = (String)vector.elementAt(n);
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string2;
                Node node2 = nodeList.item(i);
                if (node2 == null || !string.equals(string2 = node2.getNodeName())) continue;
                if (n == vector.size() - 1) {
                    return node2;
                }
                Node node3 = EcogridUtils.findNodeWithXPath(node2, vector, n + 1);
                if (node3 == null) continue;
                return node3;
            }
        }
        return null;
    }

    public static Node findNodeWithXPath(Node node, String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        int n = 0;
        return EcogridUtils.findNodeWithXPath(node, vector, n);
    }

    public static String findNodeValue(Node node, String string) {
        String string2 = null;
        Node node2 = EcogridUtils.findNode(node, string);
        if (node2 != null) {
            string2 = EcogridUtils.getNodeValue(node2);
        }
        return string2;
    }

    public static String findAttrValueForNode(Node node, String string, String string2) {
        Node node2;
        NamedNodeMap namedNodeMap;
        String string3 = null;
        Node node3 = EcogridUtils.findNode(node, string);
        if (node3 != null && (namedNodeMap = node3.getAttributes()) != null && (node2 = namedNodeMap.getNamedItem(string2)) != null) {
            string3 = EcogridUtils.getNodeValue(node2);
        }
        return string3;
    }

    public static String findAttrValue(Node node, String string) {
        Node node2;
        NamedNodeMap namedNodeMap;
        String string2 = null;
        if (node != null && (namedNodeMap = node.getAttributes()) != null && (node2 = namedNodeMap.getNamedItem(string)) != null) {
            string2 = EcogridUtils.getNodeValue(node2);
        }
        return string2;
    }

    public static void printNode(Node node, int n) {
        if (node == null) {
            return;
        }
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "..";
        }
        System.out.println(string + "Name:  " + node.getNodeName());
        System.out.println(string + "Type:  " + node.getNodeType());
        System.out.println(string + "Value: [" + node.getNodeValue() + "]");
        NodeList nodeList = node.getChildNodes();
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                EcogridUtils.printNode(node2, n + 1);
            }
        }
    }

    public static String readXMLFile2Str(String string) {
        try {
            String string2 = "";
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                string2 = string2 + string3 + "\n";
                string3 = bufferedReader.readLine();
            }
            return string2;
        }
        catch (Exception exception) {
            System.err.println("readXMLFile2Str - Exception: " + exception);
            return null;
        }
    }

    public static Document readXMLFile2DOM(String string) {
        FileInputStream fileInputStream;
        if (string == null) {
            System.err.println("*** EcogridUtils readXMLFile2DOM file name is null!");
            return null;
        }
        if (string.length() == 0) {
            System.err.println("*** EcogridUtils readXMLFile2DOM file name is null!");
            return null;
        }
        File file = new File(string);
        if (file == null || !file.exists() || file.length() == 0L) {
            System.err.println("*** EcogridUtils readXMLFile2DOM - file " + string + " does not exist or is zero length!");
            return null;
        }
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("*** EcogridUtils readXMLFile2DOM - file " + string + " does not exist!");
            return null;
        }
        return EcogridUtils.convertXMLStr2DOM(new InputSource(fileInputStream));
    }

    public static Document convertXMLStr2DOM(InputSource inputSource) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            if (transformerFactory.getFeature("http://javax.xml.transform.dom.DOMSource/feature") && transformerFactory.getFeature("http://javax.xml.transform.dom.DOMResult/feature")) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(inputSource);
                return document;
            }
        }
        catch (Exception exception) {
            System.err.println("convertXMLStr2DOM - Exception: " + exception);
            exception.printStackTrace();
        }
        return null;
    }

    public static Document convertXMLStr2DOM(String string) {
        StringReader stringReader = new StringReader(string);
        InputSource inputSource = new InputSource(stringReader);
        return EcogridUtils.convertXMLStr2DOM(inputSource);
    }

    public static boolean writeXMLToFile(String string, Document document) {
        return false;
    }

    public static boolean compareDOMs(Node node, Node node2, int n, boolean bl) {
        Object object;
        Node node3;
        int n2;
        String string;
        String string2;
        int n3;
        String string3 = "";
        if (bl) {
            for (n3 = 0; n3 < n; ++n3) {
                string3 = string3 + "..";
            }
        }
        n3 = 1;
        NodeList nodeList = node.getChildNodes();
        NodeList nodeList2 = node2.getChildNodes();
        String string4 = node.getNodeName() != null ? node.getNodeName().trim() : "";
        String string5 = string2 = node2.getNodeName() != null ? node2.getNodeName().trim() : "";
        if (!string4.equalsIgnoreCase(string2)) {
            System.out.println(string3 + "NodeName not equal [" + string4 + "][" + string2 + "]");
            n3 = 0;
        } else if (bl) {
            System.out.println(string3 + "NodeName:  " + string4);
        }
        if (node.getNodeType() != node2.getNodeType()) {
            System.out.println(string3 + "NodeType not equal [" + EcogridUtils.getNodeTypeStr(node.getNodeType()) + "][" + EcogridUtils.getNodeTypeStr(node2.getNodeType()) + "]");
            n3 = 0;
        } else if (bl) {
            System.out.println(string3 + "NodeType:  " + EcogridUtils.getNodeTypeStr(node.getNodeType()));
        }
        String string6 = node.getNodeValue() != null ? node.getNodeValue().trim() : "";
        String string7 = node2.getNodeValue() != null ? node2.getNodeValue().trim() : "";
        String string8 = "--skip--";
        if (!(string6.equalsIgnoreCase(string7) || string6.equalsIgnoreCase(string8) || string7.equalsIgnoreCase(string8))) {
            System.out.println(string3 + "NodeValue not equal [" + string6 + "][" + string7 + "]");
            n3 = 0;
        } else if (bl) {
            System.out.println(string3 + "NodeValue:  " + string6);
        }
        String string9 = node.getNamespaceURI() != null ? node.getNamespaceURI().trim() : "";
        String string10 = string = node2.getNamespaceURI() != null ? node2.getNamespaceURI().trim() : "";
        if (!string9.equalsIgnoreCase(string)) {
            System.out.println(string3 + "NamespaceURI not equal [" + string9 + "][" + string + "]");
            n3 = 0;
        } else if (bl) {
            System.out.println(string3 + "NamespaceURI:  " + string9);
        }
        if (nodeList.getLength() != nodeList2.getLength()) {
            System.out.println(string3 + "Num Children not equal [" + nodeList.getLength() + "][" + nodeList2.getLength() + "]");
            System.out.println(string3 + "-----------------------------");
            System.out.println(string3 + "Node1:");
            for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
                node3 = nodeList.item(n2);
                object = node3.getNodeValue() != null ? node3.getNodeValue().trim() : "";
                System.out.println(string3 + "..");
                System.out.println(string3 + "..Name:  " + node3.getNodeName());
                System.out.println(string3 + "..Type:  " + node3.getNodeType());
                System.out.println(string3 + "..Value: [" + (String)object + "]");
            }
            System.out.println(string3 + "-----------------------------");
            System.out.println(string3 + "Node2:");
            for (n2 = 0; n2 < nodeList2.getLength(); ++n2) {
                node3 = nodeList2.item(n2);
                object = node3.getNodeValue() != null ? node3.getNodeValue().trim() : "";
                System.out.println(string3 + "..");
                System.out.println(string3 + "..Name:  " + node3.getNodeName());
                System.out.println(string3 + "..Type:  " + node3.getNodeType());
                System.out.println(string3 + "..Value: [" + (String)object + "]");
            }
            System.out.println(string3 + "-----------------------------");
            n3 = 0;
        } else if (bl) {
            System.out.println(string3 + "Num Children: " + nodeList.getLength());
        }
        if (n3 == 0) {
            return false;
        }
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            node3 = nodeList.item(n2);
            if (EcogridUtils.compareDOMs(node3, (Node)(object = nodeList2.item(n2)), n + 1, _printAll)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareDOMs(String string, String string2) {
        Document document = EcogridUtils.readXMLFile2DOM(string);
        if (document == null) {
            System.out.println("Error - Couldn't find xml file: " + string);
            return false;
        }
        Document document2 = EcogridUtils.readXMLFile2DOM(string2);
        if (document2 == null) {
            System.out.println("Error - Couldn't find xml file: " + string2);
            return false;
        }
        return EcogridUtils.compareDOMs(document, document2, 0, _printAll);
    }

    public static final String escapeHTML(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static Calendar getCalendarDate(String string) {
        Calendar calendar = Calendar.getInstance();
        if (string != null && string.length() > 18) {
            try {
                int n;
                int n2;
                int n3;
                if (string.charAt(2) == '-') {
                    n3 = Integer.valueOf(string.substring(6, 10));
                    n2 = Integer.valueOf(string.substring(3, 5));
                    n = Integer.valueOf(string.substring(0, 2));
                } else {
                    n3 = Integer.valueOf(string.substring(0, 4));
                    n2 = Integer.valueOf(string.substring(5, 7));
                    n = Integer.valueOf(string.substring(8, 10));
                }
                int n4 = Integer.valueOf(string.substring(11, 13));
                int n5 = Integer.valueOf(string.substring(14, 16));
                int n6 = Integer.valueOf(string.substring(17, 19));
                calendar.set(n3, n2 - 1, n, n4, n5, n6);
                EcogridUtils.debugMessage("********* " + n3 + "/" + n2 + "/" + n + " " + n4 + ":" + n5 + ":" + n6);
            }
            catch (Exception exception) {
                calendar.setTime(new Date());
            }
        } else {
            calendar.setTime(new Date());
        }
        return calendar;
    }

    public static void parseForNameAndNamespace(String string, StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        stringBuffer.setLength(0);
        stringBuffer2.setLength(0);
        if (string != null) {
            int n = string.indexOf(58);
            if (n != -1) {
                stringBuffer.append(string.substring(n + 1, string.length()));
                stringBuffer2.append(string.substring(0, n));
            } else {
                stringBuffer.append(string);
            }
        }
    }

    public static boolean isaFcatoryServiceByEnv() {
        String string = System.getProperty("FACTORY");
        if (string == null) {
            return true;
        }
        return string.compareToIgnoreCase("no") != 0;
    }

    public static boolean printStackTraceByEnv() {
        String string = System.getProperty("PRINT_STACK_TRACE");
        if (string == null) {
            return false;
        }
        return string.compareToIgnoreCase("yes") == 0;
    }
}

