/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.download;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.ecoinformatics.datamanager.download.CompressedDataHandler;
import org.ecoinformatics.datamanager.download.EcogridEndPointInterface;
import org.ecoinformatics.datamanager.parser.Entity;

public class GZipDataHandler
extends CompressedDataHandler {
    protected GZipDataHandler(Entity entity, String url, EcogridEndPointInterface endPoint) {
        super(entity, url, endPoint);
    }

    protected GZipDataHandler(String url, EcogridEndPointInterface endPoint) {
        super(url, endPoint);
    }

    public static GZipDataHandler getGZipHandlerInstance(Entity entity, String url, EcogridEndPointInterface endPoint) {
        GZipDataHandler gzipHandler = (GZipDataHandler)GZipDataHandler.getHandlerFromHash(url);
        if (gzipHandler == null) {
            gzipHandler = new GZipDataHandler(entity, url, endPoint);
        }
        return gzipHandler;
    }

    @Override
    protected boolean writeRemoteInputStreamIntoDataStorage(InputStream in) throws IOException {
        boolean success = false;
        GZIPInputStream gzipInputStream = null;
        if (in == null) {
            return success;
        }
        try {
            gzipInputStream = new GZIPInputStream(in);
            success = super.writeRemoteInputStreamIntoDataStorage(gzipInputStream);
        }
        catch (IOException e) {
            String errorMsg = String.format("%s %s: %s", "Error reading from the data source.", "Error downloading gzip file", e.getMessage());
            throw new IOException(errorMsg);
        }
        return success;
    }

    @Override
    protected boolean getContentFromEcoGridSource(String endPoint, String ecogridIdentifier) {
        boolean success = false;
        File gzipTmp = this.writeEcoGridCompressedDataIntoTmp(endPoint, ecogridIdentifier, ".gz");
        System.out.println("The gzip file name is " + gzipTmp);
        try {
            if (gzipTmp != null) {
                FileInputStream stream = new FileInputStream(gzipTmp);
                success = this.writeRemoteInputStreamIntoDataStorage(stream);
            }
        }
        catch (Exception e) {
            System.out.println("Error is " + e.getMessage());
        }
        return success;
    }
}

