/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.hibernate4.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate4.SessionFactoryUtils;
import org.springframework.orm.hibernate4.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.WebRequestInterceptor;

public class OpenSessionInViewInterceptor
implements WebRequestInterceptor {
    public static final String PARTICIPATE_SUFFIX = ".PARTICIPATE";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private SessionFactory sessionFactory;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void preHandle(WebRequest request) throws DataAccessException {
        if (TransactionSynchronizationManager.hasResource(this.getSessionFactory())) {
            String participateAttributeName = this.getParticipateAttributeName();
            Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
            int newCount = count != null ? count + 1 : 1;
            request.setAttribute(this.getParticipateAttributeName(), (Object)newCount, 0);
        } else {
            this.logger.debug("Opening Hibernate Session in OpenSessionInViewInterceptor");
            Session session = this.openSession();
            TransactionSynchronizationManager.bindResource(this.getSessionFactory(), new SessionHolder(session));
        }
    }

    public void postHandle(WebRequest request, ModelMap model) {
    }

    public void afterCompletion(WebRequest request, Exception ex) throws DataAccessException {
        String participateAttributeName = this.getParticipateAttributeName();
        Integer count = (Integer)request.getAttribute(participateAttributeName, 0);
        if (count != null) {
            if (count > 1) {
                request.setAttribute(participateAttributeName, (Object)(count - 1), 0);
            } else {
                request.removeAttribute(participateAttributeName, 0);
            }
        } else {
            SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.unbindResource(this.getSessionFactory());
            this.logger.debug("Closing Hibernate Session in OpenSessionInViewInterceptor");
            SessionFactoryUtils.closeSession(sessionHolder.getSession());
        }
    }

    protected Session openSession() throws DataAccessResourceFailureException {
        try {
            Session session = SessionFactoryUtils.openSession(this.getSessionFactory());
            session.setFlushMode(FlushMode.MANUAL);
            return session;
        }
        catch (HibernateException ex) {
            throw new DataAccessResourceFailureException("Could not open Hibernate Session", ex);
        }
    }

    protected String getParticipateAttributeName() {
        return String.valueOf(this.getSessionFactory().toString()) + PARTICIPATE_SUFFIX;
    }
}

