/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mapping.context;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.context.DefaultPersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextEvent;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.MutablePersistentEntity;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractMappingContext<E extends MutablePersistentEntity<?, P>, P extends PersistentProperty<P>>
implements MappingContext<E, P>,
ApplicationEventPublisherAware,
InitializingBean {
    private final Map<TypeInformation<?>, E> persistentEntities = new HashMap();
    private ApplicationEventPublisher applicationEventPublisher;
    private Set<? extends Class<?>> initialEntitySet = new HashSet();
    private boolean strict = false;
    private SimpleTypeHolder simpleTypeHolder = new SimpleTypeHolder();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock read = this.lock.readLock();
    private final Lock write = this.lock.writeLock();

    @Override
    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setInitialEntitySet(Set<? extends Class<?>> initialEntitySet) {
        this.initialEntitySet = initialEntitySet;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }

    public void setSimpleTypeHolder(SimpleTypeHolder simpleTypes) {
        this.simpleTypeHolder = simpleTypes == null ? new SimpleTypeHolder() : simpleTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<E> getPersistentEntities() {
        try {
            this.read.lock();
            Set<E> set = Collections.unmodifiableSet(new HashSet<E>(this.persistentEntities.values()));
            return set;
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public E getPersistentEntity(Class<?> type) {
        Assert.notNull(type);
        return (E)this.getPersistentEntity((TypeInformation)ClassTypeInformation.from(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E getPersistentEntity(TypeInformation<?> type) {
        Assert.notNull(type);
        try {
            this.read.lock();
            MutablePersistentEntity entity = (MutablePersistentEntity)this.persistentEntities.get(type);
            if (entity != null) {
                MutablePersistentEntity mutablePersistentEntity = entity;
                return (E)mutablePersistentEntity;
            }
        }
        finally {
            this.read.unlock();
        }
        if (!this.shouldCreatePersistentEntityFor(type)) {
            return null;
        }
        if (this.strict) {
            throw new MappingException("Unknown persistent entity " + type);
        }
        return this.addPersistentEntity(type);
    }

    @Override
    public E getPersistentEntity(P persistentProperty) {
        if (persistentProperty == null) {
            return null;
        }
        TypeInformation<?> typeInfo = persistentProperty.getTypeInformation();
        return (E)this.getPersistentEntity((TypeInformation)typeInfo.getActualType());
    }

    @Override
    public PersistentPropertyPath<P> getPersistentPropertyPath(PropertyPath propertyPath) {
        ArrayList result = new ArrayList();
        PersistentEntity current = this.getPersistentEntity((TypeInformation)propertyPath.getOwningType());
        for (PropertyPath segment : propertyPath) {
            Object persistentProperty = current.getPersistentProperty(segment.getSegment());
            if (persistentProperty == null) {
                throw new IllegalArgumentException(String.format("No property %s found on %s!", segment.getSegment(), current.getName()));
            }
            result.add(persistentProperty);
            if (!segment.hasNext()) continue;
            current = this.getPersistentEntity((Class)segment.getType());
        }
        return new DefaultPersistentPropertyPath(result);
    }

    protected E addPersistentEntity(Class<?> type) {
        return this.addPersistentEntity(ClassTypeInformation.from(type));
    }

    protected E addPersistentEntity(TypeInformation<?> typeInformation) {
        MutablePersistentEntity persistentEntity = (MutablePersistentEntity)this.persistentEntities.get(typeInformation);
        if (persistentEntity != null) {
            return (E)persistentEntity;
        }
        Class<?> type = typeInformation.getType();
        try {
            this.write.lock();
            E entity = this.createPersistentEntity(typeInformation);
            this.persistentEntities.put(typeInformation, entity);
            BeanInfo info = Introspector.getBeanInfo(type);
            HashMap<String, PropertyDescriptor> descriptors = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                descriptors.put(descriptor.getName(), descriptor);
            }
            try {
                ReflectionUtils.doWithFields(type, new PersistentPropertyCreator(this, (MutablePersistentEntity)entity, descriptors), PersistentFieldFilter.INSTANCE);
                entity.verify();
            }
            catch (MappingException e) {
                this.persistentEntities.remove(typeInformation);
                throw e;
            }
            if (null != this.applicationEventPublisher) {
                this.applicationEventPublisher.publishEvent(new MappingContextEvent(this, entity));
            }
            E e = entity;
            return e;
        }
        catch (IntrospectionException e) {
            throw new MappingException(e.getMessage(), e);
        }
        finally {
            this.write.unlock();
        }
    }

    protected abstract <T> E createPersistentEntity(TypeInformation<T> var1);

    protected abstract P createPersistentProperty(Field var1, PropertyDescriptor var2, E var3, SimpleTypeHolder var4);

    @Override
    public void afterPropertiesSet() {
        this.initialize();
    }

    public void initialize() {
        for (Class<?> initialEntity : this.initialEntitySet) {
            this.addPersistentEntity(initialEntity);
        }
    }

    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> type) {
        return !this.simpleTypeHolder.isSimpleType(type.getType());
    }

    static class FieldMatch {
        private final String namePattern;
        private final String typeName;

        public FieldMatch(String namePattern, String typeName) {
            Assert.isTrue(namePattern != null || typeName != null, "Either name patter or type name must be given!");
            this.namePattern = namePattern;
            this.typeName = typeName;
        }

        public boolean matches(Field field) {
            if (this.namePattern != null && !field.getName().matches(this.namePattern)) {
                return false;
            }
            return this.typeName == null || field.getType().getName().equals(this.typeName);
        }
    }

    private static enum PersistentFieldFilter implements ReflectionUtils.FieldFilter
    {
        INSTANCE;

        private static final Iterable<FieldMatch> UNMAPPED_FIELDS;

        @Override
        public boolean matches(Field field) {
            if (Modifier.isStatic(field.getModifiers())) {
                return false;
            }
            for (FieldMatch candidate : UNMAPPED_FIELDS) {
                if (!candidate.matches(field)) continue;
                return false;
            }
            return true;
        }

        static {
            HashSet<FieldMatch> matches = new HashSet<FieldMatch>();
            matches.add(new FieldMatch("class", null));
            matches.add(new FieldMatch("this\\$.*", null));
            matches.add(new FieldMatch("metaClass", "groovy.lang.MetaClass"));
            UNMAPPED_FIELDS = Collections.unmodifiableCollection(matches);
        }
    }

    private static final class PersistentPropertyCreator
    implements ReflectionUtils.FieldCallback {
        private final E entity;
        private final Map<String, PropertyDescriptor> descriptors;
        final /* synthetic */ AbstractMappingContext this$0;

        private PersistentPropertyCreator(E entity, Map<String, PropertyDescriptor> descriptors) {
            this.this$0 = var1_1;
            this.entity = entity;
            this.descriptors = descriptors;
        }

        @Override
        public void doWith(Field field) {
            PropertyDescriptor descriptor = this.descriptors.get(field.getName());
            ReflectionUtils.makeAccessible(field);
            Object property = this.this$0.createPersistentProperty(field, descriptor, this.entity, this.this$0.simpleTypeHolder);
            if (property.isTransient()) {
                return;
            }
            this.entity.addPersistentProperty(property);
            if (property.isAssociation()) {
                this.entity.addAssociation(property.getAssociation());
            }
            if (this.entity.getType().equals(property.getRawType())) {
                return;
            }
            if (!property.isEntity()) {
                return;
            }
            for (TypeInformation<?> candidate : property.getPersistentEntityType()) {
                this.this$0.addPersistentEntity(candidate);
            }
        }
    }
}

