/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.ParameterMode;
import javax.persistence.PersistenceException;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.TypeMismatchException;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.NamedParameterDescriptor;
import org.hibernate.engine.query.spi.OrdinalParameterDescriptor;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.QueryExecutionRequestException;
import org.hibernate.internal.SQLQueryImpl;
import org.hibernate.jpa.HibernateQuery;
import org.hibernate.jpa.internal.EntityManagerMessageLogger;
import org.hibernate.jpa.internal.util.ConfigurationHelper;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;
import org.hibernate.jpa.spi.AbstractEntityManagerImpl;
import org.hibernate.jpa.spi.AbstractQueryImpl;
import org.hibernate.jpa.spi.BaseQueryImpl;
import org.hibernate.jpa.spi.ParameterBind;
import org.hibernate.jpa.spi.ParameterRegistration;
import org.hibernate.type.CompositeCustomType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class QueryImpl<X>
extends AbstractQueryImpl<X>
implements TypedQuery<X>,
HibernateQuery,
org.hibernate.ejb.HibernateQuery {
    public static final EntityManagerMessageLogger LOG = Logger.getMessageLogger(EntityManagerMessageLogger.class, QueryImpl.class.getName());
    private Query query;

    public QueryImpl(Query query, AbstractEntityManagerImpl em) {
        this(query, em, Collections.emptyMap());
    }

    public QueryImpl(Query query, AbstractEntityManagerImpl em, Map<String, Class> namedParameterTypeRedefinitions) {
        super(em);
        this.query = query;
        this.extractParameterInfo(namedParameterTypeRedefinitions);
    }

    @Override
    protected boolean isNativeSqlQuery() {
        return SQLQuery.class.isInstance(this.query);
    }

    @Override
    protected boolean isSelectQuery() {
        if (this.isNativeSqlQuery()) {
            throw new IllegalStateException("Cannot tell if native SQL query is SELECT query");
        }
        return ((org.hibernate.internal.QueryImpl)org.hibernate.internal.QueryImpl.class.cast(this.query)).isSelect();
    }

    private void extractParameterInfo(Map<String, Class> namedParameterTypeRedefinition) {
        Class javaType;
        Serializable descriptor;
        if (!org.hibernate.internal.AbstractQueryImpl.class.isInstance(this.query)) {
            throw new IllegalStateException("Unknown query type for parameter extraction");
        }
        boolean hadJpaPositionalParameters = false;
        ParameterMetadata parameterMetadata = ((org.hibernate.internal.AbstractQueryImpl)org.hibernate.internal.AbstractQueryImpl.class.cast(this.query)).getParameterMetadata();
        for (String name : parameterMetadata.getNamedParameterNames()) {
            descriptor = parameterMetadata.getNamedParameterDescriptor(name);
            javaType = namedParameterTypeRedefinition.get(name);
            if (javaType != null && this.mightNeedRedefinition(javaType, ((NamedParameterDescriptor)descriptor).getExpectedType())) {
                ((NamedParameterDescriptor)descriptor).resetExpectedType(this.sfi().getTypeResolver().heuristicType(javaType.getName()));
            } else if (((NamedParameterDescriptor)descriptor).getExpectedType() != null) {
                javaType = ((NamedParameterDescriptor)descriptor).getExpectedType().getReturnedClass();
            }
            if (((NamedParameterDescriptor)descriptor).isJpaStyle()) {
                hadJpaPositionalParameters = true;
                Integer position = Integer.valueOf(name);
                this.registerParameter(new JpaPositionalParameterRegistrationImpl((javax.persistence.Query)this, this.query, position, javaType));
                continue;
            }
            this.registerParameter(new ParameterRegistrationImpl((javax.persistence.Query)this, this.query, name, javaType));
        }
        if (hadJpaPositionalParameters && parameterMetadata.getOrdinalParameterCount() > 0) {
            throw new IllegalArgumentException("Cannot mix JPA positional parameters and native Hibernate positional/ordinal parameters");
        }
        int max = parameterMetadata.getOrdinalParameterCount();
        for (int i = 0; i < max; ++i) {
            descriptor = parameterMetadata.getOrdinalParameterDescriptor(i + 1);
            javaType = ((OrdinalParameterDescriptor)descriptor).getExpectedType() == null ? null : ((OrdinalParameterDescriptor)descriptor).getExpectedType().getReturnedClass();
            this.registerParameter(new ParameterRegistrationImpl((javax.persistence.Query)this, this.query, i + 1, javaType));
        }
    }

    private SessionFactoryImplementor sfi() {
        return (SessionFactoryImplementor)this.getEntityManager().getFactory().getSessionFactory();
    }

    private boolean mightNeedRedefinition(Class javaType, Type expectedType) {
        if (expectedType == null) {
            return Date.class.isAssignableFrom(javaType);
        }
        return Date.class.isAssignableFrom(javaType) && !CompositeCustomType.class.isAssignableFrom(expectedType.getClass());
    }

    @Override
    public Query getHibernateQuery() {
        return this.query;
    }

    @Override
    protected int internalExecuteUpdate() {
        return this.query.executeUpdate();
    }

    @Override
    protected void applyMaxResults(int maxResults) {
        this.query.setMaxResults(maxResults);
    }

    @Override
    protected void applyFirstResult(int firstResult) {
        this.query.setFirstResult(firstResult);
    }

    @Override
    protected boolean applyTimeoutHint(int timeout) {
        this.query.setTimeout(timeout);
        return true;
    }

    @Override
    protected boolean applyCommentHint(String comment) {
        this.query.setComment(comment);
        return true;
    }

    @Override
    protected boolean applyFetchSizeHint(int fetchSize) {
        this.query.setFetchSize(fetchSize);
        return true;
    }

    @Override
    protected boolean applyCacheableHint(boolean isCacheable) {
        this.query.setCacheable(isCacheable);
        return true;
    }

    @Override
    protected boolean applyCacheRegionHint(String regionName) {
        this.query.setCacheRegion(regionName);
        return true;
    }

    @Override
    protected boolean applyReadOnlyHint(boolean isReadOnly) {
        this.query.setReadOnly(isReadOnly);
        return true;
    }

    @Override
    protected boolean applyCacheModeHint(CacheMode cacheMode) {
        this.query.setCacheMode(cacheMode);
        return true;
    }

    @Override
    protected boolean applyFlushModeHint(FlushMode flushMode) {
        this.query.setFlushMode(flushMode);
        return true;
    }

    @Override
    protected boolean canApplyAliasSpecificLockModeHints() {
        return org.hibernate.internal.QueryImpl.class.isInstance(this.query) || SQLQueryImpl.class.isInstance(this.query);
    }

    @Override
    protected void applyAliasSpecificLockModeHint(String alias, LockMode lockMode) {
        this.query.getLockOptions().setAliasSpecificLockMode(alias, lockMode);
    }

    @Override
    public List<X> getResultList() {
        this.getEntityManager().checkOpen(true);
        this.checkTransaction();
        this.beforeQuery();
        try {
            return this.list();
        }
        catch (QueryExecutionRequestException he) {
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            throw this.getEntityManager().convert(he);
        }
    }

    private void beforeQuery() {
        Query query = this.getHibernateQuery();
        if (!SQLQuery.class.isInstance(query)) {
            return;
        }
        SQLQuery sqlQuery = (SQLQuery)query;
        if (sqlQuery.getSynchronizedQuerySpaces() != null && !sqlQuery.getSynchronizedQuerySpaces().isEmpty()) {
            return;
        }
        if (this.getEntityManager().isTransactionInProgress()) {
            this.getEntityManager().flush();
        }
    }

    @Override
    public X getSingleResult() {
        this.getEntityManager().checkOpen(true);
        this.checkTransaction();
        this.beforeQuery();
        try {
            List<X> result = this.list();
            if (result.size() == 0) {
                NoResultException nre = new NoResultException("No entity found for query");
                this.getEntityManager().handlePersistenceException(nre);
                throw nre;
            }
            if (result.size() > 1) {
                HashSet<X> uniqueResult = new HashSet<X>(result);
                if (uniqueResult.size() > 1) {
                    NonUniqueResultException nure = new NonUniqueResultException("result returns more than one elements");
                    this.getEntityManager().handlePersistenceException(nure);
                    throw nure;
                }
                return (X)uniqueResult.iterator().next();
            }
            return result.get(0);
        }
        catch (QueryExecutionRequestException he) {
            throw new IllegalStateException(he);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e);
        }
        catch (HibernateException he) {
            throw this.getEntityManager().convert(he);
        }
    }

    @Override
    public <T> T unwrap(Class<T> tClass) {
        if (Query.class.isAssignableFrom(tClass)) {
            return (T)this.query;
        }
        if (QueryImpl.class.isAssignableFrom(tClass)) {
            return (T)this;
        }
        if (HibernateQuery.class.isAssignableFrom(tClass)) {
            return (T)this;
        }
        throw new PersistenceException(String.format("Unsure how to unwrap %s impl [%s] as requested type [%s]", javax.persistence.Query.class.getSimpleName(), this.getClass().getName(), tClass.getName()));
    }

    @Override
    protected void internalApplyLockMode(LockModeType lockModeType) {
        this.query.getLockOptions().setLockMode(LockModeTypeHelper.getLockMode(lockModeType));
        if (this.getHints() != null && this.getHints().containsKey("javax.persistence.lock.timeout")) {
            this.applyLockTimeoutHint(ConfigurationHelper.getInteger(this.getHints().get("javax.persistence.lock.timeout")));
        }
    }

    @Override
    protected boolean applyLockTimeoutHint(int timeout) {
        this.query.getLockOptions().setTimeOut(timeout);
        return true;
    }

    private List<X> list() {
        if (this.getEntityGraphQueryHint() != null) {
            SessionImplementor sessionImpl = (SessionImplementor)((Object)this.getEntityManager().getSession());
            HQLQueryPlan entityGraphQueryPlan = new HQLQueryPlan(this.getHibernateQuery().getQueryString(), false, sessionImpl.getEnabledFilters(), sessionImpl.getFactory(), this.getEntityGraphQueryHint());
            this.unwrap(org.hibernate.internal.QueryImpl.class).setQueryPlan(entityGraphQueryPlan);
        }
        return this.query.list();
    }

    public static class JpaPositionalParameterRegistrationImpl<T>
    extends ParameterRegistrationImpl<T> {
        final Integer position;

        protected JpaPositionalParameterRegistrationImpl(javax.persistence.Query jpaQuery, Query nativeQuery, Integer position, Class<T> javaType) {
            super(jpaQuery, nativeQuery, position.toString(), javaType);
            this.position = position;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public Integer getPosition() {
            return this.position;
        }

        @Override
        public boolean isJpaPositionalParameter() {
            return true;
        }
    }

    private static class ParameterRegistrationImpl<T>
    implements ParameterRegistration<T> {
        private final javax.persistence.Query jpaQuery;
        private final Query nativeQuery;
        private final String name;
        private final Integer position;
        private final Class<T> javaType;
        private ParameterBind<T> bind;

        protected ParameterRegistrationImpl(javax.persistence.Query jpaQuery, Query nativeQuery, String name, Class<T> javaType) {
            this.jpaQuery = jpaQuery;
            this.nativeQuery = nativeQuery;
            this.name = name;
            this.javaType = javaType;
            this.position = null;
        }

        protected ParameterRegistrationImpl(javax.persistence.Query jpaQuery, Query nativeQuery, Integer position, Class<T> javaType) {
            this.jpaQuery = jpaQuery;
            this.nativeQuery = nativeQuery;
            this.position = position;
            this.javaType = javaType;
            this.name = null;
        }

        @Override
        public boolean isJpaPositionalParameter() {
            return false;
        }

        @Override
        public javax.persistence.Query getQuery() {
            return this.jpaQuery;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Integer getPosition() {
            return this.position;
        }

        @Override
        public Class<T> getParameterType() {
            return this.javaType;
        }

        @Override
        public ParameterMode getMode() {
            return ParameterMode.IN;
        }

        @Override
        public boolean isBindable() {
            return true;
        }

        @Override
        public void bindValue(T value) {
            QueryImpl.validateBinding(this.getParameterType(), value, null);
            if (this.name != null) {
                if (value instanceof Collection) {
                    this.nativeQuery.setParameterList(this.name, (Collection)value);
                } else {
                    this.nativeQuery.setParameter(this.name, value);
                }
            } else {
                this.nativeQuery.setParameter(this.position - 1, value);
            }
            this.bind = new BaseQueryImpl.ParameterBindImpl<T>(value, null);
        }

        @Override
        public void bindValue(T value, TemporalType specifiedTemporalType) {
            QueryImpl.validateBinding(this.getParameterType(), value, specifiedTemporalType);
            if (Date.class.isInstance(value)) {
                if (this.name != null) {
                    if (specifiedTemporalType == TemporalType.DATE) {
                        this.nativeQuery.setDate(this.name, (Date)value);
                    } else if (specifiedTemporalType == TemporalType.TIME) {
                        this.nativeQuery.setTime(this.name, (Date)value);
                    } else if (specifiedTemporalType == TemporalType.TIMESTAMP) {
                        this.nativeQuery.setTimestamp(this.name, (Date)value);
                    }
                } else if (specifiedTemporalType == TemporalType.DATE) {
                    this.nativeQuery.setDate(this.position - 1, (Date)value);
                } else if (specifiedTemporalType == TemporalType.TIME) {
                    this.nativeQuery.setTime(this.position - 1, (Date)value);
                } else if (specifiedTemporalType == TemporalType.TIMESTAMP) {
                    this.nativeQuery.setTimestamp(this.position - 1, (Date)value);
                }
            } else if (Calendar.class.isInstance(value)) {
                if (this.name != null) {
                    if (specifiedTemporalType == TemporalType.DATE) {
                        this.nativeQuery.setCalendarDate(this.name, (Calendar)value);
                    } else {
                        if (specifiedTemporalType == TemporalType.TIME) {
                            throw new IllegalArgumentException("not yet implemented");
                        }
                        if (specifiedTemporalType == TemporalType.TIMESTAMP) {
                            this.nativeQuery.setCalendar(this.name, (Calendar)value);
                        }
                    }
                } else if (specifiedTemporalType == TemporalType.DATE) {
                    this.nativeQuery.setCalendarDate(this.position - 1, (Calendar)value);
                } else {
                    if (specifiedTemporalType == TemporalType.TIME) {
                        throw new IllegalArgumentException("not yet implemented");
                    }
                    if (specifiedTemporalType == TemporalType.TIMESTAMP) {
                        this.nativeQuery.setCalendar(this.position - 1, (Calendar)value);
                    }
                }
            } else {
                throw new IllegalArgumentException("Unexpected type [" + value + "] passed with TemporalType; expecting Date or Calendar");
            }
            this.bind = new BaseQueryImpl.ParameterBindImpl<T>(value, specifiedTemporalType);
        }

        @Override
        public ParameterBind<T> getBind() {
            return this.bind;
        }
    }
}

