/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.cn.index.generator.filter;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.dataone.configuration.Settings;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.Replica;
import org.dataone.service.types.v2.SystemMetadata;

public class HZEventFilter {
    private static Logger logger = Logger.getLogger(HZEventFilter.class);
    private static String INDEX_EVENT_FILTERING_ACTIVE = "indexEvent.filtering.active";
    private static String ID = "id";
    private static String DATEMODIFIED = "dateModified";
    private static String REPLICAMN = "replicaMN";
    private static String REPLICAVERIFIEDATE = "replicaVerifiedDate";
    private static String SERIALVERSION = "serialVersion";
    private static int FIRSTSOLRDOCINDEX = 0;
    private String solrBaseURL = Settings.getConfiguration().getString("solr.base.uri", "http://localhost:8983/solr/search_core");
    private SolrClient client = null;

    public HZEventFilter() {
        logger.info("HZEvetFilter.constructor - the base url is " + this.solrBaseURL);
        this.client = new HttpSolrClient(this.solrBaseURL);
    }

    public boolean filter(SystemMetadata sysmeta) {
        boolean needFilterOut;
        block17: {
            needFilterOut = true;
            Identifier pid = sysmeta.getIdentifier();
            boolean enableFiltering = Settings.getConfiguration().getBoolean(INDEX_EVENT_FILTERING_ACTIVE, true);
            if (enableFiltering) {
                try {
                    List<Replica> solrReplicas;
                    SolrDocument solrDoc;
                    String id;
                    if (this.client == null) {
                        this.client = new HttpSolrClient(this.solrBaseURL);
                    }
                    if ((id = this.getId(solrDoc = this.getSolrReponse(pid.getValue()))) == null) {
                        boolean archive = sysmeta.getArchived();
                        if (archive) {
                            logger.info("HZEventFilter.filter - the system metadata for the index event shows " + pid.getValue() + " is an archived object and the SOLR server doesn't have the record either. So this event has been filtered out for indexing (no indexing).");
                            needFilterOut = true;
                        } else {
                            logger.info("HZEventFilter.filter - the system metadata  for the index event shows shows " + pid.getValue() + " is not an archived object but the SOLR server doesn't have the record. So this event should be granted for indexing.");
                            needFilterOut = false;
                        }
                        break block17;
                    }
                    Date sysDate = sysmeta.getDateSysMetadataModified();
                    Date solrDate = this.getModificationDateInSolr(solrDoc);
                    if (sysDate.getTime() > solrDate.getTime()) {
                        logger.info("HZEventFilter.filter - the system metadata for the index event shows shows " + pid.getValue() + " having a newer version than the SOLR server. So this event should be granted for indexing.");
                        needFilterOut = false;
                        break block17;
                    }
                    if (sysDate.getTime() < solrDate.getTime()) {
                        logger.info("HZEventFilter.filter - the system metadata for the index event shows shows " + pid.getValue() + " having an older version than the SOLR server. So this event has been filtered out for indexing (no indexing).");
                        needFilterOut = true;
                        break block17;
                    }
                    BigInteger sysSerial = sysmeta.getSerialVersion();
                    BigInteger solrSerial = this.getSerialVersion(solrDoc);
                    if (solrSerial != null) {
                        if (solrSerial.compareTo(sysSerial) == 0) {
                            logger.info("HZEventFilter.filter - the system metadata for the index event shows shows " + pid.getValue() + " having the same modification date and serial version in the solr document. So this event has been filtered out for indexing (no indexing).");
                            needFilterOut = true;
                        } else if (solrSerial.compareTo(sysSerial) == -1) {
                            logger.info("HZEventFilter.filter - the system metadata for the index event shows shows " + pid.getValue() + " having the same modification date but the serial version in the solr document is less than the one in the system metadata. So this event should be granted for indexing.");
                            needFilterOut = false;
                        } else if (solrSerial.compareTo(sysSerial) == 1) {
                            logger.info("HZEventFilter.filter - the system metadata for the index event shows shows " + pid.getValue() + " having the same modification date but the serial version in the solr document is greater than the one in the system metadata. So this event has been filtered out for indexing (no indexing).");
                            needFilterOut = true;
                        }
                        break block17;
                    }
                    List<Replica> sysReplicas = sysmeta.getReplicaList();
                    boolean equal = this.compareRaplicaList(pid, sysReplicas, solrReplicas = this.getReplicasInSolr(solrDoc));
                    if (equal) {
                        logger.info("HZEventFilter.filter - the system metadata for the index event shows " + pid.getValue() + " having the same modification date as the SOLR server. Also both have the same replica list. So this event has been filtered out for indexing (no indexing).");
                        needFilterOut = true;
                        break block17;
                    }
                    logger.info("HZEventFilter.filter - the system metadata for the index event shows " + pid.getValue() + " having the same modification date as the SOLR server. However, they have different replica lists. So this event should be granted for indexing.");
                    needFilterOut = false;
                }
                catch (Exception e) {
                    logger.warn("HZEventFilter.filter - there was an exception in comparing the solr record for " + pid.getValue() + " to its system metadata. However, this event still should be granted for indexing for safe.", e);
                    needFilterOut = false;
                }
            } else {
                logger.info("HZEventFilter.filter - The filter was disable by setting indexEvent.filtering.active=false. So the index event for " + pid.getValue() + " should be granted for indexing.");
                needFilterOut = false;
            }
        }
        return needFilterOut;
    }

    public void closeSolrClient() throws IOException {
        if (this.client != null) {
            this.client.close();
        }
    }

    private boolean compareRaplicaList(Identifier pid, List<Replica> sysReplicas, List<Replica> solrReplicas) {
        boolean equal = true;
        if (sysReplicas != null) {
            if (sysReplicas.size() != solrReplicas.size()) {
                logger.info("HZEventFilter.compareRaplicaList - the system metadata for the index event " + pid.getValue() + " has a diffrerent size of the replicas to the solr doc. Not the same");
                equal = false;
            } else {
                block0: for (Replica sysReplica : sysReplicas) {
                    boolean found = false;
                    boolean haveDifferentVerificationDate = false;
                    NodeReference sysNode = sysReplica.getReplicaMemberNode();
                    logger.debug("The replica node id in the sysem metadata is " + sysNode.getValue());
                    Date sysConfirmDate = sysReplica.getReplicaVerified();
                    logger.debug("The replica node verification date in the sysem metadata is =====" + sysConfirmDate);
                    for (Replica solrReplica : solrReplicas) {
                        NodeReference solrNode = solrReplica.getReplicaMemberNode();
                        logger.debug("The replica node id in the solr is " + solrNode.getValue());
                        Date solrConfirmDate = solrReplica.getReplicaVerified();
                        logger.debug("The replica node verification date in the solr is " + solrConfirmDate);
                        if (sysNode.equals(solrNode)) {
                            found = true;
                            if (sysConfirmDate.getTime() != solrConfirmDate.getTime()) {
                                logger.info("The verfication date in the system metadata is different in the solr for the node " + sysNode.getValue());
                                haveDifferentVerificationDate = true;
                            }
                        }
                        if (!found || !haveDifferentVerificationDate) continue;
                        logger.info("HZEventFilter.compareReplicaList - the system metadata for the index event shows " + pid.getValue() + " having at least one of the replica has different verified date to solr doc. Not the same.");
                        equal = false;
                        break block0;
                    }
                    if (found) continue;
                    logger.info("HZEventFilter.compareReplicaList - the system metadata for the index event shows " + pid.getValue() + " having at least one of the replica which can't be found on the solr doc. Not the same.");
                    equal = false;
                    break;
                }
                if (equal) {
                    logger.info("HZEventFilter.compareReplicaList - the system metadata for the index event shows " + pid.getValue() + " having the same replica list as the solr doc.");
                    equal = true;
                }
            }
        } else if (solrReplicas.isEmpty()) {
            logger.info("HZEventFilter.compareReplicaList - the system metadata for the index event shows " + pid.getValue() + " having  an emply replica list. So does the solr doc.Same.");
            equal = true;
        } else {
            logger.info("HZEventFilter.compareReplicaList - the system metadata for the index event shows " + pid.getValue() + " having an empty replica list while the solr doesn't.Not same.");
            equal = false;
        }
        return equal;
    }

    private List<Replica> getReplicasInSolr(SolrDocument doc) throws Exception {
        ArrayList<Replica> replicas = new ArrayList<Replica>();
        Collection<Object> mns = this.getValues(doc, REPLICAMN);
        Collection<Object> verifiedDates = this.getValues(doc, REPLICAVERIFIEDATE);
        if (mns == null && verifiedDates != null || mns != null && verifiedDates == null) {
            throw new Exception("The number of the repicat nodes doesn't match the number of the verified date in the solr document. There is an issue on the solr doc.");
        }
        if (mns != null && verifiedDates != null) {
            if (mns.size() != verifiedDates.size()) {
                throw new Exception("The number of the repicat nodes doesn't match the number of the verified date in the solr document");
            }
            Object[] mnsArray = mns.toArray();
            Object[] verifiedDatesArray = verifiedDates.toArray();
            for (int i = 0; i < mnsArray.length; ++i) {
                Object mnObj = mnsArray[i];
                Object dateObj = verifiedDatesArray[i];
                String mnStr = (String)mnObj;
                Date date = (Date)dateObj;
                if (mnStr == null || mnStr.trim().equals("") || date == null) {
                    throw new Exception("The replication information about the memeber node id or the verfidate date shouldn't be null or blank in the solr document.");
                }
                logger.debug("HZEventFilter.getReplicaInSor - the node id of the replica is " + mnStr);
                logger.debug("HZEventFilter.getReplicaInSor - the verified date of the replica with id " + mnStr + " is " + date);
                NodeReference mn = new NodeReference();
                mn.setValue(mnStr);
                Replica replica = new Replica();
                replica.setReplicaMemberNode(mn);
                replica.setReplicaVerified(date);
                replicas.add(replica);
            }
        }
        return replicas;
    }

    private BigInteger getSerialVersion(SolrDocument doc) {
        BigInteger serialVersion;
        block0: {
            Iterator<Object> iterator;
            serialVersion = null;
            Collection<Object> values = this.getValues(doc, SERIALVERSION);
            if (values == null || !(iterator = values.iterator()).hasNext()) break block0;
            Object obj = iterator.next();
            serialVersion = (BigInteger)obj;
        }
        return serialVersion;
    }

    private Date getModificationDateInSolr(SolrDocument doc) {
        Date date;
        block0: {
            Iterator<Object> iterator;
            date = null;
            Collection<Object> values = this.getValues(doc, DATEMODIFIED);
            if (values == null || !(iterator = values.iterator()).hasNext()) break block0;
            Object obj = iterator.next();
            date = (Date)obj;
        }
        return date;
    }

    private String getId(SolrDocument doc) {
        String id;
        block0: {
            Iterator<Object> iterator;
            id = null;
            Collection<Object> values = this.getValues(doc, ID);
            if (values == null || !(iterator = values.iterator()).hasNext()) break block0;
            Object obj = iterator.next();
            id = (String)obj;
        }
        return id;
    }

    private Collection<Object> getValues(SolrDocument doc, String fieldName) {
        Collection<Object> fieldValues = null;
        if (doc != null) {
            fieldValues = doc.getFieldValues(fieldName);
        }
        return fieldValues;
    }

    private SolrDocument getSolrReponse(String id) throws SolrServerException, IOException {
        SolrDocument document = new SolrDocument();
        id = HZEventFilter.escapeQueryChars(id);
        String filter = ID + ":" + id;
        System.out.println("the filter is " + filter);
        SolrQuery query = new SolrQuery(filter);
        query.setFields(ID, DATEMODIFIED, REPLICAMN, REPLICAVERIFIEDATE, SERIALVERSION);
        query.setStart(0);
        QueryResponse response = this.client.query(query);
        SolrDocumentList results = response.getResults();
        if (results.size() > 0) {
            document = (SolrDocument)results.get(FIRSTSOLRDOCINDEX);
        }
        return document;
    }

    public static String escapeQueryChars(String s) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '+' || c == '-' || c == '!' || c == '(' || c == ')' || c == ':' || c == '^' || c == '[' || c == ']' || c == '\"' || c == '{' || c == '}' || c == '~' || c == '*' || c == '?' || c == '|' || c == '&' || c == ';' || Character.isWhitespace(c)) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

