/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.common.params.SolrParams;

public class HttpClientConfigurer {
    public void configure(DefaultHttpClient httpClient, SolrParams config) {
        boolean sslCheckPeerName;
        if (config.get("maxConnections") != null) {
            HttpClientUtil.setMaxConnections(httpClient, config.getInt("maxConnections"));
        }
        if (config.get("maxConnectionsPerHost") != null) {
            HttpClientUtil.setMaxConnectionsPerHost(httpClient, config.getInt("maxConnectionsPerHost"));
        }
        if (config.get("connTimeout") != null) {
            HttpClientUtil.setConnectionTimeout(httpClient, config.getInt("connTimeout"));
        }
        if (config.get("socketTimeout") != null) {
            HttpClientUtil.setSoTimeout(httpClient, config.getInt("socketTimeout"));
        }
        if (config.get("followRedirects") != null) {
            HttpClientUtil.setFollowRedirects(httpClient, config.getBool("followRedirects"));
        }
        HttpClientUtil.setUseRetry(httpClient, config.getBool("retry", true));
        String basicAuthUser = config.get("httpBasicAuthUser");
        String basicAuthPass = config.get("httpBasicAuthPassword");
        HttpClientUtil.setBasicAuth(httpClient, basicAuthUser, basicAuthPass);
        if (config.get("allowCompression") != null) {
            HttpClientUtil.setAllowCompression(httpClient, config.getBool("allowCompression"));
        }
        if (!(sslCheckPeerName = HttpClientConfigurer.toBooleanDefaultIfNull(HttpClientConfigurer.toBooleanObject(System.getProperty("solr.ssl.checkPeerName")), true))) {
            HttpClientUtil.setHostNameVerifier(httpClient, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
    }

    public static boolean toBooleanDefaultIfNull(Boolean bool, boolean valueIfNull) {
        if (bool == null) {
            return valueIfNull;
        }
        return bool != false;
    }

    public static Boolean toBooleanObject(String str) {
        if ("true".equalsIgnoreCase(str)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(str)) {
            return Boolean.FALSE;
        }
        return null;
    }
}

