/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.logging;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LogEvent;
import com.hazelcast.logging.LoggerFactory;
import com.hazelcast.logging.LoggerFactorySupport;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class StandardLoggerFactory
extends LoggerFactorySupport
implements LoggerFactory {
    protected ILogger createLogger(String name) {
        Logger l = Logger.getLogger(name);
        return new StandardLogger(l);
    }

    class StandardLogger
    implements ILogger {
        private final Logger logger;

        public StandardLogger(Logger logger2) {
            this.logger = logger2;
        }

        public void log(Level level, String message) {
            this.log(level, message, null);
        }

        public void log(Level level, String message, Throwable thrown) {
            LogRecord logRecord = new LogRecord(level, message);
            logRecord.setLoggerName(this.logger.getName());
            logRecord.setThrown(thrown);
            logRecord.setSourceClassName(this.logger.getName());
            this.logger.log(logRecord);
        }

        public void log(LogEvent logEvent) {
            this.logger.log(logEvent.getLogRecord());
        }

        public Level getLevel() {
            return this.logger.getLevel();
        }

        public boolean isLoggable(Level level) {
            return this.logger.isLoggable(level);
        }
    }
}

