/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.QueryHint;
import javax.persistence.TypedQuery;
import org.springframework.data.jpa.repository.query.JpaQueryExecution;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.util.Assert;

public abstract class AbstractJpaQuery
implements RepositoryQuery {
    private final JpaQueryMethod method;
    private final EntityManager em;

    public AbstractJpaQuery(JpaQueryMethod method, EntityManager em) {
        Assert.notNull(method);
        Assert.notNull(em);
        this.method = method;
        this.em = em;
    }

    @Override
    public JpaQueryMethod getQueryMethod() {
        return this.method;
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    @Override
    public Object execute(Object[] parameters) {
        return this.doExecute(this.getExecution(), parameters);
    }

    private Object doExecute(JpaQueryExecution execution, Object[] values) {
        return execution.execute(this, values);
    }

    protected JpaQueryExecution getExecution() {
        if (this.method.isCollectionQuery()) {
            return new JpaQueryExecution.CollectionExecution();
        }
        if (this.method.isPageQuery()) {
            return new JpaQueryExecution.PagedExecution(this.method.getParameters());
        }
        if (this.method.isModifyingQuery()) {
            return this.method.getClearAutomatically() ? new JpaQueryExecution.ModifyingExecution(this.method, this.em) : new JpaQueryExecution.ModifyingExecution(this.method, null);
        }
        return new JpaQueryExecution.SingleEntityExecution();
    }

    private <T extends Query> T applyHints(T query, JpaQueryMethod method) {
        for (QueryHint hint : method.getHints()) {
            query.setHint(hint.name(), hint.value());
        }
        return query;
    }

    private Query applyLockMode(Query query, JpaQueryMethod method) {
        LockModeType lockModeType = method.getLockModeType();
        return lockModeType == null ? query : query.setLockMode(lockModeType);
    }

    protected ParameterBinder createBinder(Object[] values) {
        return new ParameterBinder(this.getQueryMethod().getParameters(), values);
    }

    protected Query createQuery(Object[] values) {
        return this.applyLockMode(this.applyHints(this.doCreateQuery(values), this.method), this.method);
    }

    protected TypedQuery<Long> createCountQuery(Object[] values) {
        TypedQuery<Long> countQuery = this.doCreateCountQuery(values);
        return this.method.applyHintsToCountQuery() ? this.applyHints(countQuery, this.method) : countQuery;
    }

    protected abstract Query doCreateQuery(Object[] var1);

    protected abstract TypedQuery<Long> doCreateCountQuery(Object[] var1);
}

