/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.mapping;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import javax.persistence.metamodel.Metamodel;
import org.springframework.data.jpa.mapping.JpaPersistentEntityImpl;
import org.springframework.data.jpa.mapping.JpaPersistentProperty;
import org.springframework.data.jpa.mapping.JpaPersistentPropertyImpl;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class JpaMetamodelMappingContext
extends AbstractMappingContext<JpaPersistentEntityImpl<?>, JpaPersistentProperty> {
    private final Metamodel model;

    public JpaMetamodelMappingContext(Metamodel model) {
        Assert.notNull(model, "JPA Metamodel must not be null!");
        this.model = model;
    }

    @Override
    protected <T> JpaPersistentEntityImpl<?> createPersistentEntity(TypeInformation<T> typeInformation) {
        return new JpaPersistentEntityImpl<T>(typeInformation, null);
    }

    @Override
    protected JpaPersistentProperty createPersistentProperty(Field field, PropertyDescriptor descriptor, JpaPersistentEntityImpl<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new JpaPersistentPropertyImpl(this.model, field, descriptor, owner, simpleTypeHolder);
    }

    @Override
    protected boolean shouldCreatePersistentEntityFor(TypeInformation<?> type) {
        try {
            this.model.managedType(type.getType());
            return true;
        }
        catch (IllegalArgumentException o_O) {
            return false;
        }
    }
}

