/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.boot.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.persistence.AttributeConverter;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import javax.persistence.PersistenceException;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.hibernate.Interceptor;
import org.hibernate.InvalidMappingException;
import org.hibernate.MappingException;
import org.hibernate.MappingNotFoundException;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.selector.StrategyRegistrationProvider;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.beanvalidation.BeanValidationIntegrator;
import org.hibernate.cfg.naming.NamingStrategyDelegator;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.transaction.internal.jdbc.JdbcTransactionFactory;
import org.hibernate.engine.transaction.internal.jta.CMTTransactionFactory;
import org.hibernate.id.factory.spi.MutableIdentifierGeneratorFactory;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.internal.jaxb.cfg.JaxbHibernateConfiguration;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.ValueHolder;
import org.hibernate.jpa.boot.internal.ClassDescriptorImpl;
import org.hibernate.jpa.boot.internal.MappingFileDescriptorImpl;
import org.hibernate.jpa.boot.internal.PackageDescriptorImpl;
import org.hibernate.jpa.boot.internal.SettingsImpl;
import org.hibernate.jpa.boot.internal.UrlInputStreamAccess;
import org.hibernate.jpa.boot.scan.internal.StandardScanOptions;
import org.hibernate.jpa.boot.scan.internal.StandardScanner;
import org.hibernate.jpa.boot.scan.spi.ScanOptions;
import org.hibernate.jpa.boot.scan.spi.ScanResult;
import org.hibernate.jpa.boot.scan.spi.Scanner;
import org.hibernate.jpa.boot.spi.ClassDescriptor;
import org.hibernate.jpa.boot.spi.EntityManagerFactoryBuilder;
import org.hibernate.jpa.boot.spi.InputStreamAccess;
import org.hibernate.jpa.boot.spi.IntegratorProvider;
import org.hibernate.jpa.boot.spi.MappingFileDescriptor;
import org.hibernate.jpa.boot.spi.NamedInputStream;
import org.hibernate.jpa.boot.spi.PackageDescriptor;
import org.hibernate.jpa.boot.spi.PersistenceUnitDescriptor;
import org.hibernate.jpa.boot.spi.StrategyRegistrationProviderList;
import org.hibernate.jpa.boot.spi.TypeContributorList;
import org.hibernate.jpa.event.spi.JpaIntegrator;
import org.hibernate.jpa.internal.EntityManagerFactoryImpl;
import org.hibernate.jpa.internal.EntityManagerMessageLogger;
import org.hibernate.jpa.internal.schemagen.JpaSchemaGenerator;
import org.hibernate.jpa.internal.util.LogHelper;
import org.hibernate.jpa.internal.util.PersistenceUnitTransactionTypeHelper;
import org.hibernate.jpa.spi.IdentifierGeneratorStrategyProvider;
import org.hibernate.metamodel.source.annotations.JPADotNames;
import org.hibernate.metamodel.source.annotations.JandexHelper;
import org.hibernate.metamodel.spi.TypeContributor;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.secure.spi.GrantedPermission;
import org.hibernate.secure.spi.JaccService;
import org.hibernate.service.ConfigLoader;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;

public class EntityManagerFactoryBuilderImpl
implements EntityManagerFactoryBuilder {
    private static final EntityManagerMessageLogger LOG = Logger.getMessageLogger(EntityManagerMessageLogger.class, EntityManagerFactoryBuilderImpl.class.getName());
    private static final String META_INF_ORM_XML = "META-INF/orm.xml";
    public static final String INTEGRATOR_PROVIDER = "hibernate.integrator_provider";
    public static final String STRATEGY_REGISTRATION_PROVIDERS = "hibernate.strategy_registration_provider";
    public static final String TYPE_CONTRIBUTORS = "hibernate.type_contributors";
    public static final String JANDEX_INDEX = "hibernate.jandex_index";
    private Object validatorFactory;
    private DataSource dataSource;
    private final PersistenceUnitDescriptor persistenceUnit;
    private final SettingsImpl settings = new SettingsImpl();
    private final StandardServiceRegistryBuilder serviceRegistryBuilder;
    private final Map configurationValues;
    private final List<GrantedPermission> grantedJaccPermissions = new ArrayList<GrantedPermission>();
    private final List<CacheRegionDefinition> cacheRegionDefinitions = new ArrayList<CacheRegionDefinition>();
    private final List<JaxbHibernateConfiguration.JaxbSessionFactory.JaxbMapping> cfgXmlNamedMappings = new ArrayList<JaxbHibernateConfiguration.JaxbSessionFactory.JaxbMapping>();
    private Interceptor sessionFactoryInterceptor;
    private NamingStrategy namingStrategy;
    private NamingStrategyDelegator namingStrategyDelegator;
    private SessionFactoryObserver suppliedSessionFactoryObserver;
    private MetadataSources metadataSources;
    private Configuration hibernateConfiguration;
    private static EntityNotFoundDelegate jpaEntityNotFoundDelegate = new JpaEntityNotFoundDelegate();
    private ClassLoader providedClassLoader;
    private String jaccContextId;

    public EntityManagerFactoryBuilderImpl(PersistenceUnitDescriptor persistenceUnit, Map integrationSettings) {
        this(persistenceUnit, integrationSettings, null);
    }

    public EntityManagerFactoryBuilderImpl(PersistenceUnitDescriptor persistenceUnit, Map integrationSettings, ClassLoader providedClassLoader) {
        LogHelper.logPersistenceUnitInformation(persistenceUnit);
        this.persistenceUnit = persistenceUnit;
        if (integrationSettings == null) {
            integrationSettings = Collections.emptyMap();
        }
        this.providedClassLoader = providedClassLoader;
        BootstrapServiceRegistry bootstrapServiceRegistry = this.buildBootstrapServiceRegistry(integrationSettings);
        this.serviceRegistryBuilder = new StandardServiceRegistryBuilder(bootstrapServiceRegistry);
        this.configurationValues = this.mergePropertySources(persistenceUnit, integrationSettings, bootstrapServiceRegistry);
        this.serviceRegistryBuilder.applySettings(this.configurationValues);
        ScanResult scanResult = this.scan(bootstrapServiceRegistry);
        DeploymentResources deploymentResources = this.buildDeploymentResources(scanResult, bootstrapServiceRegistry);
        IndexView jandexIndex = this.locateOrBuildJandexIndex(deploymentResources);
        this.metadataSources = this.prepareMetadataSources(jandexIndex, deploymentResources, bootstrapServiceRegistry);
        this.withValidatorFactory(this.configurationValues.get("javax.persistence.validation.factory"));
        boolean useClassTransformer = "true".equals(this.configurationValues.remove("hibernate.ejb.use_class_enhancer"));
        if (useClassTransformer) {
            persistenceUnit.pushClassTransformer(this.metadataSources.collectMappingClassNames());
        }
    }

    private DeploymentResources buildDeploymentResources(ScanResult scanResult, BootstrapServiceRegistry bootstrapServiceRegistry) {
        final ArrayList<MappingFileDescriptor> mappingFileDescriptors = new ArrayList<MappingFileDescriptor>();
        HashSet<String> nonLocatedMappingFileNames = new HashSet<String>();
        List<String> explicitMappingFileNames = this.persistenceUnit.getMappingFileNames();
        if (explicitMappingFileNames != null) {
            nonLocatedMappingFileNames.addAll(explicitMappingFileNames);
        }
        for (MappingFileDescriptor mappingFileDescriptor : scanResult.getLocatedMappingFiles()) {
            mappingFileDescriptors.add(mappingFileDescriptor);
            nonLocatedMappingFileNames.remove(mappingFileDescriptor.getName());
        }
        for (String name : nonLocatedMappingFileNames) {
            MappingFileDescriptor descriptor = this.buildMappingFileDescriptor(name, bootstrapServiceRegistry);
            mappingFileDescriptors.add(descriptor);
        }
        final HashMap<String, ClassDescriptor> classDescriptorMap = new HashMap<String, ClassDescriptor>();
        final HashMap<String, PackageDescriptor> packageDescriptorMap = new HashMap<String, PackageDescriptor>();
        for (ClassDescriptor classDescriptor : scanResult.getLocatedClasses()) {
            classDescriptorMap.put(classDescriptor.getName(), classDescriptor);
        }
        for (PackageDescriptor packageDescriptor : scanResult.getLocatedPackages()) {
            packageDescriptorMap.put(packageDescriptor.getName(), packageDescriptor);
        }
        List<String> explicitClassNames = this.persistenceUnit.getManagedClassNames();
        if (explicitClassNames != null) {
            for (String explicitClassName : explicitClassNames) {
                if (classDescriptorMap.containsKey(explicitClassName) || packageDescriptorMap.containsKey(explicitClassName)) continue;
                String classFileName = explicitClassName.replace('.', '/') + ".class";
                URL classFileUrl = bootstrapServiceRegistry.getService(ClassLoaderService.class).locateResource(classFileName);
                if (classFileUrl != null) {
                    classDescriptorMap.put(explicitClassName, new ClassDescriptorImpl(explicitClassName, new UrlInputStreamAccess(classFileUrl)));
                    continue;
                }
                String packageInfoFileName = explicitClassName.replace('.', '/') + "/package-info.class";
                URL packageInfoFileUrl = bootstrapServiceRegistry.getService(ClassLoaderService.class).locateResource(packageInfoFileName);
                if (packageInfoFileUrl != null) {
                    packageDescriptorMap.put(explicitClassName, new PackageDescriptorImpl(explicitClassName, new UrlInputStreamAccess(packageInfoFileUrl)));
                    continue;
                }
                LOG.debugf("Unable to resolve class [%s] named in persistence unit [%s]", (Object)explicitClassName, (Object)this.persistenceUnit.getName());
            }
        }
        return new DeploymentResources(){

            @Override
            public Iterable<ClassDescriptor> getClassDescriptors() {
                return classDescriptorMap.values();
            }

            @Override
            public Iterable<PackageDescriptor> getPackageDescriptors() {
                return packageDescriptorMap.values();
            }

            @Override
            public Iterable<MappingFileDescriptor> getMappingFileDescriptors() {
                return mappingFileDescriptors;
            }
        };
    }

    private MappingFileDescriptor buildMappingFileDescriptor(String name, BootstrapServiceRegistry bootstrapServiceRegistry) {
        URL url = bootstrapServiceRegistry.getService(ClassLoaderService.class).locateResource(name);
        if (url == null) {
            throw this.persistenceException("Unable to resolve named mapping-file [" + name + "]");
        }
        return new MappingFileDescriptorImpl(name, new UrlInputStreamAccess(url));
    }

    public Map getConfigurationValues() {
        return Collections.unmodifiableMap(this.configurationValues);
    }

    public Configuration getHibernateConfiguration() {
        return this.hibernateConfiguration;
    }

    private MetadataSources prepareMetadataSources(IndexView jandexIndex, DeploymentResources deploymentResources, BootstrapServiceRegistry bootstrapServiceRegistry) {
        List explicitOrmXml;
        MetadataSources metadataSources = new MetadataSources();
        for (ClassDescriptor classDescriptor : deploymentResources.getClassDescriptors()) {
            String className = classDescriptor.getName();
            ClassInfo classInfo = jandexIndex.getClassByName(DotName.createSimple(className));
            if (classInfo == null) {
                metadataSources.annotatedMappingClassNames.add(className);
                continue;
            }
            AnnotationInstance converterAnnotation = JandexHelper.getSingleAnnotation(classInfo.annotations(), JPADotNames.CONVERTER);
            if (converterAnnotation != null) {
                metadataSources.converterDescriptors.add(new MetadataSources.ConverterDescriptor(className, JandexHelper.getValue(converterAnnotation, "autoApply", Boolean.TYPE, bootstrapServiceRegistry.getService(ClassLoaderService.class))));
                continue;
            }
            metadataSources.annotatedMappingClassNames.add(className);
        }
        for (PackageDescriptor packageDescriptor : deploymentResources.getPackageDescriptors()) {
            metadataSources.packageNames.add(packageDescriptor.getName());
        }
        for (MappingFileDescriptor mappingFileDescriptor : deploymentResources.getMappingFileDescriptors()) {
            metadataSources.namedMappingFileInputStreams.add(mappingFileDescriptor.getStreamAccess().asNamedInputStream());
        }
        String explicitHbmXmls = (String)this.configurationValues.remove("hibernate.hbmxml.files");
        if (explicitHbmXmls != null) {
            metadataSources.mappingFileResources.addAll(Arrays.asList(StringHelper.split(", ", explicitHbmXmls)));
        }
        if ((explicitOrmXml = (List)this.configurationValues.remove("hibernate.ejb.xml_files")) != null) {
            metadataSources.mappingFileResources.addAll(explicitOrmXml);
        }
        return metadataSources;
    }

    private IndexView locateOrBuildJandexIndex(DeploymentResources deploymentResources) {
        IndexView jandexIndex = (IndexView)this.configurationValues.get(JANDEX_INDEX);
        if (jandexIndex == null) {
            jandexIndex = this.buildJandexIndex(deploymentResources);
        }
        return jandexIndex;
    }

    private IndexView buildJandexIndex(DeploymentResources deploymentResources) {
        Indexer indexer = new Indexer();
        for (ClassDescriptor classDescriptor : deploymentResources.getClassDescriptors()) {
            this.indexStream(indexer, classDescriptor.getStreamAccess());
        }
        for (PackageDescriptor packageDescriptor : deploymentResources.getPackageDescriptors()) {
            this.indexStream(indexer, packageDescriptor.getStreamAccess());
        }
        return indexer.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexStream(Indexer indexer, InputStreamAccess streamAccess) {
        try {
            InputStream stream = streamAccess.accessInputStream();
            try {
                indexer.index(stream);
            }
            finally {
                try {
                    stream.close();
                }
                catch (Exception ignore) {}
            }
        }
        catch (IOException e) {
            throw this.persistenceException("Unable to index from stream " + streamAccess.getStreamName(), e);
        }
    }

    private BootstrapServiceRegistry buildBootstrapServiceRegistry(Map integrationSettings) {
        StrategyRegistrationProviderList strategyRegistrationProviderList;
        BootstrapServiceRegistryBuilder bootstrapServiceRegistryBuilder = new BootstrapServiceRegistryBuilder();
        bootstrapServiceRegistryBuilder.with(new JpaIntegrator());
        IntegratorProvider integratorProvider = (IntegratorProvider)integrationSettings.get(INTEGRATOR_PROVIDER);
        if (integratorProvider != null) {
            for (Integrator integrator : integratorProvider.getIntegrators()) {
                bootstrapServiceRegistryBuilder.with(integrator);
            }
        }
        if ((strategyRegistrationProviderList = (StrategyRegistrationProviderList)integrationSettings.get(STRATEGY_REGISTRATION_PROVIDERS)) != null) {
            for (StrategyRegistrationProvider strategyRegistrationProvider : strategyRegistrationProviderList.getStrategyRegistrationProviders()) {
                bootstrapServiceRegistryBuilder.withStrategySelectors(strategyRegistrationProvider);
            }
        }
        ClassLoader appClassLoader = (ClassLoader)integrationSettings.get("hibernate.classLoader.application");
        ClassLoader classLoader = this.providedClassLoader != null ? this.providedClassLoader : (appClassLoader != null ? appClassLoader : this.persistenceUnit.getClassLoader());
        bootstrapServiceRegistryBuilder.with(classLoader);
        return bootstrapServiceRegistryBuilder.build();
    }

    private Map mergePropertySources(PersistenceUnitDescriptor persistenceUnit, Map integrationSettings, final BootstrapServiceRegistry bootstrapServiceRegistry) {
        String cfgXmlResourceName2;
        HashMap<Object, Object> merged = new HashMap<Object, Object>();
        if (persistenceUnit.getProperties() != null) {
            merged.putAll(persistenceUnit.getProperties());
        }
        merged.put("hibernate.ejb.persistenceUnitName", persistenceUnit.getName());
        ValueHolder<2> configLoaderHolder = new ValueHolder<2>(new ValueHolder.DeferredInitializer<ConfigLoader>(){

            @Override
            public ConfigLoader initialize() {
                return new ConfigLoader(bootstrapServiceRegistry);
            }
        });
        String cfgXmlResourceName1 = (String)merged.remove("hibernate.ejb.cfgfile");
        if (StringHelper.isNotEmpty(cfgXmlResourceName1)) {
            JaxbHibernateConfiguration configurationElement = ((ConfigLoader)((Object)configLoaderHolder.getValue())).loadConfigXmlResource(cfgXmlResourceName1);
            this.processHibernateConfigurationElement(configurationElement, merged);
        }
        if (StringHelper.isNotEmpty(cfgXmlResourceName2 = (String)integrationSettings.get("hibernate.ejb.cfgfile"))) {
            integrationSettings.remove("hibernate.ejb.cfgfile");
            JaxbHibernateConfiguration configurationElement = ((ConfigLoader)((Object)configLoaderHolder.getValue())).loadConfigXmlResource(cfgXmlResourceName2);
            this.processHibernateConfigurationElement(configurationElement, merged);
        }
        merged.putAll(integrationSettings);
        if (!merged.containsKey("javax.persistence.validation.mode") && persistenceUnit.getValidationMode() != null) {
            merged.put("javax.persistence.validation.mode", (Object)persistenceUnit.getValidationMode());
        }
        if (!merged.containsKey("javax.persistence.sharedCache.mode") && persistenceUnit.getSharedCacheMode() != null) {
            merged.put("javax.persistence.sharedCache.mode", (Object)persistenceUnit.getSharedCacheMode());
        }
        Iterator itr = merged.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry entry = itr.next();
            if (entry.getValue() != null) continue;
            itr.remove();
        }
        return merged;
    }

    private void processHibernateConfigurationElement(JaxbHibernateConfiguration configurationElement, Map mergeMap) {
        String cfgName;
        if (!mergeMap.containsKey("hibernate.session_factory_name") && (cfgName = configurationElement.getSessionFactory().getName()) != null) {
            mergeMap.put("hibernate.session_factory_name", cfgName);
        }
        for (JaxbHibernateConfiguration.JaxbSessionFactory.JaxbProperty jaxbProperty : configurationElement.getSessionFactory().getProperty()) {
            mergeMap.put(jaxbProperty.getName(), jaxbProperty.getValue());
        }
        for (JaxbHibernateConfiguration.JaxbSessionFactory.JaxbMapping jaxbMapping : configurationElement.getSessionFactory().getMapping()) {
            this.cfgXmlNamedMappings.add(jaxbMapping);
        }
        for (Object cacheDeclaration : configurationElement.getSessionFactory().getClassCacheOrCollectionCache()) {
            if (JaxbHibernateConfiguration.JaxbSessionFactory.JaxbClassCache.class.isInstance(cacheDeclaration)) {
                JaxbHibernateConfiguration.JaxbSessionFactory.JaxbClassCache jaxbClassCache = (JaxbHibernateConfiguration.JaxbSessionFactory.JaxbClassCache)cacheDeclaration;
                this.cacheRegionDefinitions.add(new CacheRegionDefinition(CacheRegionDefinition.CacheType.ENTITY, jaxbClassCache.getClazz(), jaxbClassCache.getUsage().value(), jaxbClassCache.getRegion(), "all".equals(jaxbClassCache.getInclude())));
                continue;
            }
            JaxbHibernateConfiguration.JaxbSessionFactory.JaxbCollectionCache jaxbCollectionCache = (JaxbHibernateConfiguration.JaxbSessionFactory.JaxbCollectionCache)cacheDeclaration;
            this.cacheRegionDefinitions.add(new CacheRegionDefinition(CacheRegionDefinition.CacheType.COLLECTION, jaxbCollectionCache.getCollection(), jaxbCollectionCache.getUsage().value(), jaxbCollectionCache.getRegion(), false));
        }
        if (configurationElement.getSecurity() != null) {
            for (JaxbHibernateConfiguration.JaxbSecurity.JaxbGrant grant : configurationElement.getSecurity().getGrant()) {
                this.grantedJaccPermissions.add(new GrantedPermission(grant.getRole(), grant.getEntityName(), grant.getActions()));
            }
        }
    }

    private void addJaccDefinition(String key, Object value) {
        if (this.jaccContextId == null) {
            this.jaccContextId = (String)this.configurationValues.get("hibernate.jacc_context_id");
            if (this.jaccContextId == null) {
                throw this.persistenceException("Entities have been configured for JACC, but hibernate.jacc_context_id has not been set");
            }
        }
        try {
            int roleStart = "hibernate.jacc".length() + 1;
            String role = key.substring(roleStart, key.indexOf(46, roleStart));
            int classStart = roleStart + role.length() + 1;
            String clazz = key.substring(classStart, key.length());
            this.grantedJaccPermissions.add(new GrantedPermission(role, clazz, (String)value));
        }
        catch (IndexOutOfBoundsException e) {
            throw this.persistenceException("Illegal usage of hibernate.jacc: " + key);
        }
    }

    private void addCacheRegionDefinition(String role, String value, CacheRegionDefinition.CacheType cacheType) {
        StringTokenizer params = new StringTokenizer(value, ";, ");
        if (!params.hasMoreTokens()) {
            StringBuilder error = new StringBuilder("Illegal usage of ");
            if (cacheType == CacheRegionDefinition.CacheType.ENTITY) {
                error.append("hibernate.ejb.classcache").append(": ").append("hibernate.ejb.classcache");
            } else {
                error.append("hibernate.ejb.collectioncache").append(": ").append("hibernate.ejb.collectioncache");
            }
            error.append('.').append(role).append(' ').append(value).append(".  Was expecting configuration, but found none");
            throw this.persistenceException(error.toString());
        }
        String usage = params.nextToken();
        String region = null;
        if (params.hasMoreTokens()) {
            region = params.nextToken();
        }
        boolean lazyProperty = true;
        if (cacheType == CacheRegionDefinition.CacheType.ENTITY) {
            if (params.hasMoreTokens()) {
                lazyProperty = "all".equalsIgnoreCase(params.nextToken());
            }
        } else {
            lazyProperty = false;
        }
        CacheRegionDefinition def = new CacheRegionDefinition(cacheType, role, usage, region, lazyProperty);
        this.cacheRegionDefinitions.add(def);
    }

    private ScanResult scan(BootstrapServiceRegistry bootstrapServiceRegistry) {
        Scanner scanner = this.locateOrBuildScanner(bootstrapServiceRegistry);
        ScanOptions scanOptions = this.determineScanOptions();
        return scanner.scan(this.persistenceUnit, scanOptions);
    }

    private ScanOptions determineScanOptions() {
        return new StandardScanOptions((String)this.configurationValues.get("hibernate.archive.autodetection"), this.persistenceUnit.isExcludeUnlistedClasses());
    }

    private Scanner locateOrBuildScanner(BootstrapServiceRegistry bootstrapServiceRegistry) {
        Class scannerClass;
        Object value = this.configurationValues.remove("hibernate.ejb.resource_scanner");
        if (value == null) {
            return new StandardScanner();
        }
        if (Scanner.class.isInstance(value)) {
            return (Scanner)value;
        }
        if (Class.class.isInstance(value)) {
            try {
                scannerClass = (Class)value;
            }
            catch (ClassCastException e) {
                throw this.persistenceException("Expecting Scanner implementation, but found " + ((Class)value).getName());
            }
        }
        String scannerClassName = value.toString();
        try {
            scannerClass = bootstrapServiceRegistry.getService(ClassLoaderService.class).classForName(scannerClassName);
        }
        catch (ClassCastException e) {
            throw this.persistenceException("Expecting Scanner implementation, but found " + scannerClassName);
        }
        try {
            return (Scanner)scannerClass.newInstance();
        }
        catch (Exception e) {
            throw this.persistenceException("Unable to instantiate Scanner class: " + scannerClass, e);
        }
    }

    @Override
    public EntityManagerFactoryBuilder withValidatorFactory(Object validatorFactory) {
        this.validatorFactory = validatorFactory;
        if (validatorFactory != null) {
            BeanValidationIntegrator.validateFactory(validatorFactory);
        }
        return this;
    }

    @Override
    public EntityManagerFactoryBuilder withDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void generateSchema() {
        this.processProperties();
        final ServiceRegistry serviceRegistry = this.buildServiceRegistry();
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        ((ClassLoaderServiceImpl)classLoaderService).withTccl(new ClassLoaderServiceImpl.Work(){

            public Object perform() {
                Configuration hibernateConfiguration = EntityManagerFactoryBuilderImpl.this.buildHibernateConfiguration(serviceRegistry);
                try {
                    hibernateConfiguration.buildSessionFactory(serviceRegistry);
                }
                catch (MappingException e) {
                    throw EntityManagerFactoryBuilderImpl.this.persistenceException("Unable to build Hibernate SessionFactory", e);
                }
                JpaSchemaGenerator.performGeneration(hibernateConfiguration, serviceRegistry);
                return null;
            }

            @Override
            public Map getConfigurationValues() {
                return EntityManagerFactoryBuilderImpl.this.configurationValues;
            }
        });
        this.cancel();
    }

    @Override
    public EntityManagerFactory build() {
        this.processProperties();
        final ServiceRegistry serviceRegistry = this.buildServiceRegistry();
        ClassLoaderService classLoaderService = serviceRegistry.getService(ClassLoaderService.class);
        return ((ClassLoaderServiceImpl)classLoaderService).withTccl(new ClassLoaderServiceImpl.Work<EntityManagerFactoryImpl>(){

            @Override
            public EntityManagerFactoryImpl perform() {
                SessionFactoryImplementor sessionFactory;
                EntityManagerFactoryBuilderImpl.this.hibernateConfiguration = EntityManagerFactoryBuilderImpl.this.buildHibernateConfiguration(serviceRegistry);
                try {
                    sessionFactory = (SessionFactoryImplementor)EntityManagerFactoryBuilderImpl.this.hibernateConfiguration.buildSessionFactory(serviceRegistry);
                }
                catch (MappingException e) {
                    throw EntityManagerFactoryBuilderImpl.this.persistenceException("Unable to build Hibernate SessionFactory", e);
                }
                JpaSchemaGenerator.performGeneration(EntityManagerFactoryBuilderImpl.this.hibernateConfiguration, serviceRegistry);
                if (EntityManagerFactoryBuilderImpl.this.suppliedSessionFactoryObserver != null) {
                    sessionFactory.addObserver(EntityManagerFactoryBuilderImpl.this.suppliedSessionFactoryObserver);
                }
                sessionFactory.addObserver(new ServiceRegistryCloser());
                return new EntityManagerFactoryImpl(EntityManagerFactoryBuilderImpl.this.persistenceUnit.getName(), sessionFactory, EntityManagerFactoryBuilderImpl.this.settings, EntityManagerFactoryBuilderImpl.this.configurationValues, EntityManagerFactoryBuilderImpl.this.hibernateConfiguration);
            }

            @Override
            public Map getConfigurationValues() {
                return EntityManagerFactoryBuilderImpl.this.configurationValues;
            }
        });
    }

    private void processProperties() {
        this.applyJdbcConnectionProperties();
        this.applyTransactionProperties();
        Object validationFactory = this.validatorFactory;
        if (validationFactory == null) {
            validationFactory = this.configurationValues.get("javax.persistence.validation.factory");
        }
        if (validationFactory != null) {
            BeanValidationIntegrator.validateFactory(validationFactory);
            this.serviceRegistryBuilder.applySetting("javax.persistence.validation.factory", validationFactory);
            this.configurationValues.put("javax.persistence.validation.factory", this.validatorFactory);
        }
        if ("true".equals(this.configurationValues.get("hibernate.transaction.flush_before_completion"))) {
            this.serviceRegistryBuilder.applySetting("hibernate.transaction.flush_before_completion", "false");
            LOG.definingFlushBeforeCompletionIgnoredInHem("hibernate.transaction.flush_before_completion");
        }
        StrategySelector strategySelector = this.serviceRegistryBuilder.getBootstrapServiceRegistry().getService(StrategySelector.class);
        for (Map.Entry oEntry : this.configurationValues.entrySet()) {
            Map.Entry entry = oEntry;
            if (!(entry.getKey() instanceof String)) continue;
            String keyString = (String)entry.getKey();
            if ("hibernate.ejb.interceptor".equals(keyString)) {
                this.sessionFactoryInterceptor = strategySelector.resolveStrategy(Interceptor.class, entry.getValue());
                continue;
            }
            if ("hibernate.ejb.interceptor.session_scoped".equals(keyString)) {
                this.settings.setSessionInterceptorClass(this.loadSessionInterceptorClass(entry.getValue(), strategySelector));
                continue;
            }
            if ("hibernate.ejb.naming_strategy".equals(keyString)) {
                this.namingStrategy = strategySelector.resolveStrategy(NamingStrategy.class, entry.getValue());
                continue;
            }
            if ("hibernate.ejb.naming_strategy_delegator".equals(keyString)) {
                this.namingStrategyDelegator = strategySelector.resolveStrategy(NamingStrategyDelegator.class, entry.getValue());
                continue;
            }
            if ("hibernate.ejb.session_factory_observer".equals(keyString)) {
                this.suppliedSessionFactoryObserver = strategySelector.resolveStrategy(SessionFactoryObserver.class, entry.getValue());
                continue;
            }
            if ("hibernate.ejb.discard_pc_on_close".equals(keyString)) {
                this.settings.setReleaseResourcesOnCloseEnabled("true".equals(entry.getValue()));
                continue;
            }
            if (keyString.startsWith("hibernate.ejb.classcache")) {
                this.addCacheRegionDefinition(keyString.substring("hibernate.ejb.classcache".length() + 1), (String)entry.getValue(), CacheRegionDefinition.CacheType.ENTITY);
                continue;
            }
            if (keyString.startsWith("hibernate.ejb.collectioncache")) {
                this.addCacheRegionDefinition(keyString.substring("hibernate.ejb.collectioncache".length() + 1), (String)entry.getValue(), CacheRegionDefinition.CacheType.COLLECTION);
                continue;
            }
            if (!keyString.startsWith("hibernate.jacc") || keyString.equals("hibernate.jacc_context_id") || keyString.equals("hibernate.jacc.enabled")) continue;
            this.addJaccDefinition((String)entry.getKey(), entry.getValue());
        }
    }

    private void applyJdbcConnectionProperties() {
        if (this.dataSource != null) {
            this.serviceRegistryBuilder.applySetting("hibernate.connection.datasource", this.dataSource);
        } else if (this.persistenceUnit.getJtaDataSource() != null) {
            if (!this.serviceRegistryBuilder.getSettings().containsKey("hibernate.connection.datasource")) {
                this.serviceRegistryBuilder.applySetting("hibernate.connection.datasource", this.persistenceUnit.getJtaDataSource());
                this.configurationValues.put("javax.persistence.jtaDataSource", this.persistenceUnit.getJtaDataSource());
            }
        } else if (this.persistenceUnit.getNonJtaDataSource() != null) {
            if (!this.serviceRegistryBuilder.getSettings().containsKey("hibernate.connection.datasource")) {
                this.serviceRegistryBuilder.applySetting("hibernate.connection.datasource", this.persistenceUnit.getNonJtaDataSource());
                this.configurationValues.put("javax.persistence.nonJtaDataSource", this.persistenceUnit.getNonJtaDataSource());
            }
        } else {
            String pass;
            String user;
            String url;
            String driver = (String)this.configurationValues.get("javax.persistence.jdbc.driver");
            if (StringHelper.isNotEmpty(driver)) {
                this.serviceRegistryBuilder.applySetting("hibernate.connection.driver_class", driver);
            }
            if (StringHelper.isNotEmpty(url = (String)this.configurationValues.get("javax.persistence.jdbc.url"))) {
                this.serviceRegistryBuilder.applySetting("hibernate.connection.url", url);
            }
            if (StringHelper.isNotEmpty(user = (String)this.configurationValues.get("javax.persistence.jdbc.user"))) {
                this.serviceRegistryBuilder.applySetting("hibernate.connection.username", user);
            }
            if (StringHelper.isNotEmpty(pass = (String)this.configurationValues.get("javax.persistence.jdbc.password"))) {
                this.serviceRegistryBuilder.applySetting("hibernate.connection.password", pass);
            }
        }
    }

    private void applyTransactionProperties() {
        PersistenceUnitTransactionType txnType = PersistenceUnitTransactionTypeHelper.interpretTransactionType(this.configurationValues.get("javax.persistence.transactionType"));
        if (txnType == null) {
            txnType = this.persistenceUnit.getTransactionType();
        }
        if (txnType == null) {
            txnType = PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        this.settings.setTransactionType(txnType);
        boolean hasTxStrategy = this.configurationValues.containsKey("hibernate.transaction.factory_class");
        if (hasTxStrategy) {
            LOG.overridingTransactionStrategyDangerous("hibernate.transaction.factory_class");
        } else if (txnType == PersistenceUnitTransactionType.JTA) {
            this.serviceRegistryBuilder.applySetting("hibernate.transaction.factory_class", CMTTransactionFactory.class);
        } else if (txnType == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            this.serviceRegistryBuilder.applySetting("hibernate.transaction.factory_class", JdbcTransactionFactory.class);
        }
    }

    private Class<? extends Interceptor> loadSessionInterceptorClass(Object value, StrategySelector strategySelector) {
        if (value == null) {
            return null;
        }
        return Class.class.isInstance(value) ? (Class<Interceptor>)value : strategySelector.selectStrategyImplementor(Interceptor.class, value.toString());
    }

    public ServiceRegistry buildServiceRegistry() {
        return this.serviceRegistryBuilder.build();
    }

    public Configuration buildHibernateConfiguration(ServiceRegistry serviceRegistry) {
        Object strategyProviderValue;
        IdentifierGeneratorStrategyProvider strategyProvider;
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.configurationValues);
        Configuration cfg = new Configuration();
        cfg.getProperties().putAll((Map<?, ?>)props);
        cfg.setEntityNotFoundDelegate(jpaEntityNotFoundDelegate);
        if (this.namingStrategy != null && this.namingStrategyDelegator != null) {
            throw this.persistenceException("hibernate.ejb.naming_strategy and hibernate.ejb.naming_strategy_delegator properties cannot be used together. To be valid, only one of these properties can be set.");
        }
        if (this.namingStrategy != null) {
            cfg.setNamingStrategy(this.namingStrategy);
        } else if (this.namingStrategyDelegator != null) {
            cfg.setNamingStrategyDelegator(this.namingStrategyDelegator);
        }
        if (this.sessionFactoryInterceptor != null) {
            cfg.setInterceptor(this.sessionFactoryInterceptor);
        }
        IdentifierGeneratorStrategyProvider identifierGeneratorStrategyProvider = strategyProvider = (strategyProviderValue = props.get("hibernate.ejb.identifier_generator_strategy_provider")) == null ? null : serviceRegistry.getService(StrategySelector.class).resolveStrategy(IdentifierGeneratorStrategyProvider.class, strategyProviderValue);
        if (strategyProvider != null) {
            MutableIdentifierGeneratorFactory identifierGeneratorFactory = cfg.getIdentifierGeneratorFactory();
            for (Map.Entry<String, Class<?>> entry : strategyProvider.getStrategies().entrySet()) {
                identifierGeneratorFactory.register(entry.getKey(), entry.getValue());
            }
        }
        if (this.grantedJaccPermissions != null) {
            JaccService jaccService = serviceRegistry.getService(JaccService.class);
            for (GrantedPermission grantedPermission : this.grantedJaccPermissions) {
                jaccService.addPermission(grantedPermission);
            }
        }
        if (this.cacheRegionDefinitions != null) {
            for (CacheRegionDefinition cacheRegionDefinition : this.cacheRegionDefinitions) {
                if (cacheRegionDefinition.cacheType == CacheRegionDefinition.CacheType.ENTITY) {
                    cfg.setCacheConcurrencyStrategy(cacheRegionDefinition.role, cacheRegionDefinition.usage, cacheRegionDefinition.region, cacheRegionDefinition.cacheLazy);
                    continue;
                }
                cfg.setCollectionCacheConcurrencyStrategy(cacheRegionDefinition.role, cacheRegionDefinition.usage, cacheRegionDefinition.region);
            }
        }
        for (JaxbHibernateConfiguration.JaxbSessionFactory.JaxbMapping jaxbMapping : this.cfgXmlNamedMappings) {
            if (jaxbMapping.getClazz() != null) {
                cfg.addAnnotatedClass(serviceRegistry.getService(ClassLoaderService.class).classForName(jaxbMapping.getClazz()));
                continue;
            }
            if (jaxbMapping.getResource() != null) {
                cfg.addResource(jaxbMapping.getResource());
                continue;
            }
            if (jaxbMapping.getJar() != null) {
                cfg.addJar(new File(jaxbMapping.getJar()));
                continue;
            }
            if (jaxbMapping.getPackage() == null) continue;
            cfg.addPackage(jaxbMapping.getPackage());
        }
        List loadedAnnotatedClasses = (List)this.configurationValues.remove("hibernate.ejb.loaded.classes");
        if (loadedAnnotatedClasses != null) {
            for (Class cls : loadedAnnotatedClasses) {
                if (AttributeConverter.class.isAssignableFrom(cls)) {
                    cfg.addAttributeConverter(cls);
                    continue;
                }
                cfg.addAnnotatedClass(cls);
            }
        }
        for (String className : this.metadataSources.getAnnotatedMappingClassNames()) {
            cfg.addAnnotatedClass(serviceRegistry.getService(ClassLoaderService.class).classForName(className));
        }
        for (MetadataSources.ConverterDescriptor converterDescriptor : this.metadataSources.getConverterDescriptors()) {
            Class converterClass;
            try {
                Class theClass;
                converterClass = theClass = serviceRegistry.getService(ClassLoaderService.class).classForName(converterDescriptor.converterClassName);
            }
            catch (ClassCastException e) {
                throw this.persistenceException(String.format("AttributeConverter implementation [%s] does not implement AttributeConverter interface", converterDescriptor.converterClassName));
            }
            cfg.addAttributeConverter(converterClass, converterDescriptor.autoApply);
        }
        for (String resourceName : this.metadataSources.mappingFileResources) {
            Boolean useMetaInf = null;
            try {
                if (resourceName.endsWith(META_INF_ORM_XML)) {
                    useMetaInf = true;
                }
                cfg.addResource(resourceName);
            }
            catch (MappingNotFoundException e) {
                if (!resourceName.endsWith(META_INF_ORM_XML)) {
                    throw this.persistenceException("Unable to find XML mapping file in classpath: " + resourceName);
                }
                useMetaInf = false;
            }
            catch (MappingException me) {
                throw this.persistenceException("Error while reading JPA XML file: " + resourceName, me);
            }
            if (Boolean.TRUE.equals(useMetaInf)) {
                LOG.exceptionHeaderFound(this.getExceptionHeader(), META_INF_ORM_XML);
                continue;
            }
            if (!Boolean.FALSE.equals(useMetaInf)) continue;
            LOG.exceptionHeaderNotFound(this.getExceptionHeader(), META_INF_ORM_XML);
        }
        for (NamedInputStream namedInputStream : this.metadataSources.namedMappingFileInputStreams) {
            try {
                cfg.addInputStream(new BufferedInputStream(namedInputStream.getStream()));
            }
            catch (InvalidMappingException e) {
                if (StringHelper.isNotEmpty(namedInputStream.getName())) {
                    throw new InvalidMappingException("Error while parsing file: " + namedInputStream.getName(), e.getType(), e.getPath(), e);
                }
                throw e;
            }
            catch (MappingException me) {
                if (StringHelper.isNotEmpty(namedInputStream.getName())) {
                    throw new MappingException("Error while parsing file: " + namedInputStream.getName(), me);
                }
                throw me;
            }
        }
        for (String packageName : this.metadataSources.packageNames) {
            cfg.addPackage(packageName);
        }
        TypeContributorList typeContributorList = (TypeContributorList)this.configurationValues.get(TYPE_CONTRIBUTORS);
        if (typeContributorList != null) {
            this.configurationValues.remove(TYPE_CONTRIBUTORS);
            for (TypeContributor typeContributor : typeContributorList.getTypeContributors()) {
                cfg.registerTypeContributor(typeContributor);
            }
        }
        return cfg;
    }

    private PersistenceException persistenceException(String message) {
        return this.persistenceException(message, null);
    }

    private PersistenceException persistenceException(String message, Exception cause) {
        return new PersistenceException(this.getExceptionHeader() + message, cause);
    }

    private String getExceptionHeader() {
        return "[PersistenceUnit: " + this.persistenceUnit.getName() + "] ";
    }

    public static class MetadataSources {
        private final List<String> annotatedMappingClassNames = new ArrayList<String>();
        private final List<ConverterDescriptor> converterDescriptors = new ArrayList<ConverterDescriptor>();
        private final List<NamedInputStream> namedMappingFileInputStreams = new ArrayList<NamedInputStream>();
        private final List<String> mappingFileResources = new ArrayList<String>();
        private final List<String> packageNames = new ArrayList<String>();

        public List<String> getAnnotatedMappingClassNames() {
            return this.annotatedMappingClassNames;
        }

        public List<ConverterDescriptor> getConverterDescriptors() {
            return this.converterDescriptors;
        }

        public List<NamedInputStream> getNamedMappingFileInputStreams() {
            return this.namedMappingFileInputStreams;
        }

        public List<String> getPackageNames() {
            return this.packageNames;
        }

        public List<String> collectMappingClassNames() {
            return this.annotatedMappingClassNames;
        }

        public static class ConverterDescriptor {
            private final String converterClassName;
            private final boolean autoApply;

            public ConverterDescriptor(String converterClassName, boolean autoApply) {
                this.converterClassName = converterClassName;
                this.autoApply = autoApply;
            }
        }
    }

    public static class JaccDefinition {
        public final String contextId;
        public final String role;
        public final String clazz;
        public final String actions;

        public JaccDefinition(String contextId, String role, String clazz, String actions) {
            this.contextId = contextId;
            this.role = role;
            this.clazz = clazz;
            this.actions = actions;
        }
    }

    public static class CacheRegionDefinition {
        public final CacheType cacheType;
        public final String role;
        public final String usage;
        public final String region;
        public final boolean cacheLazy;

        public CacheRegionDefinition(CacheType cacheType, String role, String usage, String region, boolean cacheLazy) {
            this.cacheType = cacheType;
            this.role = role;
            this.usage = usage;
            this.region = region;
            this.cacheLazy = cacheLazy;
        }

        public static enum CacheType {
            ENTITY,
            COLLECTION;

        }
    }

    public static class ServiceRegistryCloser
    implements SessionFactoryObserver {
        @Override
        public void sessionFactoryCreated(SessionFactory sessionFactory) {
        }

        @Override
        public void sessionFactoryClosed(SessionFactory sessionFactory) {
            SessionFactoryImplementor sfi = (SessionFactoryImplementor)sessionFactory;
            sfi.getServiceRegistry().destroy();
            ServiceRegistry basicRegistry = sfi.getServiceRegistry().getParentServiceRegistry();
            ((ServiceRegistryImplementor)basicRegistry).destroy();
        }
    }

    private static interface DeploymentResources {
        public Iterable<ClassDescriptor> getClassDescriptors();

        public Iterable<PackageDescriptor> getPackageDescriptors();

        public Iterable<MappingFileDescriptor> getMappingFileDescriptors();
    }

    private static class JpaEntityNotFoundDelegate
    implements EntityNotFoundDelegate,
    Serializable {
        private JpaEntityNotFoundDelegate() {
        }

        @Override
        public void handleEntityNotFound(String entityName, Serializable id) {
            throw new EntityNotFoundException("Unable to find " + entityName + " with id " + id);
        }
    }
}

